/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.utils.NumberUtils;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Quadruple;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.io.Serializable;
import net.jafama.FastMath;

public class QuaternionDouble
implements Serializable {
    private static final long serialVersionUID = -7661875440774897168L;
    private static final double NORMALIZATION_TOLERANCE = 1.0E-5;
    private static final QuaternionDouble tmp1 = new QuaternionDouble(0.0, 0.0, 0.0, 0.0);
    private static final QuaternionDouble tmp2 = new QuaternionDouble(0.0, 0.0, 0.0, 0.0);
    private static final Matrix4D tmpMat = new Matrix4D();
    private static final Vector3D v3d1 = new Vector3D();
    public double x;
    public double y;
    public double z;
    public double w;

    public QuaternionDouble(double x, double y, double z, double w) {
        this.set(x, y, z, w);
    }

    public QuaternionDouble() {
        this.idt();
    }

    public QuaternionDouble(QuaternionDouble quaternion) {
        this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public QuaternionDouble(Quaternion quaternion) {
        this.set(quaternion);
    }

    public QuaternionDouble(Vector3D axis, double angle) {
        this.set(axis, angle);
    }

    public static double len(double x, double y, double z, double w) {
        return FastMath.sqrt((double)(x * x + y * y + z * z + w * w));
    }

    public static double len2(double x, double y, double z, double w) {
        return x * x + y * y + z * z + w * w;
    }

    public static double dot(double x1, double y1, double z1, double w1, double x2, double y2, double z2, double w2) {
        return x1 * x2 + y1 * y2 + z1 * z2 + w1 * w2;
    }

    public QuaternionDouble set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public QuaternionDouble set(Quadruple x, Quadruple y, Quadruple z, Quadruple w) {
        this.x = x.doubleValue();
        this.y = y.doubleValue();
        this.z = z.doubleValue();
        this.w = w.doubleValue();
        return this;
    }

    public QuaternionDouble set(QuaternionDouble quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public QuaternionDouble set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public QuaternionDouble set(Vector3D axis, double angle) {
        return this.setFromAxis(axis.x, axis.y, axis.z, angle);
    }

    public QuaternionDouble cpy() {
        return new QuaternionDouble(this);
    }

    public double len() {
        return FastMath.sqrt((double)(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w));
    }

    public String toString() {
        return "[" + this.x + "|" + this.y + "|" + this.z + "|" + this.w + "]";
    }

    public QuaternionDouble setEulerAngles(double yaw, double pitch, double roll) {
        return this.setEulerAnglesRad(yaw * (Math.PI / 180), pitch * (Math.PI / 180), roll * (Math.PI / 180));
    }

    public QuaternionDouble setEulerAnglesRad(double yaw, double pitch, double roll) {
        double hr = roll * 0.5;
        double shr = FastMath.sin((double)hr);
        double chr = FastMath.cos((double)hr);
        double hp = pitch * 0.5;
        double shp = FastMath.sin((double)hp);
        double chp = FastMath.cos((double)hp);
        double hy = yaw * 0.5;
        double shy = FastMath.sin((double)hy);
        double chy = FastMath.cos((double)hy);
        double chy_shp = chy * shp;
        double shy_chp = shy * chp;
        double chy_chp = chy * chp;
        double shy_shp = shy * shp;
        this.x = chy_shp * chr + shy_chp * shr;
        this.y = shy_chp * chr - chy_shp * shr;
        this.z = chy_chp * shr - shy_shp * chr;
        this.w = chy_chp * chr + shy_shp * shr;
        return this;
    }

    public int getGimbalPole() {
        double t = this.y * this.x + this.z * this.w;
        return t > (double)0.499f ? 1 : (t < (double)-0.499f ? -1 : 0);
    }

    public double getRollRad() {
        int pole = this.getGimbalPole();
        return pole == 0 ? FastMath.atan2((double)(2.0 * (this.w * this.z + this.y * this.x)), (double)(1.0 - 2.0 * (this.x * this.x + this.z * this.z))) : (double)((float)pole * 2.0f) * FastMath.atan2((double)this.y, (double)this.w);
    }

    public double getRoll() {
        return this.getRollRad() * 57.29577951308232;
    }

    public double getPitchRad() {
        int pole = this.getGimbalPole();
        return pole == 0 ? FastMath.asin((double)(2.0 * (this.w * this.x - this.z * this.y))) : (double)pole * Math.PI * 0.5;
    }

    public double getPitch() {
        return this.getPitchRad() * 57.29577951308232;
    }

    public double getYawRad() {
        return this.getGimbalPole() == 0 ? FastMath.atan2((double)(2.0 * (this.y * this.w + this.x * this.z)), (double)(1.0 - 2.0 * (this.y * this.y + this.x * this.x))) : 0.0;
    }

    public double getYaw() {
        return this.getYawRad() * 57.29577951308232;
    }

    public double len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public QuaternionDouble nor() {
        double len = this.len2();
        if (len != 0.0 && Math.abs(len - 1.0) > 1.0E-5) {
            len = FastMath.sqrt((double)len);
            this.w /= len;
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
        return this;
    }

    public QuaternionDouble conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3D transform(Vector3D v) {
        tmp2.set(this);
        tmp2.conjugate();
        tmp2.mulLeft(tmp1.set(v.x, v.y, v.z, 0.0)).mulLeft(this);
        v.x = QuaternionDouble.tmp2.x;
        v.y = QuaternionDouble.tmp2.y;
        v.z = QuaternionDouble.tmp2.z;
        return v;
    }

    public Vector3Q transform(Vector3Q v) {
        tmp2.set(this);
        tmp2.conjugate();
        tmp2.mulLeft(tmp1.set(v.x.doubleValue(), v.y.doubleValue(), v.z.doubleValue(), 0.0)).mulLeft(this);
        v.set(QuaternionDouble.tmp2.x, QuaternionDouble.tmp2.y, QuaternionDouble.tmp2.z);
        return v;
    }

    public QuaternionDouble inverse() {
        double invNormSqu = 1.0 / (this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
        this.w *= invNormSqu;
        this.x *= -invNormSqu;
        this.y *= -invNormSqu;
        this.z *= -invNormSqu;
        return this;
    }

    public QuaternionDouble mul(QuaternionDouble other) {
        double newX = this.w * other.x + this.x * other.w + this.y * other.z - this.z * other.y;
        double newY = this.w * other.y + this.y * other.w + this.z * other.x - this.x * other.z;
        double newZ = this.w * other.z + this.z * other.w + this.x * other.y - this.y * other.x;
        double newW = this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.w = newW;
        return this;
    }

    public QuaternionDouble mul(double x, double y, double z, double w) {
        double newX = this.w * x + this.x * w + this.y * z - this.z * y;
        double newY = this.w * y + this.y * w + this.z * x - this.x * z;
        double newZ = this.w * z + this.z * w + this.x * y - this.y * x;
        double newW = this.w * w - this.x * x - this.y * y - this.z * z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.w = newW;
        return this;
    }

    public QuaternionDouble mulLeft(QuaternionDouble other) {
        double newX = other.w * this.x + other.x * this.w + other.y * this.z - other.z * this.y;
        double newY = other.w * this.y + other.y * this.w + other.z * this.x - other.x * this.z;
        double newZ = other.w * this.z + other.z * this.w + other.x * this.y - other.y * this.x;
        double newW = other.w * this.w - other.x * this.x - other.y * this.y - other.z * this.z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.w = newW;
        return this;
    }

    public QuaternionDouble mulLeft(double x, double y, double z, double w) {
        double newX = w * this.x + x * this.w + y * this.z - z * y;
        double newY = w * this.y + y * this.w + z * this.x - x * z;
        double newZ = w * this.z + z * this.w + x * this.y - y * x;
        double newW = w * this.w - x * this.x - y * this.y - z * z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.w = newW;
        return this;
    }

    public QuaternionDouble mulInverse(QuaternionDouble q1) {
        QuaternionDouble tempQuat = new QuaternionDouble(q1);
        tempQuat.inverse();
        this.mul(tempQuat);
        return this;
    }

    public QuaternionDouble mulLeftInverse(QuaternionDouble q1) {
        QuaternionDouble tempQuat = new QuaternionDouble(q1);
        tempQuat.inverse();
        this.mulLeft(tempQuat);
        return this;
    }

    public void toMatrix(double[] matrix) {
        double xx = this.x * this.x;
        double xy = this.x * this.y;
        double xz = this.x * this.z;
        double xw = this.x * this.w;
        double yy = this.y * this.y;
        double yz = this.y * this.z;
        double yw = this.y * this.w;
        double zz = this.z * this.z;
        double zw = this.z * this.w;
        matrix[0] = 1.0 - 2.0 * (yy + zz);
        matrix[4] = 2.0 * (xy - zw);
        matrix[8] = 2.0 * (xz + yw);
        matrix[12] = 0.0;
        matrix[1] = 2.0 * (xy + zw);
        matrix[5] = 1.0 - 2.0 * (xx + zz);
        matrix[9] = 2.0 * (yz - xw);
        matrix[13] = 0.0;
        matrix[2] = 2.0 * (xz - yw);
        matrix[6] = 2.0 * (yz + xw);
        matrix[10] = 1.0 - 2.0 * (xx + yy);
        matrix[14] = 0.0;
        matrix[3] = 0.0;
        matrix[7] = 0.0;
        matrix[11] = 0.0;
        matrix[15] = 1.0;
    }

    public QuaternionDouble idt() {
        return this.set(0.0, 0.0, 0.0, 1.0);
    }

    public boolean isIdentity() {
        return MathUtilsDouble.isZero(this.x) && MathUtilsDouble.isZero(this.y) && MathUtilsDouble.isZero(this.z) && MathUtilsDouble.isEqual(this.w, 1.0);
    }

    public boolean isIdentity(double tolerance) {
        return MathUtilsDouble.isZero(this.x, tolerance) && MathUtilsDouble.isZero(this.y, tolerance) && MathUtilsDouble.isZero(this.z, tolerance) && MathUtilsDouble.isEqual(this.w, 1.0, tolerance);
    }

    public QuaternionDouble setFromAxis(Vector3D axis, double degrees) {
        return this.setFromAxis(axis.x, axis.y, axis.z, degrees);
    }

    public QuaternionDouble setFromAxisRad(Vector3D axis, double radians) {
        return this.setFromAxisRad(axis.x, axis.y, axis.z, radians);
    }

    public QuaternionDouble setFromAxis(double x, double y, double z, double degrees) {
        return this.setFromAxisRad(x, y, z, degrees * (Math.PI / 180));
    }

    public QuaternionDouble setFromAxisRad(double x, double y, double z, double radians) {
        double d = Vector3D.len(x, y, z);
        if (d == 0.0) {
            return this.idt();
        }
        d = 1.0 / d;
        double l_ang = radians;
        double l_sin = FastMath.sin((double)(l_ang / 2.0));
        double l_cos = FastMath.cos((double)(l_ang / 2.0));
        return this.set(d * x * l_sin, d * y * l_sin, d * z * l_sin, l_cos).nor();
    }

    public QuaternionDouble setFromMatrix(boolean normalizeAxes, Matrix4D matrix) {
        return this.setFromAxes(normalizeAxes, matrix.val[0], matrix.val[4], matrix.val[8], matrix.val[1], matrix.val[5], matrix.val[9], matrix.val[2], matrix.val[6], matrix.val[10]);
    }

    public QuaternionDouble setFromMatrix(Matrix4D matrix) {
        return this.setFromMatrix(false, matrix);
    }

    public QuaternionDouble setFromAxes(double xx, double xy, double xz, double yx, double yy, double yz, double zx, double zy, double zz) {
        return this.setFromAxes(false, xx, xy, xz, yx, yy, yz, zx, zy, zz);
    }

    public QuaternionDouble setFromCamera(Vector3D direction, Vector3D up) {
        Vector3D side = v3d1.set(direction).crs(up).nor();
        return this.fromAxes(direction, up, side);
    }

    public Vector3D getDirection(Vector3D aux) {
        return aux.set(1.0, 0.0, 0.0).mul(this);
    }

    public Vector3D getUp(Vector3D aux) {
        return aux.set(0.0, 1.0, 0.0).mul(this);
    }

    public QuaternionDouble fromAxes(Vector3D xAxis, Vector3D yAxis, Vector3D zAxis) {
        return this.fromRotationMatrix(xAxis.x, yAxis.x, zAxis.x, xAxis.y, yAxis.y, zAxis.y, xAxis.z, yAxis.z, zAxis.z);
    }

    public QuaternionDouble fromRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double t = m00 + m11 + m22;
        if (t >= 0.0) {
            double s = FastMath.sqrt((double)(t + 1.0));
            this.w = 0.5 * s;
            s = 0.5 / s;
            this.x = (m21 - m12) * s;
            this.y = (m02 - m20) * s;
            this.z = (m10 - m01) * s;
        } else if (m00 > m11 && m00 > m22) {
            double s = FastMath.sqrt((double)(1.0 + m00 - m11 - m22));
            this.x = s * 0.5;
            s = 0.5 / s;
            this.y = (m10 + m01) * s;
            this.z = (m02 + m20) * s;
            this.w = (m21 - m12) * s;
        } else if (m11 > m22) {
            double s = FastMath.sqrt((double)(1.0 + m11 - m00 - m22));
            this.y = s * 0.5;
            s = 0.5 / s;
            this.x = (m10 + m01) * s;
            this.z = (m21 + m12) * s;
            this.w = (m02 - m20) * s;
        } else {
            double s = FastMath.sqrt((double)(1.0 + m22 - m00 - m11));
            this.z = s * 0.5;
            s = 0.5 / s;
            this.x = (m02 + m20) * s;
            this.y = (m21 + m12) * s;
            this.w = (m10 - m01) * s;
        }
        return this;
    }

    public QuaternionDouble setFromAxes(boolean normalizeAxes, double xx, double xy, double xz, double yx, double yy, double yz, double zx, double zy, double zz) {
        double t;
        if (normalizeAxes) {
            double lx = 1.0 / Vector3D.len(xx, xy, xz);
            double ly = 1.0 / Vector3D.len(yx, yy, yz);
            double lz = 1.0 / Vector3D.len(zx, zy, zz);
            xx *= lx;
            xy *= lx;
            xz *= lx;
            yz *= ly;
            yy *= ly;
            yz *= ly;
            zx *= lz;
            zy *= lz;
            zz *= lz;
        }
        if ((t = xx + yy + zz) >= 0.0) {
            s = FastMath.sqrt((double)(t + 1.0));
            this.w = 0.5 * s;
            s = 0.5 / s;
            this.x = (zy - yz) * s;
            this.y = (xz - zx) * s;
            this.z = (yx - xy) * s;
        } else if (xx > yy && xx > zz) {
            s = FastMath.sqrt((double)(1.0 + xx - yy - zz));
            this.x = s * 0.5;
            s = 0.5 / s;
            this.y = (yx + xy) * s;
            this.z = (xz + zx) * s;
            this.w = (zy - yz) * s;
        } else if (yy > zz) {
            s = FastMath.sqrt((double)(1.0 + yy - xx - zz));
            this.y = s * 0.5;
            s = 0.5 / s;
            this.x = (yx + xy) * s;
            this.z = (zy + yz) * s;
            this.w = (xz - zx) * s;
        } else {
            s = FastMath.sqrt((double)(1.0 + zz - xx - yy));
            this.z = s * 0.5;
            s = 0.5 / s;
            this.x = (xz + zx) * s;
            this.y = (zy + yz) * s;
            this.w = (yx - xy) * s;
        }
        return this;
    }

    public QuaternionDouble setFromCross(Vector3D v1, Vector3D v2) {
        double dot = MathUtilsDouble.clamp(v1.dot(v2), -1.0, 1.0);
        double angle = FastMath.acos((double)dot);
        return this.setFromAxisRad(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x, angle);
    }

    public QuaternionDouble setFromCross(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dot = MathUtilsDouble.clamp(Vector3D.dot(x1, y1, z1, x2, y2, z2), -1.0, 1.0);
        double angle = FastMath.acos((double)dot);
        return this.setFromAxisRad(y1 * z2 - z1 * y2, z1 * x2 - x1 * z2, x1 * y2 - y1 * x2, angle);
    }

    public void nlerp(QuaternionDouble q2, double blend) {
        double dot = this.dot(q2);
        double blendI = 1.0 - blend;
        if (dot < 0.0) {
            this.x = blendI * this.x - blend * q2.x;
            this.y = blendI * this.y - blend * q2.y;
            this.z = blendI * this.z - blend * q2.z;
            this.w = blendI * this.w - blend * q2.w;
        } else {
            this.x = blendI * this.x + blend * q2.x;
            this.y = blendI * this.y + blend * q2.y;
            this.z = blendI * this.z + blend * q2.z;
            this.w = blendI * this.w + blend * q2.w;
        }
        this.nor();
    }

    public void slerp(QuaternionDouble end, double alpha) {
        double dot = this.dot(end);
        double absDot = dot < 0.0 ? -dot : dot;
        double scale0 = 1.0 - alpha;
        double scale1 = alpha;
        if (1.0 - absDot > 0.1) {
            double angle = FastMath.acos((double)absDot);
            double invSinTheta = 1.0 / FastMath.sin((double)angle);
            scale0 = Math.sin((1.0 - alpha) * angle) * invSinTheta;
            scale1 = Math.sin(alpha * angle) * invSinTheta;
        }
        if (dot < 0.0) {
            scale1 = -scale1;
        }
        this.x = scale0 * this.x + scale1 * end.x;
        this.y = scale0 * this.y + scale1 * end.y;
        this.z = scale0 * this.z + scale1 * end.z;
        this.w = scale0 * this.w + scale1 * end.w;
    }

    public void slerp2(QuaternionDouble end, double alpha) {
        if (this.x == end.x && this.y == end.y && this.z == end.z && this.w == end.w) {
            return;
        }
        double result = this.x * end.x + this.y * end.y + this.z * end.z + this.w * end.w;
        if (result < 0.0) {
            end.x = -end.x;
            end.y = -end.y;
            end.z = -end.z;
            end.w = -end.w;
            result = -result;
        }
        double scale0 = 1.0 - alpha;
        double scale1 = alpha;
        if (1.0 - result > 0.1) {
            double theta = FastMath.acos((double)result);
            double invSinTheta = 1.0 / FastMath.sin((double)theta);
            scale0 = FastMath.sin((double)((1.0 - alpha) * theta)) * invSinTheta;
            scale1 = FastMath.sin((double)(alpha * theta)) * invSinTheta;
        }
        this.x = scale0 * this.x + scale1 * end.x;
        this.y = scale0 * this.y + scale1 * end.y;
        this.z = scale0 * this.z + scale1 * end.z;
        this.w = scale0 * this.w + scale1 * end.w;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + NumberUtils.floatToRawIntBits((float)((float)this.w));
        result = 31 * result + NumberUtils.floatToRawIntBits((float)((float)this.x));
        result = 31 * result + NumberUtils.floatToRawIntBits((float)((float)this.y));
        result = 31 * result + NumberUtils.floatToRawIntBits((float)((float)this.z));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuaternionDouble)) {
            return false;
        }
        QuaternionDouble other = (QuaternionDouble)obj;
        return NumberUtils.floatToRawIntBits((float)((float)this.w)) == NumberUtils.floatToRawIntBits((float)((float)other.w)) && NumberUtils.floatToRawIntBits((float)((float)this.x)) == NumberUtils.floatToRawIntBits((float)((float)other.x)) && NumberUtils.floatToRawIntBits((float)((float)this.y)) == NumberUtils.floatToRawIntBits((float)((float)other.y)) && NumberUtils.floatToRawIntBits((float)((float)this.z)) == NumberUtils.floatToRawIntBits((float)((float)other.z));
    }

    public double dot(QuaternionDouble other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public double dot(double x, double y, double z, double w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    public QuaternionDouble mul(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public QuaternionDouble mulAdd(QuaternionDouble q, double s) {
        this.x += q.x * s;
        this.y += q.y * s;
        this.z += q.z * s;
        this.w += q.w * s;
        return this;
    }

    public double getAxisAngle(Vector3D axis) {
        return this.getAxisAngleRad(axis) * 57.29577951308232;
    }

    public double getAxisAngleRad(Vector3D axis) {
        if (this.w > 1.0) {
            this.nor();
        }
        double angle = 2.0 * FastMath.acos((double)this.w);
        double s = FastMath.sqrt((double)(1.0 - this.w * this.w));
        if (s < 1.0E-5) {
            axis.x = this.x;
            axis.y = this.y;
            axis.z = this.z;
        } else {
            axis.x = this.x / s;
            axis.y = this.y / s;
            axis.z = this.z / s;
        }
        return angle;
    }

    public double getAngleRad() {
        return 2.0 * FastMath.acos((double)(this.w > 1.0 ? this.w / this.len() : this.w));
    }

    public double getAngle() {
        return this.getAngleRad() * 57.29577951308232;
    }

    public void getSwingTwist(double axisX, double axisY, double axisZ, QuaternionDouble swing, QuaternionDouble twist) {
        double d = Vector3D.dot(this.x, this.y, this.z, axisX, axisY, axisZ);
        twist.set(axisX * d, axisY * d, axisZ * d, this.w).nor();
        swing.set(twist).conjugate().mulLeft(this);
    }

    public void getSwingTwist(Vector3D axis, QuaternionDouble swing, QuaternionDouble twist) {
        this.getSwingTwist(axis.x, axis.y, axis.z, swing, twist);
    }

    public double getAngleAroundRad(double axisX, double axisY, double axisZ) {
        double d = Vector3D.dot(this.x, this.y, this.z, axisX, axisY, axisZ);
        double l2 = QuaternionDouble.len2(axisX * d, axisY * d, axisZ * d, this.w);
        return l2 == 0.0 ? 0.0 : 2.0 * FastMath.acos((double)(this.w / FastMath.sqrt((double)l2)));
    }

    public double getAngleAroundRad(Vector3D axis) {
        return this.getAngleAroundRad(axis.x, axis.y, axis.z);
    }

    public double getAngleAround(double axisX, double axisY, double axisZ) {
        return this.getAngleAroundRad(axisX, axisY, axisZ) * 57.29577951308232;
    }

    public double getAngleAround(Vector3D axis) {
        return this.getAngleAround(axis.x, axis.y, axis.z);
    }

    public double[] values() {
        return new double[]{this.x, this.y, this.z, this.w};
    }
}

