/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.Matrix3;
import gaiasky.util.math.InterpolationDouble;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.VectorDouble;
import net.jafama.FastMath;

public class Vector2D
implements VectorDouble<Vector2D> {
    public static final Vector2D X = new Vector2D(1.0, 0.0);
    public static final Vector2D Y = new Vector2D(0.0, 1.0);
    public static final Vector2D Zero = new Vector2D(0.0, 0.0);
    public double x;
    public double y;

    public Vector2D() {
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Vector2D v) {
        this.set(v);
    }

    public static double len(double x, double y) {
        return FastMath.sqrt((double)(x * x + y * y));
    }

    public static double len2(double x, double y) {
        return x * x + y * y;
    }

    public static double dot(double x1, double y1, double x2, double y2) {
        return x1 * x2 + y1 * y2;
    }

    public static double dst(double x1, double y1, double x2, double y2) {
        double x_d = x2 - x1;
        double y_d = y2 - y1;
        return FastMath.sqrt((double)(x_d * x_d + y_d * y_d));
    }

    public static double dst2(double x1, double y1, double x2, double y2) {
        double x_d = x2 - x1;
        double y_d = y2 - y1;
        return x_d * x_d + y_d * y_d;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    @Override
    public Vector2D cpy() {
        return new Vector2D(this);
    }

    @Override
    public double len() {
        return FastMath.sqrt((double)(this.x * this.x + this.y * this.y));
    }

    @Override
    public double len2() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public Vector2D set(Vector2D v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    @Override
    public Vector2D set(double[] vals) {
        return this.set(vals[0], vals[1]);
    }

    public Vector2D set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    @Override
    public Vector2D sub(Vector2D v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vector2D sub(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    @Override
    public Vector2D nor() {
        double len = this.len();
        if (len != 0.0) {
            this.x /= len;
            this.y /= len;
        }
        return this;
    }

    @Override
    public Vector2D add(Vector2D v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vector2D add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    @Override
    public double dot(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public double dot(double ox, double oy) {
        return this.x * ox + this.y * oy;
    }

    @Override
    public Vector2D scl(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2D scl(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    @Override
    public Vector2D scl(Vector2D v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }

    @Override
    public Vector2D mulAdd(Vector2D vec, double scalar) {
        this.x += vec.x * scalar;
        this.y += vec.y * scalar;
        return this;
    }

    @Override
    public Vector2D mulAdd(Vector2D vec, Vector2D mulVec) {
        this.x += vec.x * mulVec.x;
        this.y += vec.y * mulVec.y;
        return this;
    }

    @Override
    public Vector2D setZero() {
        return null;
    }

    @Override
    public double dst(Vector2D v) {
        double x_d = v.x - this.x;
        double y_d = v.y - this.y;
        return FastMath.sqrt((double)(x_d * x_d + y_d * y_d));
    }

    public double dst(double x, double y) {
        double x_d = x - this.x;
        double y_d = y - this.y;
        return FastMath.sqrt((double)(x_d * x_d + y_d * y_d));
    }

    @Override
    public double dst2(Vector2D v) {
        double x_d = v.x - this.x;
        double y_d = v.y - this.y;
        return x_d * x_d + y_d * y_d;
    }

    public double dst2(double x, double y) {
        double x_d = x - this.x;
        double y_d = y - this.y;
        return x_d * x_d + y_d * y_d;
    }

    @Override
    public Vector2D limit(double limit) {
        return this.limit2(limit * limit);
    }

    @Override
    public Vector2D limit2(double limit2) {
        double len2 = this.len2();
        if (len2 > limit2) {
            return this.scl(Math.sqrt(limit2 / len2));
        }
        return this;
    }

    @Override
    public Vector2D setLength(double len) {
        return null;
    }

    @Override
    public Vector2D setLength2(double len2) {
        return null;
    }

    @Override
    public Vector2D clamp(double min, double max) {
        double l2 = this.len2();
        if (l2 == 0.0) {
            return this;
        }
        if (l2 > max * max) {
            return this.nor().scl(max);
        }
        if (l2 < min * min) {
            return this.nor().scl(min);
        }
        return this;
    }

    public String toString() {
        return "[" + this.x + ":" + this.y + "]";
    }

    public Vector2D mul(Matrix3 mat) {
        double x = this.x * (double)mat.val[0] + this.y * (double)mat.val[3] + (double)mat.val[6];
        double y = this.x * (double)mat.val[1] + this.y * (double)mat.val[4] + (double)mat.val[7];
        this.x = x;
        this.y = y;
        return this;
    }

    public double crs(Vector2D v) {
        return this.x * v.y - this.y * v.x;
    }

    public double crs(double x, double y) {
        return this.x * y - this.y * x;
    }

    public double angle() {
        double angle = FastMath.atan2((double)this.y, (double)this.x) * 57.2957763671875;
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public double getAngleRad() {
        return FastMath.atan2((double)this.y, (double)this.x);
    }

    public Vector2D setAngleRad(double radians) {
        this.set(this.len(), 0.0);
        this.rotateRad(radians);
        return this;
    }

    public Vector2D setAngle(double degrees) {
        return this.setAngleRad(degrees * 0.01745329238474369);
    }

    public Vector2D rotate(double degrees) {
        return this.rotateRad(degrees * 0.01745329238474369);
    }

    public Vector2D rotateRad(double radians) {
        double cos = FastMath.cos((double)radians);
        double sin = FastMath.sin((double)radians);
        double newX = this.x * cos - this.y * sin;
        double newY = this.x * sin + this.y * cos;
        this.x = newX;
        this.y = newY;
        return this;
    }

    public double[] values() {
        return new double[]{this.x, this.y};
    }

    public Vector2D rotate90(int dir) {
        double x = this.x;
        if (dir >= 0) {
            this.x = -this.y;
            this.y = x;
        } else {
            this.x = this.y;
            this.y = -x;
        }
        return this;
    }

    @Override
    public Vector2D lerp(Vector2D target, double alpha) {
        double invAlpha = 1.0 - alpha;
        this.x = this.x * invAlpha + target.x * alpha;
        this.y = this.y * invAlpha + target.y * alpha;
        return this;
    }

    @Override
    public Vector2D interpolate(Vector2D target, double alpha, InterpolationDouble interpolation) {
        return this.lerp(target, interpolation.apply(alpha));
    }

    @Override
    public Vector2D setToRandomDirection() {
        double theta = MathUtilsDouble.random(0.0, 6.2831854820251465);
        return this.set(MathUtilsDouble.cos(theta), MathUtilsDouble.sin(theta));
    }

    @Override
    public boolean epsilonEquals(Vector2D other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (Math.abs(other.x - this.x) > epsilon) {
            return false;
        }
        return !(Math.abs(other.y - this.y) > epsilon);
    }

    public boolean epsilonEquals(double x, double y, double epsilon) {
        if (Math.abs(x - this.x) > epsilon) {
            return false;
        }
        return !(Math.abs(y - this.y) > epsilon);
    }

    @Override
    public boolean isUnit() {
        return this.isUnit(1.0E-9);
    }

    @Override
    public boolean isUnit(double margin) {
        return FastMath.abs((double)(this.len2() - 1.0)) < margin;
    }

    @Override
    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    @Override
    public boolean isZero(double margin) {
        return this.len2() < margin;
    }

    @Override
    public boolean isOnLine(Vector2D other) {
        return MathUtilsDouble.isZero(this.x * other.y - this.y * other.x);
    }

    @Override
    public boolean isOnLine(Vector2D other, double epsilon) {
        return MathUtilsDouble.isZero(this.x * other.y - this.y * other.x, epsilon);
    }

    @Override
    public boolean isCollinear(Vector2D other, double epsilon) {
        return this.isOnLine(other, epsilon) && this.dot(other) > 0.0;
    }

    @Override
    public boolean isCollinear(Vector2D other) {
        return this.isOnLine(other) && this.dot(other) > 0.0;
    }

    @Override
    public boolean isCollinearOpposite(Vector2D other, double epsilon) {
        return this.isOnLine(other, epsilon) && this.dot(other) < 0.0;
    }

    @Override
    public boolean isCollinearOpposite(Vector2D other) {
        return this.isOnLine(other) && this.dot(other) < 0.0;
    }

    @Override
    public boolean isPerpendicular(Vector2D vector) {
        return MathUtilsDouble.isZero(this.dot(vector));
    }

    @Override
    public boolean isPerpendicular(Vector2D vector, double epsilon) {
        return MathUtilsDouble.isZero(this.dot(vector), epsilon);
    }

    @Override
    public boolean hasSameDirection(Vector2D vector) {
        return this.dot(vector) > 0.0;
    }

    @Override
    public boolean hasOppositeDirection(Vector2D vector) {
        return this.dot(vector) < 0.0;
    }
}

