/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.NumberUtils;
import gaiasky.util.math.InterpolationDouble;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Matrix3D;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.math.VectorDouble;
import net.jafama.FastMath;

public class Vector3D
implements VectorDouble<Vector3D> {
    public static final Vector3D X = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D Y = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D Z = new Vector3D(0.0, 0.0, 1.0);
    public static final Vector3D Zero = new Vector3D(0.0, 0.0, 0.0);
    private static final Matrix4D tmpMat = new Matrix4D();
    public double x;
    public double y;
    public double z;

    public Vector3D() {
    }

    public Vector3D(double x, double y, double z) {
        this.set(x, y, z);
    }

    public Vector3D(Vector3D vec) {
        this.set(vec);
    }

    public Vector3D(double[] values) {
        this.set(values[0], values[1], values[2]);
    }

    public static Vector3D getUnitX() {
        return X.cpy();
    }

    public static Vector3D getUnitY() {
        return Y.cpy();
    }

    public static Vector3D getUnitZ() {
        return Z.cpy();
    }

    public static double len(double x, double y, double z) {
        return FastMath.sqrt((double)(x * x + y * y + z * z));
    }

    private static double len2(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double dot(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    public static Vector3D crs(Vector3D v, Vector3D w) {
        Vector3D res = new Vector3D(v);
        return res.crs(w);
    }

    public static Vector3D cross(Vector3D v, Vector3D w) {
        return Vector3D.crs(v, w);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Vector3D set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @Override
    public Vector3D set(Vector3D vec) {
        if (vec != null) {
            return this.set(vec.x, vec.y, vec.z);
        }
        return this;
    }

    @Override
    public Vector3D set(Vector3Q vec) {
        if (vec != null) {
            return this.set(vec.x.doubleValue(), vec.y.doubleValue(), vec.z.doubleValue());
        }
        return this;
    }

    @Override
    public Vector3D set(Vector3 vec) {
        if (vec != null) {
            return this.set(vec.x, vec.y, vec.z);
        }
        return this;
    }

    public Vector3 put(Vector3 vec) {
        return vec.set((float)this.x, (float)this.y, (float)this.z);
    }

    public Vector3D put(Vector3D vec) {
        return vec.set(this.x, this.y, this.z);
    }

    @Override
    public Vector3D set(double[] values) {
        return this.set(values[0], values[1], values[2]);
    }

    @Override
    public Vector3D set(float[] values) {
        return this.set(values[0], values[1], values[2]);
    }

    public Vector3D setFromSpherical(double azimuthalAngle, double polarAngle) {
        double cosPolar = MathUtilsDouble.cos(polarAngle);
        double sinPolar = MathUtilsDouble.sin(polarAngle);
        double cosAzim = MathUtilsDouble.cos(azimuthalAngle);
        double sinAzim = MathUtilsDouble.sin(azimuthalAngle);
        return this.set(cosAzim * sinPolar, sinAzim * sinPolar, cosPolar);
    }

    @Override
    public Vector3D setToRandomDirection() {
        double u = MathUtilsDouble.random();
        double v = MathUtilsDouble.random();
        double theta = Math.PI * 2 * u;
        double phi = FastMath.acos((double)(2.0 * v - 1.0));
        return this.setFromSpherical(theta, phi);
    }

    @Override
    public Vector3D cpy() {
        return new Vector3D(this);
    }

    @Override
    public Vector3D add(Vector3D vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    @Override
    public Vector3D add(Vector3Q vec) {
        this.x += vec.x.doubleValue();
        this.y += vec.y.doubleValue();
        this.z += vec.z.doubleValue();
        return this;
    }

    @Override
    public Vector3D add(Vector3 vec) {
        this.x += (double)vec.x;
        this.y += (double)vec.y;
        this.z += (double)vec.z;
        return this;
    }

    public Vector3D add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @Override
    public Vector3D add(double ... vals) {
        assert (vals.length == 3) : "vals must contain 3 values";
        this.x += vals[0];
        this.y += vals[1];
        this.z += vals[2];
        return this;
    }

    @Override
    public Vector3D add(double values) {
        return this.set(this.x + values, this.y + values, this.z + values);
    }

    @Override
    public Vector3D sub(Vector3D vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    @Override
    public Vector3D sub(Vector3Q vec) {
        return this.sub(vec.x.doubleValue(), vec.y.doubleValue(), vec.z.doubleValue());
    }

    @Override
    public Vector3D sub(Vector3 vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    public Vector3D sub(double x, double y, double z) {
        return this.set(this.x - x, this.y - y, this.z - z);
    }

    @Override
    public Vector3D sub(double value) {
        return this.set(this.x - value, this.y - value, this.z - value);
    }

    @Override
    public Vector3D scl(double scalar) {
        return this.set(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public static Vector3D scale(double scalar, Vector3D in) {
        Vector3D out = new Vector3D(in);
        return out.scl(scalar);
    }

    @Override
    public Vector3D scl(Vector3D vec) {
        return this.set(this.x * vec.x, this.y * vec.y, this.z * vec.z);
    }

    public Vector3D scl(double vx, double vy, double vz) {
        return this.set(this.x * vx, this.y * vy, this.z * vz);
    }

    @Override
    public Vector3D mulAdd(Vector3D vec, double scalar) {
        this.x += vec.x * scalar;
        this.y += vec.y * scalar;
        this.z += vec.z * scalar;
        return this;
    }

    @Override
    public Vector3D mulAdd(Vector3D vec, Vector3D mulVec) {
        this.x += vec.x * mulVec.x;
        this.y += vec.y * mulVec.y;
        this.z += vec.z * mulVec.z;
        return this;
    }

    public Vector3D mul(Vector3D vec) {
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
        return this;
    }

    public Vector3D div(Vector3D vec) {
        this.x /= vec.x;
        this.y /= vec.y;
        this.z /= vec.z;
        return this;
    }

    @Override
    public double len() {
        return FastMath.sqrt((double)(this.x * this.x + this.y * this.y + this.z * this.z));
    }

    @Override
    public double len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public boolean idt(Vector3D vec) {
        return this.x == vec.x && this.y == vec.y && this.z == vec.z;
    }

    @Override
    public double dst(Vector3D vec) {
        double a = vec.x - this.x;
        double b = vec.y - this.y;
        double c = vec.z - this.z;
        return FastMath.sqrt((double)(a * a + b * b + c * c));
    }

    @Override
    public double dst(Vector3Q vec) {
        double a = vec.x.doubleValue() - this.x;
        double b = vec.y.doubleValue() - this.y;
        double c = vec.z.doubleValue() - this.z;
        return FastMath.sqrt((double)(a * a + b * b + c * c));
    }

    public double dst(double x, double y, double z) {
        double a = x - this.x;
        double b = y - this.y;
        double c = z - this.z;
        return FastMath.sqrt((double)(a * a + b * b + c * c));
    }

    @Override
    public double dst2(Vector3Q vec) {
        double a = vec.x.doubleValue() - this.x;
        double b = vec.y.doubleValue() - this.y;
        double c = vec.z.doubleValue() - this.z;
        return a * a + b * b + c * c;
    }

    @Override
    public double dst2(Vector3D vec) {
        double a = vec.x - this.x;
        double b = vec.y - this.y;
        double c = vec.z - this.z;
        return a * a + b * b + c * c;
    }

    public double dst2(double x, double y, double z) {
        double a = x - this.x;
        double b = y - this.y;
        double c = z - this.z;
        return a * a + b * b + c * c;
    }

    @Override
    public Vector3D nor() {
        double len2 = this.len2();
        if (len2 == 0.0 || len2 == 1.0) {
            return this;
        }
        return this.scl(1.0 / FastMath.sqrt((double)len2));
    }

    @Override
    public double dot(Vector3D vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    @Override
    public double dot(Vector3Q vector) {
        return this.x * vector.x.doubleValue() + this.y * vector.y.doubleValue() + this.z * vector.z.doubleValue();
    }

    public double dot(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public Vector3D crs(Vector3D vec) {
        return this.set(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    public Vector3D crs(double x, double y, double z) {
        return this.set(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public Vector3D mul4x3(double[] matrix) {
        return this.set(this.x * matrix[0] + this.y * matrix[3] + this.z * matrix[6] + matrix[9], this.x * matrix[1] + this.y * matrix[4] + this.z * matrix[7] + matrix[10], this.x * matrix[2] + this.y * matrix[5] + this.z * matrix[8] + matrix[11]);
    }

    public Vector3D mul(Matrix4D matrix) {
        double[] mat = matrix.val;
        return this.set(this.x * mat[0] + this.y * mat[4] + this.z * mat[8] + mat[12], this.x * mat[1] + this.y * mat[5] + this.z * mat[9] + mat[13], this.x * mat[2] + this.y * mat[6] + this.z * mat[10] + mat[14]);
    }

    public Vector3D mulLeft(Matrix3 matrix) {
        float[] l_mat = matrix.val;
        return this.set(this.x * (double)l_mat[0] + this.y * (double)l_mat[3] + this.z * (double)l_mat[6], this.x * (double)l_mat[1] + this.y * (double)l_mat[4] + this.z * (double)l_mat[7], this.x * (double)l_mat[2] + this.y * (double)l_mat[5] + this.z * (double)l_mat[8]);
    }

    public Vector3D mulRight(Matrix3 matrix) {
        float[] l_mat = matrix.val;
        return this.set(this.x * (double)l_mat[0] + this.y * (double)l_mat[1] + this.z * (double)l_mat[2], this.x * (double)l_mat[3] + this.y * (double)l_mat[4] + this.z * (double)l_mat[5], this.x * (double)l_mat[6] + this.y * (double)l_mat[7] + this.z * (double)l_mat[8]);
    }

    public Vector3D traMul(Matrix4D matrix) {
        double[] l_mat = matrix.val;
        return this.set(this.x * l_mat[0] + this.y * l_mat[1] + this.z * l_mat[2] + l_mat[3], this.x * l_mat[4] + this.y * l_mat[5] + this.z * l_mat[6] + l_mat[7], this.x * l_mat[8] + this.y * l_mat[9] + this.z * l_mat[10] + l_mat[11]);
    }

    public Vector3D mul(Matrix3D matrix) {
        double[] l_mat = matrix.val;
        return this.set(this.x * l_mat[0] + this.y * l_mat[3] + this.z * l_mat[6], this.x * l_mat[1] + this.y * l_mat[4] + this.z * l_mat[7], this.x * l_mat[2] + this.y * l_mat[5] + this.z * l_mat[8]);
    }

    public Vector3D traMul(Matrix3D matrix) {
        double[] l_mat = matrix.val;
        return this.set(this.x * l_mat[0] + this.y * l_mat[1] + this.z * l_mat[2], this.x * l_mat[3] + this.y * l_mat[4] + this.z * l_mat[5], this.x * l_mat[6] + this.y * l_mat[7] + this.z * l_mat[8]);
    }

    public Vector3D mul(QuaternionDouble quat) {
        return quat.transform(this);
    }

    public Vector3D prj(Matrix4D matrix) {
        double[] l_mat = matrix.val;
        double l_w = 1.0 / (this.x * l_mat[3] + this.y * l_mat[7] + this.z * l_mat[11] + l_mat[15]);
        return this.set((this.x * l_mat[0] + this.y * l_mat[4] + this.z * l_mat[8] + l_mat[12]) * l_w, (this.x * l_mat[1] + this.y * l_mat[5] + this.z * l_mat[9] + l_mat[13]) * l_w, (this.x * l_mat[2] + this.y * l_mat[6] + this.z * l_mat[10] + l_mat[14]) * l_w);
    }

    public Vector3D rot(Matrix4D matrix) {
        double[] l_mat = matrix.val;
        return this.set(this.x * l_mat[0] + this.y * l_mat[4] + this.z * l_mat[8], this.x * l_mat[1] + this.y * l_mat[5] + this.z * l_mat[9], this.x * l_mat[2] + this.y * l_mat[6] + this.z * l_mat[10]);
    }

    public Vector3D unrotate(Matrix4D matrix) {
        double[] l_mat = matrix.val;
        return this.set(this.x * l_mat[0] + this.y * l_mat[1] + this.z * l_mat[2], this.x * l_mat[4] + this.y * l_mat[5] + this.z * l_mat[6], this.x * l_mat[8] + this.y * l_mat[9] + this.z * l_mat[10]);
    }

    public Vector3D untransform(Matrix4D matrix) {
        double[] l_mat = matrix.val;
        this.x -= l_mat[12];
        this.y -= l_mat[12];
        this.z -= l_mat[12];
        return this.set(this.x * l_mat[0] + this.y * l_mat[1] + this.z * l_mat[2], this.x * l_mat[4] + this.y * l_mat[5] + this.z * l_mat[6], this.x * l_mat[8] + this.y * l_mat[9] + this.z * l_mat[10]);
    }

    public Vector3D rotate(double degrees, double axisX, double axisY, double axisZ) {
        return this.mul(tmpMat.setToRotation(axisX, axisY, axisZ, degrees));
    }

    public Vector3D rotateRad(double radians, double axisX, double axisY, double axisZ) {
        return this.mul(tmpMat.setToRotationRad(axisX, axisY, axisZ, radians));
    }

    public Vector3D rotate(Vector3D axis, double degrees) {
        tmpMat.setToRotation(axis, degrees);
        return this.mul(tmpMat);
    }

    public Vector3D rotateRad(Vector3D axis, double radians) {
        tmpMat.setToRotationRad(axis, radians);
        return this.mul(tmpMat);
    }

    public Matrix4 getMatrix(Matrix4 aux) {
        return aux.idt().translate((float)this.x, (float)this.y, (float)this.z);
    }

    public Matrix4D getMatrix(Matrix4D aux) {
        return aux.idt().translate(this);
    }

    @Override
    public boolean isUnit() {
        return this.isUnit(1.0E-9);
    }

    @Override
    public boolean isUnit(double margin) {
        return FastMath.abs((double)(this.len2() - 1.0)) < margin;
    }

    @Override
    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    @Override
    public boolean isZero(double margin) {
        return this.len2() < margin;
    }

    @Override
    public boolean isOnLine(Vector3D vec, double epsilon) {
        return Vector3D.len2(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x) <= epsilon;
    }

    @Override
    public boolean isOnLine(Vector3D vec) {
        return Vector3D.len2(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x) <= (double)1.0E-6f;
    }

    @Override
    public boolean isCollinear(Vector3D vec, double epsilon) {
        return this.isOnLine(vec, epsilon) && this.hasSameDirection(vec);
    }

    @Override
    public boolean isCollinear(Vector3D vec) {
        return this.isOnLine(vec) && this.hasSameDirection(vec);
    }

    @Override
    public boolean isCollinearOpposite(Vector3D vec, double epsilon) {
        return this.isOnLine(vec, epsilon) && this.hasOppositeDirection(vec);
    }

    @Override
    public boolean isCollinearOpposite(Vector3D vec) {
        return this.isOnLine(vec) && this.hasOppositeDirection(vec);
    }

    @Override
    public boolean isPerpendicular(Vector3D vec) {
        return MathUtilsDouble.isZero(this.dot(vec));
    }

    @Override
    public boolean isPerpendicular(Vector3D vec, double epsilon) {
        return MathUtilsDouble.isZero(this.dot(vec), epsilon);
    }

    @Override
    public boolean hasSameDirection(Vector3D vec) {
        return this.dot(vec) > 0.0;
    }

    @Override
    public boolean hasOppositeDirection(Vector3D vec) {
        return this.dot(vec) < 0.0;
    }

    @Override
    public Vector3D lerp(Vector3D vec, double alpha) {
        this.x += alpha * (vec.x - this.x);
        this.y += alpha * (vec.y - this.y);
        this.z += alpha * (vec.z - this.z);
        return this;
    }

    @Override
    public Vector3D interpolate(Vector3D vec, double alpha, InterpolationDouble interpolator) {
        return this.lerp(vec, interpolator.apply(0.0, 1.0, alpha));
    }

    public Vector3D slerp(Vector3D vec, double alpha) {
        double dot = this.dot(vec);
        if (dot > 0.9995 || dot < -0.9995) {
            return this.lerp(vec, alpha);
        }
        double theta0 = FastMath.acos((double)dot);
        double theta = theta0 * alpha;
        double st = FastMath.sin((double)theta);
        double tx = vec.x - this.x * dot;
        double ty = vec.y - this.y * dot;
        double tz = vec.z - this.z * dot;
        double l2 = tx * tx + ty * ty + tz * tz;
        double dl = st * (l2 < 1.0E-4 ? 1.0 : 1.0 / FastMath.sqrt((double)l2));
        return this.scl(Math.cos(theta)).add(tx * dl, ty * dl, tz * dl).nor();
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }

    @Override
    public Vector3D limit(double limit) {
        if (this.len2() > limit * limit) {
            this.nor().scl(limit);
        }
        return this;
    }

    @Override
    public Vector3D limit2(double limit2) {
        double len2 = this.len2();
        if (len2 > limit2) {
            this.scl(Math.sqrt(limit2 / len2));
        }
        return this;
    }

    @Override
    public Vector3D setLength(double len) {
        return this.setLength2(len * len);
    }

    @Override
    public Vector3D setLength2(double len2) {
        double oldLen2 = this.len2();
        return oldLen2 == 0.0 || oldLen2 == len2 ? this : this.scl(Math.sqrt(len2 / oldLen2));
    }

    @Override
    public Vector3D clamp(double min, double max) {
        double l2 = this.len2();
        if (l2 == 0.0) {
            return this;
        }
        if (l2 > max * max) {
            return this.nor().scl(max);
        }
        if (l2 < min * min) {
            return this.nor().scl(min);
        }
        return this;
    }

    public double[] values() {
        return new double[]{this.x, this.y, this.z};
    }

    public float[] valuesF() {
        return new float[]{(float)this.x, (float)this.y, (float)this.z};
    }

    public float[] valuesF(float[] vec) {
        vec[0] = (float)this.x;
        vec[1] = (float)this.y;
        vec[2] = (float)this.z;
        return vec;
    }

    public Vector3D scaleAdd(double s, Vector3D vec) {
        return this.add(vec.scl(s));
    }

    public Vector3 toVector3() {
        return new Vector3((float)this.x, (float)this.y, (float)this.z);
    }

    public Vector3 setVector3(Vector3 v) {
        return v.set((float)this.x, (float)this.y, (float)this.z);
    }

    public Vector3D rotateVectorByQuaternion(QuaternionDouble q) {
        QuaternionDouble oldVecQ = new QuaternionDouble(this.x, this.y, this.z, 0.0);
        QuaternionDouble newVecQ = q.cpy().mul(oldVecQ).mulInverse(q);
        this.x = newVecQ.x;
        this.y = newVecQ.y;
        this.z = newVecQ.z;
        return this;
    }

    public double angle(Vector3D v) {
        return 57.29577951308232 * FastMath.acos((double)MathUtils.clamp((double)(this.dot(v) / (this.len() * v.len())), (double)-1.0, (double)1.0));
    }

    public double angle(Vector3Q v) {
        return 57.29577951308232 * FastMath.acos((double)MathUtils.clamp((double)(this.dot(v) / (this.len() * v.lenDouble())), (double)-1.0, (double)1.0));
    }

    public double anglePrecise(Vector3D v) {
        return 57.29577951308232 * FastMath.acos((double)MathUtils.clamp((double)(this.dot(v) / (this.len() * v.len())), (double)-1.0, (double)1.0));
    }

    public boolean hasNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public int hashCode() {
        long prime = 31L;
        long result = 1L;
        result = 31L * result + NumberUtils.doubleToLongBits((double)this.x);
        result = 31L * result + NumberUtils.doubleToLongBits((double)this.y);
        result = 31L * result + NumberUtils.doubleToLongBits((double)this.z);
        return (int)result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3D other = (Vector3D)obj;
        if (NumberUtils.doubleToLongBits((double)this.x) != NumberUtils.doubleToLongBits((double)other.x)) {
            return false;
        }
        if (NumberUtils.doubleToLongBits((double)this.y) != NumberUtils.doubleToLongBits((double)other.y)) {
            return false;
        }
        return NumberUtils.doubleToLongBits((double)this.z) == NumberUtils.doubleToLongBits((double)other.z);
    }

    @Override
    public boolean epsilonEquals(Vector3D vec, double epsilon) {
        if (vec == null) {
            return false;
        }
        if (Math.abs(vec.x - this.x) > epsilon) {
            return false;
        }
        if (Math.abs(vec.y - this.y) > epsilon) {
            return false;
        }
        return !(Math.abs(vec.z - this.z) > epsilon);
    }

    public boolean epsilonEquals(float x, float y, float z, float epsilon) {
        if (Math.abs((double)x - this.x) > (double)epsilon) {
            return false;
        }
        if (Math.abs((double)y - this.y) > (double)epsilon) {
            return false;
        }
        return !(Math.abs((double)z - this.z) > (double)epsilon);
    }

    public boolean epsilonEquals(Vector3D vec) {
        return this.epsilonEquals(vec, (double)1.0E-6f);
    }

    public boolean epsilonEquals(float x, float y, float z) {
        return this.epsilonEquals(x, y, z, 1.0E-6f);
    }

    @Override
    public Vector3D setZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public double getLatitude() {
        return this.toSphericalCoordinates().y;
    }

    public double getLongitude() {
        return this.toSphericalCoordinates().x;
    }

    public Vector2D toSphericalCoordinates() {
        double xy = FastMath.sqrt((double)(this.x * this.x + this.y * this.y));
        if (xy <= 0.0) {
            return new Vector2D(0.0, 1.5707963267948966 * FastMath.signum((double)this.z));
        }
        double alon = FastMath.atan2((double)this.y, (double)this.x);
        if (alon < 0.0) {
            alon += Math.PI * 2;
        }
        return new Vector2D(alon, FastMath.atan2((double)this.z, (double)xy));
    }
}

