/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Quadruple;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class Vector3Q {
    private static final Matrix4D tmpMat = new Matrix4D();
    public Quadruple x;
    public Quadruple y;
    public Quadruple z;

    public Vector3Q() {
        this.x = Quadruple.zero();
        this.y = Quadruple.zero();
        this.z = Quadruple.zero();
    }

    public Vector3Q(Quadruple x, Quadruple y, Quadruple z) {
        this.x = new Quadruple().assign(x);
        this.y = new Quadruple().assign(y);
        this.z = new Quadruple().assign(z);
    }

    public Vector3Q(double x, double y, double z) {
        this.x = new Quadruple(x);
        this.y = new Quadruple(y);
        this.z = new Quadruple(z);
    }

    public Vector3Q(Vector3D vec) {
        this(vec.x, vec.y, vec.z);
    }

    public Vector3Q(Vector3Q vector) {
        this(vector.x, vector.y, vector.z);
    }

    public Vector3Q(double[] values) {
        this.set(values[0], values[1], values[2]);
    }

    public static double len(double x, double y, double z) {
        return FastMath.sqrt((double)(x * x + y * y + z * z));
    }

    public static Vector3Q crs(Vector3Q v, Vector3Q w) {
        Vector3Q res = new Vector3Q(v);
        return res.crs(w);
    }

    public double x() {
        return this.x.doubleValue();
    }

    public double y() {
        return this.y.doubleValue();
    }

    public double z() {
        return this.z.doubleValue();
    }

    public Vector3Q set(float x, float y, float z) {
        this.x.assign(x);
        this.y.assign(y);
        this.z.assign(z);
        return this;
    }

    public Vector3Q set(double x, double y, double z) {
        this.x.assign(x);
        this.y.assign(y);
        this.z.assign(z);
        return this;
    }

    public Vector3Q set(Quadruple x, Quadruple y, Quadruple z) {
        this.x.assign(x);
        this.y.assign(y);
        this.z.assign(z);
        return this;
    }

    public Vector3Q set(Vector3Q vec) {
        if (vec != null) {
            return this.set(vec.x, vec.y, vec.z);
        }
        return this;
    }

    public Vector3Q set(Vector3D vec) {
        if (vec != null) {
            return this.set(vec.x, vec.y, vec.z);
        }
        return this;
    }

    public Vector3Q set(Vector3 vec) {
        if (vec != null) {
            return this.set(vec.x, vec.y, vec.z);
        }
        return this;
    }

    public Vector3 put(Vector3 vec) {
        return vec.set(this.x.floatValue(), this.y.floatValue(), this.z.floatValue());
    }

    public Vector3 tov3() {
        return new Vector3(this.x.floatValue(), this.y.floatValue(), this.z.floatValue());
    }

    public Vector3 tov3(Vector3 out) {
        return out.set(this.x.floatValue(), this.y.floatValue(), this.z.floatValue());
    }

    public Vector3D put(Vector3D vec) {
        return vec.set(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue());
    }

    public Vector3D tov3d() {
        return new Vector3D(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue());
    }

    public Vector3D tov3d(Vector3D out) {
        return out.set(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue());
    }

    public Vector3Q put(Vector3Q vec) {
        return vec.set(this.x, this.y, this.z);
    }

    public Vector3Q set(double[] vals) {
        return this.set(vals[0], vals[1], vals[2]);
    }

    public Vector3Q set(float[] vals) {
        return this.set(vals[0], vals[1], vals[2]);
    }

    public Vector3Q setFromSpherical(double azimuthalAngle, double polarAngle) {
        double cosPolar = MathUtilsDouble.cos(polarAngle);
        double sinPolar = MathUtilsDouble.sin(polarAngle);
        double cosAzim = MathUtilsDouble.cos(azimuthalAngle);
        double sinAzim = MathUtilsDouble.sin(azimuthalAngle);
        return this.set(cosAzim * sinPolar, sinAzim * sinPolar, cosPolar);
    }

    public Vector3Q setToRandomDirection() {
        double u = MathUtilsDouble.random();
        double v = MathUtilsDouble.random();
        double theta = Math.PI * 2 * u;
        double phi = FastMath.acos((double)(2.0 * v - 1.0));
        return this.setFromSpherical(theta, phi);
    }

    public Vector3Q cpy() {
        return new Vector3Q(this);
    }

    public Vector3Q add(Vector3Q vec) {
        this.x.add(vec.x);
        this.y.add(vec.y);
        this.z.add(vec.z);
        return this;
    }

    public Vector3Q add(Vector3D vec) {
        Quadruple aux = new Quadruple();
        this.x.add(aux.assign(vec.x));
        this.y.add(aux.assign(vec.y));
        this.z.add(aux.assign(vec.z));
        return this;
    }

    public Vector3Q add(Vector3 vec) {
        Quadruple aux = new Quadruple();
        this.x.add(aux.assign(vec.x));
        this.y.add(aux.assign(vec.y));
        this.z.add(aux.assign(vec.z));
        return this;
    }

    public Vector3Q add(double x, double y, double z) {
        Quadruple aux = new Quadruple();
        this.x.add(aux.assign(x));
        this.y.add(aux.assign(y));
        this.z.add(aux.assign(z));
        return this;
    }

    public Vector3Q add(double ... vals) {
        assert (vals.length == 3) : "vals must contain 3 values";
        Quadruple aux = new Quadruple();
        this.x.add(aux.assign(vals[0]));
        this.y.add(aux.assign(vals[1]));
        this.z.add(aux.assign(vals[2]));
        return this;
    }

    public Vector3Q add(double value) {
        Quadruple val = new Quadruple(value);
        this.x.add(val);
        this.y.add(val);
        this.z.add(val);
        return this;
    }

    public Vector3Q sub(Vector3Q vec) {
        this.x.subtract(vec.x);
        this.y.subtract(vec.y);
        this.z.subtract(vec.z);
        return this;
    }

    public Vector3Q sub(Vector3 a_vec) {
        return this.sub(a_vec.x, a_vec.y, a_vec.z);
    }

    public Vector3Q sub(Vector3D a_vec) {
        return this.sub(a_vec.x, a_vec.y, a_vec.z);
    }

    public Vector3Q sub(double x, double y, double z) {
        this.x.subtract(x);
        this.y.subtract(y);
        this.z.subtract(z);
        return this;
    }

    public Vector3Q sub(double value) {
        Quadruple val = new Quadruple(value);
        this.x.subtract(val);
        this.y.subtract(val);
        this.z.subtract(val);
        return this;
    }

    public Vector3Q div(Quadruple num) {
        this.x.divide(num);
        this.y.divide(num);
        this.z.divide(num);
        return this;
    }

    public Vector3Q scl(Quadruple scl) {
        this.x.multiply(scl);
        this.y.multiply(scl);
        this.z.multiply(scl);
        return this;
    }

    public Vector3Q scl(double scalar) {
        this.x.multiply(scalar);
        this.y.multiply(scalar);
        this.z.multiply(scalar);
        return this;
    }

    public Vector3Q scl(Vector3Q vec) {
        this.x.multiply(vec.x);
        this.y.multiply(vec.y);
        this.z.multiply(vec.z);
        return this;
    }

    public Vector3Q scl(double x, double y, double z) {
        this.x.multiply(x);
        this.y.multiply(y);
        this.z.multiply(z);
        return this;
    }

    public Vector3Q mul(Vector3Q vec) {
        this.x.multiply(vec.x);
        this.y.multiply(vec.y);
        this.z.multiply(vec.z);
        return this;
    }

    public Vector3Q div(Vector3Q vec) {
        this.x.divide(vec.x);
        this.y.divide(vec.y);
        this.z.divide(vec.z);
        return this;
    }

    public double lenDouble() {
        return Vector3Q.len(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue());
    }

    public float lenF() {
        return this.len().floatValue();
    }

    public Quadruple len() {
        return this.len2().sqrt();
    }

    public double len2D() {
        return this.len2().doubleValue();
    }

    public Quadruple len2() {
        Quadruple res = new Quadruple(this.x);
        Quadruple aux = new Quadruple();
        return res.multiply(this.x).add(aux.assign(this.y).multiply(this.y)).add(aux.assign(this.z).multiply(this.z));
    }

    public boolean idt(Vector3Q vec) {
        return this.x.equals(vec.x) && this.y.equals(vec.y) && this.z.equals(vec.z);
    }

    public double dstD(Vector3Q vec) {
        return this.dst(vec).doubleValue();
    }

    public double dstD(Vector3Q vec, Vector3Q aux) {
        return this.dst(vec, aux).doubleValue();
    }

    public Quadruple dst(Vector3Q vec) {
        return this.dst2(vec).sqrt();
    }

    public Quadruple dst(Vector3Q vec, Vector3Q aux) {
        return aux.set(this).sub(vec).len();
    }

    public Quadruple dst(Vector3D vec) {
        return this.dst2(vec).sqrt();
    }

    public Quadruple dst(Vector3D vec, Vector3Q aux) {
        return aux.set(this).sub(vec).len();
    }

    public double dstD(double x, double y, double z) {
        return this.dst(x, y, z).doubleValue();
    }

    public Quadruple dst(double x, double y, double z) {
        return this.dst2(x, y, z).sqrt();
    }

    public Quadruple dst(double x, double y, double z, Vector3Q aux) {
        return aux.set(this).sub(x, y, z).len();
    }

    public double dst2D(Vector3Q vec) {
        return this.dst2(vec).doubleValue();
    }

    public double dst2D(Vector3D vec) {
        return this.dst2D(vec.x, vec.y, vec.z);
    }

    public Quadruple dst2(Vector3Q vec) {
        Quadruple res = new Quadruple(vec.x).subtract(this.x);
        Quadruple aux = new Quadruple();
        return res.multiply(res).add(aux.assign(vec.y).subtract(this.y).multiply(aux)).add(aux.assign(vec.z).subtract(this.z).multiply(aux));
    }

    public double dst2D(double x, double y, double z) {
        return this.dst2(x, y, z).doubleValue();
    }

    public Quadruple dst2(Vector3D vec) {
        return this.dst2(vec.x, vec.y, vec.z);
    }

    public Quadruple dst2(double x, double y, double z) {
        Quadruple res = new Quadruple(x).subtract(this.x);
        Quadruple aux = new Quadruple();
        return res.multiply(res).add(aux.assign(y).subtract(this.y).multiply(aux)).add(aux.assign(z).subtract(this.z).multiply(aux));
    }

    public Vector3Q nor() {
        Quadruple len2 = this.len2();
        double len2d = len2.doubleValue();
        if (len2d == 0.0 || len2d == 1.0) {
            return this;
        }
        return this.div(len2.sqrt());
    }

    public double dot(Vector3D vec) {
        Quadruple res = new Quadruple();
        Quadruple aux = new Quadruple();
        return res.assign(this.x).multiply(vec.x).add(aux.assign(this.y).multiply(vec.y)).add(aux.assign(this.z).multiply(vec.z)).doubleValue();
    }

    public double dotD(Vector3Q vec) {
        return this.dot(vec).doubleValue();
    }

    public Quadruple dot(Vector3Q vec) {
        Quadruple res = new Quadruple();
        Quadruple aux = new Quadruple();
        return res.assign(this.x).multiply(vec.x).add(aux.assign(this.y).multiply(vec.y)).add(aux.assign(this.z).multiply(vec.z));
    }

    public Quadruple dot(Quadruple x, Quadruple y, Quadruple z) {
        Quadruple res = new Quadruple();
        Quadruple aux = new Quadruple();
        return res.assign(this.x).multiply(x).add(aux.assign(this.y).multiply(y)).add(aux.assign(this.z).multiply(z));
    }

    public Vector3Q crs(Vector3Q vec) {
        Vector3Q res = new Vector3Q();
        Quadruple aux = new Quadruple();
        res.x.assign(this.y).multiply(vec.z).subtract(aux.assign(this.z).multiply(vec.y));
        res.y.assign(this.z).multiply(vec.x).subtract(aux.assign(this.x).multiply(vec.z));
        res.z.assign(this.x).multiply(vec.y).subtract(aux.assign(this.y).multiply(vec.x));
        return this.set(res);
    }

    public Vector3Q crs(Vector3D vec) {
        return this.crs(vec.x, vec.y, vec.z);
    }

    public Vector3Q crs(double x, double y, double z) {
        Vector3Q res = new Vector3Q();
        Quadruple aux = new Quadruple();
        res.x.assign(this.y).multiply(z).subtract(aux.assign(this.z).multiply(y));
        res.y.assign(this.z).multiply(x).subtract(aux.assign(this.x).multiply(z));
        res.z.assign(this.x).multiply(y).subtract(aux.assign(this.y).multiply(x));
        return this.set(res);
    }

    public Vector3Q mul4x3(double[] matrix) {
        Quadruple m0 = Quadruple.from(matrix[0]);
        Quadruple m1 = Quadruple.from(matrix[1]);
        Quadruple m2 = Quadruple.from(matrix[2]);
        Quadruple m3 = Quadruple.from(matrix[3]);
        Quadruple m4 = Quadruple.from(matrix[4]);
        Quadruple m5 = Quadruple.from(matrix[5]);
        Quadruple m6 = Quadruple.from(matrix[6]);
        Quadruple m7 = Quadruple.from(matrix[7]);
        Quadruple m8 = Quadruple.from(matrix[8]);
        Quadruple m9 = Quadruple.from(matrix[9]);
        Quadruple m10 = Quadruple.from(matrix[10]);
        Quadruple m11 = Quadruple.from(matrix[11]);
        Vector3Q aux = new Vector3Q(this);
        Quadruple rx = new Quadruple(aux.x).multiply(m0).add(aux.y.multiply(m3)).add(aux.z.multiply(m6)).add(m9);
        aux.set(this);
        Quadruple ry = new Quadruple(aux.x).multiply(m1).add(aux.y.multiply(m4)).add(aux.z.multiply(m7)).add(m10);
        aux.set(this);
        Quadruple rz = new Quadruple(aux.x).multiply(m2).add(aux.y.multiply(m5)).add(aux.z.multiply(m8)).add(m11);
        return this.set(rx, ry, rz);
    }

    public Vector3Q mul(Matrix4D matrix) {
        double[] mat = matrix.val;
        Quadruple m00 = Quadruple.from(mat[0]);
        Quadruple m01 = Quadruple.from(mat[4]);
        Quadruple m02 = Quadruple.from(mat[8]);
        Quadruple m03 = Quadruple.from(mat[12]);
        Quadruple m10 = Quadruple.from(mat[1]);
        Quadruple m11 = Quadruple.from(mat[5]);
        Quadruple m12 = Quadruple.from(mat[9]);
        Quadruple m13 = Quadruple.from(mat[13]);
        Quadruple m20 = Quadruple.from(mat[2]);
        Quadruple m21 = Quadruple.from(mat[6]);
        Quadruple m22 = Quadruple.from(mat[10]);
        Quadruple m23 = Quadruple.from(mat[14]);
        Vector3Q aux = new Vector3Q(this);
        Quadruple rx = new Quadruple(aux.x).multiply(m00).add(aux.y.multiply(m01)).add(aux.z.multiply(m02)).add(m03);
        aux.set(this);
        Quadruple ry = new Quadruple(aux.x).multiply(m10).add(aux.y.multiply(m11)).add(aux.z.multiply(m12)).add(m13);
        aux.set(this);
        Quadruple rz = new Quadruple(aux.x).multiply(m20).add(aux.y.multiply(m21)).add(aux.z.multiply(m22)).add(m23);
        return this.set(rx, ry, rz);
    }

    public Vector3Q mul(QuaternionDouble quat) {
        return quat.transform(this);
    }

    public Vector3Q rotate(double degrees, double axisX, double axisY, double axisZ) {
        return this.mul(tmpMat.setToRotation(axisX, axisY, axisZ, degrees));
    }

    public Vector3Q rotate(Vector3D axis, double degrees) {
        tmpMat.setToRotation(axis, degrees);
        return this.mul(tmpMat);
    }

    public Matrix4 setToTranslation(Matrix4 matrix) {
        return matrix.idt().translate(this.x.floatValue(), this.y.floatValue(), this.z.floatValue());
    }

    public Matrix4D setToTranslation(Matrix4D matrix) {
        return matrix.idt().translate(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue());
    }

    public boolean isUnit() {
        return this.isUnit(1.0E-9);
    }

    public boolean isUnit(double margin) {
        return FastMath.abs((double)(this.len2D() - 1.0)) < margin;
    }

    public boolean isZero() {
        return this.x.doubleValue() == 0.0 && this.y.doubleValue() == 0.0 && this.z.doubleValue() == 0.0;
    }

    public boolean isZero(double margin) {
        return this.len2D() < margin;
    }

    public String toString() {
        return String.valueOf(this.x) + "," + String.valueOf(this.y) + "," + String.valueOf(this.z);
    }

    public Vector3Q setLength(double len) {
        return this.setLength2(len * len);
    }

    public Vector3Q setLength2(double len2) {
        double oldLen2 = this.len2D();
        return oldLen2 == 0.0 || oldLen2 == len2 ? this : this.scl(Math.sqrt(len2 / oldLen2));
    }

    public Vector3Q clamp(double min, double max) {
        double l2 = this.len2D();
        if (l2 == 0.0) {
            return this;
        }
        if (l2 > max * max) {
            return this.nor().scl(max);
        }
        if (l2 < min * min) {
            return this.nor().scl(min);
        }
        return this;
    }

    public Quadruple[] values() {
        return new Quadruple[]{this.x, this.y, this.z};
    }

    public double[] valuesD() {
        return new double[]{this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue()};
    }

    public float[] valuesF() {
        return new float[]{this.x.floatValue(), this.y.floatValue(), this.z.floatValue()};
    }

    public float[] valuesF(float[] vec) {
        vec[0] = this.x.floatValue();
        vec[1] = this.y.floatValue();
        vec[2] = this.z.floatValue();
        return vec;
    }

    public double angle(Vector3Q v) {
        return 57.29577951308232 * FastMath.acos((double)MathUtils.clamp((double)(this.dotD(v) / (this.lenDouble() * v.lenDouble())), (double)-1.0, (double)1.0));
    }

    public double angle(Vector3D v) {
        return 57.29577951308232 * FastMath.acos((double)MathUtils.clamp((double)(this.dot(v) / (this.lenDouble() * v.len())), (double)-1.0, (double)1.0));
    }

    public double anglePrecise(Vector3Q v) {
        return 57.29577951308232 * FastMath.acos((double)MathUtils.clamp((double)(this.dotD(v) / (this.lenDouble() * v.lenDouble())), (double)-1.0, (double)1.0));
    }

    public double anglePrecise(Vector3D v) {
        return 57.29577951308232 * FastMath.acos((double)MathUtils.clamp((double)(this.dot(v) / (this.lenDouble() * v.len())), (double)-1.0, (double)1.0));
    }

    public int hashCode() {
        long prime = 31L;
        long res = 1L;
        res = 31L * res + (long)this.x.hashCode();
        res = 31L * res + (long)this.y.hashCode();
        res = 31L * res + (long)this.z.hashCode();
        return (int)res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3Q other = (Vector3Q)obj;
        if (this.x.hashCode() != other.x.hashCode()) {
            return false;
        }
        if (this.y.hashCode() != other.y.hashCode()) {
            return false;
        }
        return this.z.hashCode() == other.z.hashCode();
    }

    public Vector3Q setZero() {
        this.x.assign(0L);
        this.y.assign(0L);
        this.z.assign(0L);
        return this;
    }

    public boolean hasNaN() {
        return this.x.isNaN() || this.y.isNaN() || this.z.isNaN();
    }
}

