/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.parse;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.jafama.FastMath;

public final class Parser {
    public static long parseLong(String input) {
        long result = 0L;
        int pos = 0;
        int len = input.length();
        if (len == 0) {
            return 0L;
        }
        char c = input.charAt(0);
        long sign = 1L;
        while (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') {
            if (++pos >= len) {
                return 0L;
            }
            c = input.charAt(pos);
        }
        if (c == '-') {
            sign = -1L;
            if (++pos >= len) {
                return 0L;
            }
        } else if (c == '+' && ++pos >= len) {
            return 0L;
        }
        while (pos < len) {
            if ((c = input.charAt(pos++)) < '0' || c > '9') {
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') break;
                return 0L;
            }
            result = result * 10L + (long)(c - 48);
        }
        return sign * result;
    }

    public static long parseLongException(String input) throws NumberFormatException {
        long result = 0L;
        int pos = 0;
        int len = input.length();
        if (len == 0) {
            return 0L;
        }
        char c = input.charAt(0);
        long sign = 1L;
        while (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') {
            if (++pos >= len) {
                throw new NumberFormatException("Invalid input");
            }
            c = input.charAt(pos);
        }
        if (c == '-') {
            sign = -1L;
            if (++pos >= len) {
                throw new NumberFormatException("Invalid input");
            }
        } else if (c == '+' && ++pos >= len) {
            throw new NumberFormatException("Invalid input");
        }
        while (pos < len) {
            if ((c = input.charAt(pos++)) < '0' || c > '9') {
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') break;
                throw new NumberFormatException("Invalid input");
            }
            result = result * 10L + (long)(c - 48);
        }
        return sign * result;
    }

    public static double parseDouble(String input) {
        double result = 0.0;
        int pos = 0;
        int len = input.length();
        if (len == 0) {
            return Double.NaN;
        }
        char c = input.charAt(0);
        double sign = 1.0;
        while (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') {
            if (++pos >= len) {
                return Double.NaN;
            }
            c = input.charAt(pos);
        }
        if (c == 'N' || c == 'n') {
            return Double.NaN;
        }
        if (c == '-') {
            sign = -1.0;
            if (++pos >= len) {
                return Double.NaN;
            }
        } else if (c == '+' && ++pos >= len) {
            return Double.NaN;
        }
        if ((c = input.charAt(pos)) == 'I' || c == 'i') {
            if (++pos >= len) {
                return Double.NaN;
            }
            c = input.charAt(pos);
            if (c != 'N' && c != 'n') {
                return Double.NaN;
            }
            if (++pos >= len) {
                return Double.NaN;
            }
            c = input.charAt(pos);
            if (c != 'F' && c != 'f') {
                return Double.NaN;
            }
            if (sign == -1.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        while (true) {
            if (pos >= len) {
                return sign * result;
            }
            if ((c = input.charAt(pos++)) < '0' || c > '9') break;
            result = result * 10.0 + (double)(c - 48);
        }
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') {
            return sign * result;
        }
        if (c != '.' && c != ',') {
            return Double.NaN;
        }
        double exp = 0.1;
        while (pos < len) {
            if ((c = input.charAt(pos++)) < '0' || c > '9') {
                if (c == 'e' || c == 'E' || c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') break;
                return Double.NaN;
            }
            result += (double)(c - 48) * exp;
            exp *= 0.1;
        }
        if (c != 'e' && c != 'E' || pos == len) {
            return sign * result;
        }
        int expSign = 1;
        c = input.charAt(pos);
        if (c == '-') {
            expSign = -1;
            if (++pos >= len) {
                return sign * result;
            }
        } else if (c == '+' && ++pos >= len) {
            return sign * result;
        }
        double expResult = 0.0;
        while (true) {
            if (pos >= len) {
                return sign * result * FastMath.pow((double)10.0, (double)((double)expSign * expResult));
            }
            if ((c = input.charAt(pos++)) < '0' || c > '9') break;
            expResult = expResult * 10.0 + (double)(c - 48);
        }
        if (c != '.' && c != ',') {
            return sign * result * FastMath.pow((double)10.0, (double)((double)expSign * expResult));
        }
        double expExp = 0.1;
        while (pos < len) {
            if ((c = input.charAt(pos++)) < '0' || c > '9') {
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') break;
                return Double.NaN;
            }
            expResult += (double)(c - 48) * expExp;
            expExp *= 0.1;
        }
        return sign * result * FastMath.pow((double)10.0, (double)((double)expSign * expResult));
    }

    public static double parseDoubleException(String input) throws NumberFormatException {
        double result = 0.0;
        int pos = 0;
        int len = input.length();
        if (len == 0) {
            throw new NumberFormatException("Invalid input");
        }
        char c = input.charAt(0);
        double sign = 1.0;
        while (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') {
            if (++pos >= len) {
                throw new NumberFormatException("Invalid input");
            }
            c = input.charAt(pos);
        }
        if (c == 'N' || c == 'n') {
            return Double.NaN;
        }
        if (c == '-') {
            sign = -1.0;
            if (++pos >= len) {
                throw new NumberFormatException("Invalid input");
            }
        } else if (c == '+' && ++pos >= len) {
            throw new NumberFormatException("Invalid input");
        }
        if ((c = input.charAt(pos)) == 'I' || c == 'i') {
            if (++pos >= len) {
                throw new NumberFormatException("Invalid input");
            }
            c = input.charAt(pos);
            if (c != 'N' && c != 'n') {
                throw new NumberFormatException("Invalid input");
            }
            if (++pos >= len) {
                throw new NumberFormatException("Invalid input");
            }
            c = input.charAt(pos);
            if (c != 'F' && c != 'f') {
                throw new NumberFormatException("Invalid input");
            }
            if (sign == -1.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        while (true) {
            if (pos >= len) {
                return sign * result;
            }
            if ((c = input.charAt(pos++)) < '0' || c > '9') break;
            result = result * 10.0 + (double)(c - 48);
        }
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') {
            return sign * result;
        }
        if (c != '.' && c != ',') {
            throw new NumberFormatException("Invalid input");
        }
        double exp = 0.1;
        while (pos < len) {
            if ((c = input.charAt(pos++)) < '0' || c > '9') {
                if (c == 'e' || c == 'E' || c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') break;
                throw new NumberFormatException("Invalid input");
            }
            result += (double)(c - 48) * exp;
            exp *= 0.1;
        }
        if (c != 'e' && c != 'E' || pos == len) {
            return sign * result;
        }
        int expSign = 1;
        c = input.charAt(pos);
        if (c == '-') {
            expSign = -1;
            if (++pos >= len) {
                return sign * result;
            }
        } else if (c == '+' && ++pos >= len) {
            return sign * result;
        }
        double expResult = 0.0;
        while (true) {
            if (pos >= len) {
                return sign * result * FastMath.pow((double)10.0, (double)((double)expSign * expResult));
            }
            if ((c = input.charAt(pos++)) < '0' || c > '9') break;
            expResult = expResult * 10.0 + (double)(c - 48);
        }
        if (c != '.' && c != ',') {
            return sign * result * FastMath.pow((double)10.0, (double)((double)expSign * expResult));
        }
        double expExp = 0.1;
        while (pos < len) {
            if ((c = input.charAt(pos++)) < '0' || c > '9') {
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000') break;
                throw new NumberFormatException("Invalid input");
            }
            expResult += (double)(c - 48) * expExp;
            expExp *= 0.1;
        }
        return sign * result * FastMath.pow((double)10.0, (double)((double)expSign * expResult));
    }

    public static boolean parseBoolean(Object what) {
        if (what instanceof String) {
            String text = ((String)what).toLowerCase(Locale.ROOT);
            return text.startsWith("t") || text.equals("1") || text.equals("on") || text.equals("yes");
        }
        if (what instanceof Boolean) {
            return (Boolean)what;
        }
        return false;
    }

    public static int parseInt(String str) {
        char ch;
        int end;
        boolean sign;
        int idx;
        int ival;
        block7: {
            block6: {
                ival = 0;
                idx = 0;
                sign = false;
                if (str == null || (end = str.length()) == 0) break block6;
                ch = str.charAt(0);
                if (ch >= '0' && ch <= '9') break block7;
                boolean bl = sign = ch == '-';
                if (bl && ++idx != end && (ch = str.charAt(idx)) >= '0' && ch <= '9') break block7;
            }
            return 0;
        }
        while (true) {
            ival += 48 - ch;
            if (++idx == end) {
                return sign ? ival : -ival;
            }
            ch = str.charAt(idx);
            if (ch < '0' || ch > '9') {
                return 0;
            }
            ival *= 10;
        }
    }

    public static int parseIntException(String str) throws NumberFormatException {
        char ch;
        int end;
        boolean sign;
        int idx;
        int ival;
        block7: {
            block6: {
                ival = 0;
                idx = 0;
                sign = false;
                if (str == null || (end = str.length()) == 0) break block6;
                ch = str.charAt(0);
                if (ch >= '0' && ch <= '9') break block7;
                boolean bl = sign = ch == '-';
                if (bl && ++idx != end && (ch = str.charAt(idx)) >= '0' && ch <= '9') break block7;
            }
            throw new NumberFormatException(str);
        }
        while (true) {
            ival += 48 - ch;
            if (++idx == end) {
                return sign ? ival : -ival;
            }
            ch = str.charAt(idx);
            if (ch < '0' || ch > '9') {
                throw new NumberFormatException(str);
            }
            ival *= 10;
        }
    }

    public static int parseIntOrElse(String str, int defaultValue) {
        try {
            return Parser.parseIntException(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float parseFloat(String input) {
        return (float)Parser.parseDouble(input);
    }

    public static float parseFloatException(String input) throws NumberFormatException {
        return (float)Parser.parseDoubleException(input);
    }

    public static float[] parseFloatArray(String input) {
        if (input == null) {
            return null;
        }
        input = input.trim();
        String[] tokens = input.substring(1, input.length() - 1).split(",");
        List list = Arrays.stream(tokens).map(Parser::parseFloat).collect(Collectors.toList());
        float[] result = new float[list.size()];
        int i = 0;
        for (Float f : list) {
            result[i] = f.floatValue();
            ++i;
        }
        return result;
    }

    public static float[] parseFloatArrayException(String input) throws NumberFormatException {
        if (input == null) {
            return null;
        }
        input = input.trim();
        String[] tokens = input.substring(1, input.length() - 1).split(",");
        List list = Arrays.stream(tokens).map(Parser::parseFloatException).collect(Collectors.toList());
        float[] result = new float[list.size()];
        int i = 0;
        for (Float f : list) {
            result[i] = f.floatValue();
            ++i;
        }
        return result;
    }

    public static double[] parseDoubleArray(String input) {
        if (input == null) {
            return null;
        }
        input = input.trim();
        String[] tokens = input.substring(1, input.length() - 1).split(",");
        List list = Arrays.stream(tokens).map(Parser::parseDouble).collect(Collectors.toList());
        double[] result = new double[list.size()];
        int i = 0;
        for (Double f : list) {
            result[i] = f;
            ++i;
        }
        return result;
    }

    public static double[] parseDoubleArrayException(String input) throws NumberFormatException {
        if (input == null) {
            return null;
        }
        input = input.trim();
        String[] tokens = input.substring(1, input.length() - 1).split(",");
        List list = Arrays.stream(tokens).map(Parser::parseDoubleException).collect(Collectors.toList());
        double[] result = new double[list.size()];
        int i = 0;
        for (Double f : list) {
            result[i] = f;
            ++i;
        }
        return result;
    }
}

