/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class CommentedProperties
extends Properties {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public Vector<String> lineData = new Vector(0, 1);
    public Vector<String> keyData = new Vector(0, 1);

    private static char toHex(int var0) {
        return hexDigit[var0 & 0xF];
    }

    public void load(InputStreamReader isr) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(isr);
        while ((line = reader.readLine()) != null) {
            boolean isDelimiter;
            StringBuffer key;
            line = line.trim();
            char c = '\u0000';
            int pos = 0;
            if (!line.isEmpty() && line.charAt(0) == '\ufeff') {
                ++pos;
            }
            if (line.length() - pos == 0 || line.charAt(pos) == '#' || line.charAt(pos) == '!') {
                this.lineData.add(line);
                this.keyData.add("");
                continue;
            }
            int start = pos;
            boolean needsEscape = line.indexOf(92, pos) != -1;
            StringBuffer stringBuffer = key = needsEscape ? new StringBuffer() : null;
            block13: while (pos < line.length()) {
                char c2 = line.charAt(pos++);
                c = c2;
                if (Character.isWhitespace(c2) || c == 61 || c == 58) break;
                if (needsEscape && c == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) {
                            line = "";
                        }
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            key.append('\n');
                            continue block13;
                        }
                        case 't': {
                            key.append('\t');
                            continue block13;
                        }
                        case 'r': {
                            key.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block13;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            key.append(uni);
                            pos += 4;
                            continue block13;
                        }
                    }
                    key.append(c);
                    continue;
                }
                if (!needsEscape) continue;
                key.append(c);
            }
            boolean bl = isDelimiter = c == ':' || c == '=';
            String keyString = needsEscape ? key.toString() : (isDelimiter || Character.isWhitespace(c) ? line.substring(start, pos - 1) : line.substring(start, pos));
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (!(isDelimiter || c != ':' && c != '=')) {
                ++pos;
                while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                    ++pos;
                }
            }
            if (!needsEscape) {
                this.put(keyString, line.substring(pos));
                this.lineData.add("");
                this.keyData.add(keyString);
                continue;
            }
            StringBuilder element = new StringBuilder(line.length() - pos);
            block17: while (pos < line.length()) {
                if ((c = line.charAt(pos++)) == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) break;
                        for (pos = 0; pos < line.length() && Character.isWhitespace(line.charAt(pos)); ++pos) {
                        }
                        element.ensureCapacity(line.length() - pos + element.length());
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            element.append('\n');
                            continue block17;
                        }
                        case 't': {
                            element.append('\t');
                            continue block17;
                        }
                        case 'r': {
                            element.append('\r');
                            continue block17;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block17;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            element.append(uni);
                            pos += 4;
                            continue block17;
                        }
                    }
                    element.append(c);
                    continue;
                }
                element.append(c);
            }
            this.put(keyString, element.toString());
            this.lineData.add("");
            this.keyData.add(keyString);
        }
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        this.load(new InputStreamReader(inStream, StandardCharsets.UTF_8));
    }

    @Override
    public void store(OutputStream out, String header) throws IOException {
        this.store(out, header, "UTF-8");
    }

    public void store(OutputStream out, String header, String encoding, Map<String, String> missing) throws IOException {
        String val;
        String k;
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, encoding));
        HashSet<String> keys = new HashSet<String>(this.size());
        for (Object k2 : this.keySet()) {
            keys.add((String)k2);
        }
        for (int i = 0; i < this.lineData.size(); ++i) {
            String line = this.lineData.get(i);
            String key = this.keyData.get(i);
            if (!key.isEmpty()) {
                k = this.saveConvert(key, true, false);
                if (!(this.get(key) == null || missing != null && missing.containsKey(key))) {
                    val = this.saveConvert((String)this.get(key), false, false);
                    writer.println(k + "=" + val);
                } else if (missing == null || missing.isEmpty()) {
                    writer.println("#" + k + "=");
                } else if (missing.containsKey(key)) {
                    writer.println("#" + k + "=" + missing.get(key));
                } else {
                    writer.println("#" + k + "=");
                }
            } else {
                writer.println(line);
            }
            keys.remove(key);
        }
        if (!keys.isEmpty()) {
            writer.println("# Remaining new properties");
            for (String key : keys) {
                if (key.isEmpty()) continue;
                k = this.saveConvert(key, true, false);
                if (!(this.get(key) == null || missing != null && missing.containsKey(key))) {
                    val = this.saveConvert((String)this.get(key), false, false);
                    writer.println(k + "=" + val);
                    continue;
                }
                if (missing == null || missing.isEmpty()) {
                    writer.println("#" + k + "=");
                    continue;
                }
                if (missing.containsKey(key)) {
                    writer.println("#" + k + "=" + missing.get(key));
                    continue;
                }
                writer.println("#" + k + "=");
            }
        }
        writer.flush();
    }

    public void store(OutputStream out, String header, String encoding) throws IOException {
        this.store(out, header, encoding, null);
    }

    private String saveConvert(String var1, boolean var2, boolean var3) {
        int var4 = var1.length();
        int var5 = var4 * 2;
        if (var5 < 0) {
            var5 = Integer.MAX_VALUE;
        }
        StringBuilder var6 = new StringBuilder(var5);
        block8: for (int var7 = 0; var7 < var4; ++var7) {
            char var8 = var1.charAt(var7);
            if (var8 > '=' && var8 < '\u007f') {
                if (var8 == '\\') {
                    var6.append('\\');
                    var6.append('\\');
                    continue;
                }
                var6.append(var8);
                continue;
            }
            switch (var8) {
                case '\t': {
                    var6.append('\\');
                    var6.append('t');
                    continue block8;
                }
                case '\n': {
                    var6.append('\\');
                    var6.append('n');
                    continue block8;
                }
                case '\f': {
                    var6.append('\\');
                    var6.append('f');
                    continue block8;
                }
                case '\r': {
                    var6.append('\\');
                    var6.append('r');
                    continue block8;
                }
                case ' ': {
                    if (var7 == 0 || var2) {
                        var6.append('\\');
                    }
                    var6.append(' ');
                    continue block8;
                }
                case '=': {
                    var6.append('\\');
                    var6.append(var8);
                    continue block8;
                }
                default: {
                    if ((var8 < ' ' || var8 > '~') & var3) {
                        var6.append('\\');
                        var6.append('u');
                        var6.append(CommentedProperties.toHex(var8 >> 12 & 0xF));
                        var6.append(CommentedProperties.toHex(var8 >> 8 & 0xF));
                        var6.append(CommentedProperties.toHex(var8 >> 4 & 0xF));
                        var6.append(CommentedProperties.toHex(var8 & 0xF));
                        continue block8;
                    }
                    var6.append(var8);
                }
            }
        }
        return var6.toString();
    }

    private void formatForOutput(String str, StringBuffer buffer, boolean key) {
        if (key) {
            buffer.setLength(0);
            buffer.ensureCapacity(str.length());
        } else {
            buffer.ensureCapacity(buffer.length() + str.length());
        }
        boolean head = true;
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case ' ': {
                    buffer.append(head ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    buffer.append('\\').append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String hex = Integer.toHexString(c);
                        buffer.append("\\u0000", 0, 6 - hex.length());
                        buffer.append(hex);
                        break;
                    }
                    buffer.append(c);
                }
            }
            if (c == ' ') continue;
            head = key;
        }
    }

    public void add(String keyString, String value) {
        this.put(keyString, value);
        this.lineData.add("");
        this.keyData.add(keyString);
    }

    public void addLine(String line) {
        this.lineData.add(line);
        this.keyData.add("");
    }

    @Override
    public CommentedProperties clone() {
        CommentedProperties cl = new CommentedProperties();
        Set<Object> keys = this.keySet();
        for (Object key : keys) {
            cl.setProperty((String)key, this.getProperty((String)key));
        }
        cl.lineData = this.lineData;
        cl.keyData = this.keyData;
        return cl;
    }
}

