/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.samp;

import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.util.Logger;
import gaiasky.util.i18n.I18n;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.SampException;

public class GaiaSkyHubConnector
extends HubConnector {
    private static final Logger.Log logger = Logger.getLogger(GaiaSkyHubConnector.class);

    public GaiaSkyHubConnector(ClientProfile profile) {
        super(profile);
    }

    protected void connectionChanged(boolean isConnected) {
        super.connectionChanged(isConnected);
        String hubName = "-";
        try {
            hubName = super.getConnection().getRegInfo().getHubId();
        }
        catch (NullPointerException | SampException throwable) {
            // empty catch block
        }
        logger.info(isConnected ? I18n.msg("samp.connected", hubName) : I18n.msg("samp.disconnected"));
        EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)this, isConnected ? I18n.msg("samp.connected", hubName) : I18n.msg("samp.disconnected"));
    }

    protected void disconnect() {
        super.disconnect();
        logger.info(I18n.msg("samp.disconnected"));
    }
}

