/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.samp;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.GaiaSky;
import gaiasky.data.group.DatasetOptions;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.datasets.DatasetLoadDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Cluster;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.view.FocusView;
import gaiasky.script.EventScriptingInterface;
import gaiasky.util.CatalogInfo;
import gaiasky.util.CatalogManager;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.TwoWayMap;
import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.samp.GaiaSkyHubConnector;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.DefaultClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.MessageHandler;
import org.astrogrid.samp.client.SampException;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLDataSource;

public class SAMPClient
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(SAMPClient.class);
    private final CatalogManager catalogManager;
    private HubConnector conn;
    private TwoWayMap<String, Entity> idToNode;
    private Map<String, String> idToUrl;
    private boolean preventProgrammaticEvents = false;

    public SAMPClient(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        EventManager.instance.subscribe((IObserver)this, Event.FOCUS_CHANGED, Event.CATALOG_REMOVE, Event.DISPOSE);
    }

    public void initialize(final Skin skin) {
        java.util.logging.Logger.getLogger("org.astrogrid.samp").setLevel(Level.OFF);
        this.idToNode = new TwoWayMap();
        this.idToUrl = new HashMap<String, String>();
        ClientProfile cp = DefaultClientProfile.getProfile();
        this.conn = new GaiaSkyHubConnector(cp);
        Metadata meta = new Metadata();
        meta.setName(Settings.APPLICATION_NAME);
        meta.setDescriptionText("Open source 3D universe simulator for desktop and VR with support for more than a billion objects.");
        meta.setDocumentationUrl("http://docs.gaiasky.space");
        meta.setIconUrl(Settings.ICON_URL.replaceAll("[^\\x00-\\x7F]", "?"));
        meta.put((Object)"author.name", (Object)"Toni Sagrista Selles");
        meta.put((Object)"author.email", (Object)"tsagrista@ari.uni-heidelberg.de");
        meta.put((Object)"author.affiliation", (Object)"Universitaet Heidelberg, Zentrum fuer Astronomie, Astronomisches Rechen-Institut");
        meta.put((Object)"home.page", (Object)"https://gaiasky.space");
        meta.put((Object)"gaiasky.version", (Object)Settings.settings.version.version);
        this.conn.declareMetadata((Map)meta);
        this.conn.addMessageHandler((MessageHandler)new AbstractMessageHandler(this, "table.load.votable"){
            final /* synthetic */ SAMPClient this$0;
            {
                this.this$0 = this$0;
                super(mtype);
            }

            public Map<Object, Object> processCall(HubConnection c, String senderId, Message msg) {
                String name = (String)msg.getParam("name");
                String id = (String)msg.getParam("table-id");
                String url = (String)msg.getParam("url");
                boolean loaded = this.this$0.loadVOTable(url, id, name, skin);
                if (!loaded) {
                    logger.info(I18n.msg("samp.error.votable", name));
                }
                return null;
            }
        });
        this.conn.addMessageHandler((MessageHandler)new AbstractMessageHandler("table.highlight.row"){

            public Map<Object, Object> processCall(HubConnection c, String senderId, Message msg) {
                long row = Parser.parseLong((String)msg.getParam("row"));
                String id = (String)msg.getParam("table-id");
                boolean loaded = SAMPClient.this.idToNode.containsKey(id);
                if (loaded) {
                    logger.info("Select row " + row + " of " + id);
                    if (SAMPClient.this.idToNode.containsKey(id)) {
                        Entity node = SAMPClient.this.idToNode.getForward(id);
                        if (Mapper.particleSet.has(node) || Mapper.starSet.has(node)) {
                            ParticleSet pg = Mapper.particleSet.has(node) ? (ParticleSet)Mapper.particleSet.get(node) : (ParticleSet)Mapper.starSet.get(node);
                            pg.setFocusIndex((int)row);
                            SAMPClient.this.preventProgrammaticEvents = true;
                            EventManager.publish(Event.CAMERA_MODE_CMD, (Object)this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                            EventManager.publish(Event.FOCUS_CHANGE_CMD, (Object)this, node);
                            SAMPClient.this.preventProgrammaticEvents = false;
                        } else {
                            GraphNode graph = (GraphNode)Mapper.graph.get(node);
                            if (graph.children != null && graph.children.size > (int)row) {
                                Entity sgn = (Entity)graph.children.get((int)row);
                                SAMPClient.this.preventProgrammaticEvents = true;
                                EventManager.publish(Event.CAMERA_MODE_CMD, (Object)this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                                EventManager.publish(Event.FOCUS_CHANGE_CMD, (Object)this, sgn);
                                SAMPClient.this.preventProgrammaticEvents = false;
                            } else {
                                logger.info("Star cluster to select not found: " + row);
                            }
                        }
                    }
                }
                return null;
            }
        });
        this.conn.addMessageHandler((MessageHandler)new AbstractMessageHandler("table.select.rowList"){

            public Map<Object, Object> processCall(HubConnection c, String senderId, Message msg) {
                ArrayList rows = (ArrayList)msg.getParam("row-list");
                String id = (String)msg.getParam("table-id");
                boolean loaded = SAMPClient.this.idToNode.containsKey(id);
                if (loaded && rows != null && !rows.isEmpty()) {
                    Entity node;
                    logger.info("Select " + rows.size() + " rows of " + id + ". Gaia Sky does not support multiple selection, so only the first entry is selected.");
                    int row = Integer.parseInt((String)rows.get(0));
                    if (SAMPClient.this.idToNode.containsKey(id) && (Mapper.particleSet.has(node = SAMPClient.this.idToNode.getForward(id)) || Mapper.starSet.has(node))) {
                        ParticleSet pg = Mapper.particleSet.has(node) ? (ParticleSet)Mapper.particleSet.get(node) : (ParticleSet)Mapper.starSet.get(node);
                        pg.setFocusIndex(row);
                        SAMPClient.this.preventProgrammaticEvents = true;
                        EventManager.publish(Event.CAMERA_MODE_CMD, (Object)this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                        EventManager.publish(Event.FOCUS_CHANGE_CMD, (Object)this, pg);
                        SAMPClient.this.preventProgrammaticEvents = false;
                    }
                }
                return null;
            }
        });
        this.conn.addMessageHandler((MessageHandler)new AbstractMessageHandler(this, "coord.pointAt.sky"){

            public Map<Object, Object> processCall(HubConnection c, String senderId, Message msg) {
                double ra = Parser.parseDouble((String)msg.getParam("ra"));
                double dec = Parser.parseDouble((String)msg.getParam("dec"));
                logger.info("Point to coordinate (ra,dec): (" + ra + ", " + dec + ")");
                EventManager.publish(Event.CAMERA_MODE_CMD, (Object)this, new Object[]{CameraManager.CameraMode.FREE_MODE});
                EventManager.publish(Event.FREE_MODE_COORD_CMD, (Object)this, ra, dec);
                return null;
            }
        });
        this.conn.declareSubscriptions((Map)this.conn.computeSubscriptions());
        this.conn.setAutoconnect(10);
    }

    public String getStatus() {
        if (this.conn == null) {
            return I18n.msg("gui.debug.samp.notinit");
        }
        if (this.conn.isConnected()) {
            try {
                return I18n.msg("gui.debug.samp.connected", this.conn.getConnection().getRegInfo().getHubId());
            }
            catch (Exception e) {
                return I18n.msg("gui.debug.samp.error");
            }
        }
        return I18n.msg("gui.debug.samp.notconnected");
    }

    private boolean loadVOTable(String url, String id, String name, Skin skin) {
        logger.info("Loading VOTable: " + name + " from " + url);
        try {
            URLDataSource dataSource = new URLDataSource(new URI(url).toURL());
            Stage ui = GaiaSky.instance.mainGui.getGuiStage();
            String fileName = dataSource.getName();
            DatasetLoadDialog dld = new DatasetLoadDialog(I18n.msg("gui.dsload.title") + ": " + fileName, fileName, skin, ui);
            Runnable doLoad = () -> this.lambda$loadVOTable$0(dld, id, (DataSource)dataSource, url, fileName);
            dld.setAcceptListener(() -> {
                Thread t = new Thread(doLoad);
                t.start();
            });
            dld.show(ui);
            return true;
        }
        catch (Exception e) {
            logger.error(I18n.msg("notif.error", url), e);
            return false;
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case FOCUS_CHANGED: {
                if (this.preventProgrammaticEvents || this.conn == null || !this.conn.isConnected() || !(data[0] instanceof FocusView)) break;
                FocusView focus = (FocusView)data[0];
                Entity entity = focus.getEntity();
                if (focus.isSet()) {
                    ParticleSet pg = focus.getSet();
                    if (!this.idToNode.containsValue(entity)) break;
                    String id = this.idToNode.getBackward(entity);
                    String url = this.idToUrl.get(id);
                    int row = pg.candidateFocusIndex;
                    Message msg = new Message("table.highlight.row");
                    msg.addParam("row", (Object)Integer.toString(row));
                    msg.addParam("table-id", (Object)id);
                    msg.addParam("url", (Object)url);
                    try {
                        this.conn.getConnection().notifyAll((Map)msg);
                    }
                    catch (SampException e) {
                        logger.error(e);
                    }
                    break;
                }
                if (!Mapper.cluster.has(entity)) break;
                GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                Cluster cluster = (Cluster)Mapper.cluster.get(entity);
                if (graph.parent == null || !Mapper.fade.has(graph.parent) || !this.idToNode.containsValue(graph.parent)) break;
                String id = this.idToNode.getBackward(graph.parent);
                String url = this.idToUrl.get(id);
                GraphNode parentGraph = (GraphNode)Mapper.graph.get(graph.parent);
                int row = parentGraph.children.indexOf((Object)entity, true);
                Message msg = new Message("table.highlight.row");
                msg.addParam("row", (Object)Integer.toString(row));
                msg.addParam("table-id", (Object)id);
                msg.addParam("url", (Object)url);
                try {
                    this.conn.getConnection().notifyAll((Map)msg);
                }
                catch (SampException e) {
                    logger.error(e);
                }
                break;
            }
            case CATALOG_REMOVE: {
                String dsName = (String)data[0];
                if (this.idToNode.containsKey(dsName)) {
                    this.idToNode.removeKey(dsName);
                }
                this.idToUrl.remove(dsName);
                break;
            }
            case DISPOSE: {
                if (this.conn == null) break;
                this.conn.setActive(false);
            }
        }
    }

    private /* synthetic */ void lambda$loadVOTable$0(DatasetLoadDialog dld, String id, DataSource dataSource, String url, String fileName) {
        try {
            DatasetOptions datasetOptions = dld.generateDatasetOptions();
            boolean loaded = ((EventScriptingInterface)GaiaSky.instance.scripting()).loadDataset(id, dataSource, CatalogInfo.CatalogInfoSource.SAMP, datasetOptions, true);
            if (loaded) {
                CatalogInfo ci = this.catalogManager.get(id);
                Entity node = ci.entity;
                if (node != null) {
                    GraphNode graph = (GraphNode)Mapper.graph.get(node);
                    if (Mapper.particleSet.has(node) || Mapper.starSet.has(node)) {
                        ParticleSet pg;
                        ParticleSet particleSet = pg = Mapper.particleSet.has(node) ? (ParticleSet)Mapper.particleSet.get(node) : (ParticleSet)Mapper.starSet.get(node);
                        if (pg.data() != null && !pg.data().isEmpty() && EntityUtils.isVisibilityOn(node)) {
                            EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                            EventManager.publish(Event.FOCUS_CHANGE_CMD, this, pg.getFirstParticleName());
                        }
                    } else if (graph.children != null && !graph.children.isEmpty() && EntityUtils.isVisibilityOn((Entity)graph.children.get(0))) {
                        EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                        EventManager.publish(Event.FOCUS_CHANGE_CMD, this, graph.children.get(0));
                    }
                    GaiaSky.instance.scripting().expandUIPane("Datasets");
                    this.idToNode.add(id, node);
                    this.idToUrl.put(id, url);
                }
            }
        }
        catch (Exception e) {
            logger.error(I18n.msg("notif.error", fileName), e);
        }
    }
}

