/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.bookmarks.BookmarksManager;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.TextUtils;
import gaiasky.util.math.Vector3D;
import gaiasky.util.scene2d.OwnTextIconButton;

public class BookmarkButton
extends OwnTextIconButton {
    public BookmarksManager.BookmarkNode bookmark;
    private final FocusView view;

    public BookmarkButton(BookmarksManager.BookmarkNode bookmark, Skin skin) {
        super(TextUtils.capString(bookmark.name, 16), 8, skin, bookmark.isTypeFolder() ? "bookmarks-folder" : "bookmarks-bookmark");
        this.bookmark = bookmark;
        this.view = new FocusView();
        if (!bookmark.isTypeFolder()) {
            this.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    ChangeListener.ChangeEvent ce = (ChangeListener.ChangeEvent)event;
                    Scene scene = GaiaSky.instance.scene;
                    if (bookmark.position == null) {
                        Entity node;
                        String name = bookmark.name;
                        if (scene.index().containsEntity(name) && Mapper.focus.has(node = scene.getEntity(name))) {
                            this.view.setEntity(node);
                            this.view.getFocus(name);
                            FocusView focus = this.view;
                            boolean timeOverflow = focus.isCoordinatesTimeOverflow();
                            boolean ctOn = GaiaSky.instance.isOn(focus.getCt());
                            if (!timeOverflow && ctOn) {
                                GaiaSky.postRunnable(() -> {
                                    EventManager.publish(Event.CAMERA_MODE_CMD, (Object)this, new Object[]{CameraManager.CameraMode.FOCUS_MODE, true});
                                    EventManager.publish(Event.FOCUS_CHANGE_CMD, (Object)this, focus, true);
                                });
                            }
                        }
                    } else {
                        GaiaSky.postRunnable(() -> {
                            Vector3D p = bookmark.position;
                            Vector3D d = bookmark.direction;
                            Vector3D u = bookmark.up;
                            EventManager.publish(Event.CAMERA_MODE_CMD, (Object)this, new Object[]{CameraManager.CameraMode.FREE_MODE, true});
                            EventManager.publish(Event.CAMERA_POS_CMD, (Object)this, new Object[]{new double[]{p.x * Constants.DISTANCE_SCALE_FACTOR, p.y * Constants.DISTANCE_SCALE_FACTOR, p.z * Constants.DISTANCE_SCALE_FACTOR}});
                            EventManager.publish(Event.CAMERA_DIR_CMD, (Object)this, new Object[]{new double[]{d.x, d.y, d.z}});
                            EventManager.publish(Event.CAMERA_UP_CMD, (Object)this, new Object[]{new double[]{u.x, u.y, u.z}});
                            EventManager.publish(Event.TIME_CHANGE_CMD, (Object)this, bookmark.time);
                        });
                    }
                }
                return false;
            });
        }
    }
}

