/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import gaiasky.util.scene2d.OwnLabel;

public class ClickableLabel
extends OwnLabel {
    private Runnable clickAction;

    public ClickableLabel(CharSequence text, Label.LabelStyle style, Runnable clickAction) {
        super(text, style);
        this.clickAction = clickAction;
        this.initialize();
    }

    public ClickableLabel(CharSequence text, Skin skin, String fontName, Color color, Runnable clickAction) {
        super(text, skin, fontName, color);
        this.clickAction = clickAction;
        this.initialize();
    }

    public ClickableLabel(CharSequence text, Skin skin, String fontName, String colorName, Runnable clickAction) {
        super(text, skin, fontName, colorName);
        this.clickAction = clickAction;
        this.initialize();
    }

    public ClickableLabel(CharSequence text, Skin skin, String styleName, Runnable clickAction) {
        super(text, skin, styleName);
        this.clickAction = clickAction;
        this.initialize();
    }

    public ClickableLabel(CharSequence text, Skin skin, Runnable clickAction) {
        super(text, skin, "link");
        this.clickAction = clickAction;
        this.initialize();
    }

    private void initialize() {
        this.addListener((EventListener)new ClickListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return super.touchDown(event, x, y, pointer, button);
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 0 && ClickableLabel.this.clickAction != null) {
                    ClickableLabel.this.clickAction.run();
                }
                super.touchUp(event, x, y, pointer, button);
            }
        });
        this.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.enter) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
                return true;
            }
            return false;
        });
    }

    public void setClickAction(Runnable clickAction) {
        this.clickAction = clickAction;
    }
}

