/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import gaiasky.util.scene2d.OwnButton;
import gaiasky.util.scene2d.OwnImageButton;

public class CollapsibleEntry
extends OwnButton {
    private Cell<?> contentCell;
    private Cell<?> actorCell;
    private OwnImageButton collapse;
    private final Actor content;
    private Runnable expandRunnable;
    private Runnable collapseRunnable;

    public CollapsibleEntry(Actor title, Actor content, Skin skin, String styleName, boolean changeCursor) {
        super(skin, styleName, changeCursor);
        this.content = content;
        this.createActor(title, skin);
    }

    public CollapsibleEntry(Actor title, Actor content, Skin skin) {
        this(title, content, skin, "dataset-nofocus", false);
    }

    public void setWidth(float width) {
        this.contentCell.width(width);
        this.actorCell.width(width - 40.0f);
        super.setWidth(width);
    }

    public void collapse() {
        this.contentCell.setActor(null);
        this.me.pack();
        if (this.collapseRunnable != null) {
            this.collapseRunnable.run();
        }
    }

    public void expand() {
        this.contentCell.setActor(this.content);
        this.me.pack();
        if (this.expandRunnable != null) {
            this.expandRunnable.run();
        }
    }

    private void createActor(Actor title, Skin skin) {
        this.pad(5.0f);
        this.collapse = new OwnImageButton(skin, "expand-collapse");
        this.collapse.setCheckedNoFire(false);
        this.add((Actor)this.collapse).top().left().padBottom(10.0f).padRight(15.0f);
        this.actorCell = this.add(title).top().left().padBottom(10.0f);
        this.actorCell.row();
        this.contentCell = this.add().top().left().colspan(2).expandX();
        this.collapse.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                boolean checked = this.collapse.isChecked();
                if (!checked) {
                    this.collapse();
                } else {
                    this.expand();
                }
                return true;
            }
            return false;
        });
        title.addListener((EventListener)new ClickListener(){

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (event.getButton() == 0) {
                    boolean checked = CollapsibleEntry.this.collapse.isChecked();
                    if (checked) {
                        CollapsibleEntry.this.collapse();
                    } else {
                        CollapsibleEntry.this.expand();
                    }
                    CollapsibleEntry.this.collapse.setCheckedNoFire(!checked);
                }
                super.touchUp(event, x, y, pointer, button);
            }
        });
        title.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.enter) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
                return true;
            }
            return false;
        });
    }

    public void setExpandRunnable(Runnable r) {
        this.expandRunnable = r;
    }

    public void setCollapseRunnable(Runnable r) {
        this.collapseRunnable = r;
    }
}

