/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.CollapsibleWindow;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextTooltip;
import net.jafama.FastMath;

public class CollapsiblePane
extends Table {
    protected float collapseSpeed;
    private CollapsibleWindow dialogWindow;
    ImageButton expandIcon;
    ImageButton detachIcon;
    float lastX = -1.0f;
    float lastY = -1.0f;
    Actor content;
    String labelText;
    Skin skin;
    Stage stage;
    float space;
    Cell<?> contentCell;
    float targetHeight;
    boolean expanding = false;
    boolean collapsing = false;
    Runnable expandCollapseRunnable;

    public CollapsiblePane(Stage stage, Image icon, String title, Actor content, float width, Skin skin, String titleStyle, String expandButtonStyle, String detachButtonStyle, boolean expanded, String shortcut, Actor ... topIcons) {
        this(stage, icon, title, content, width, skin, titleStyle, expandButtonStyle, detachButtonStyle, expanded, null, shortcut, topIcons);
    }

    public CollapsiblePane(Stage stage, String title, Actor content, float width, Skin skin, String titleStyle, String expandButtonStyle, String detachButtonStyle, boolean expanded, String shortcut, Actor ... topIcons) {
        this(stage, null, title, content, width, skin, titleStyle, expandButtonStyle, detachButtonStyle, expanded, null, shortcut, topIcons);
    }

    public CollapsiblePane(Stage stage, Image icon, String title, Actor content, float width, Skin skin, String titleStyle, String expandButtonStyle, String detachButtonStyle, boolean expanded, Runnable expandCollapseRunnable, String shortcut, Actor ... topIcons) {
        super(skin);
        this.stage = stage;
        this.labelText = title;
        this.content = content;
        this.skin = skin;
        this.space = 6.4f;
        this.collapseSpeed = 100.0f;
        this.expandCollapseRunnable = expandCollapseRunnable;
        final OwnLabel titleLabel = new OwnLabel((CharSequence)title, skin, titleStyle);
        float lw = titleLabel.getWidth();
        Label.LabelStyle ls = (Label.LabelStyle)skin.get(titleStyle, Label.LabelStyle.class);
        float mWidth = width * 0.8f;
        if (lw > mWidth) {
            GlyphLayout layout = new GlyphLayout();
            for (int chars = title.length() - 1; chars > 0; --chars) {
                layout.setText(ls.font, (CharSequence)TextUtils.capString(title, chars));
                if (!(layout.width <= mWidth)) continue;
                titleLabel.setText(TextUtils.capString(title, chars));
                titleLabel.addListener((EventListener)new OwnTextTooltip(title, skin));
                break;
            }
        }
        titleLabel.addListener((EventListener)new ClickListener(this){
            final /* synthetic */ CollapsiblePane this$0;
            {
                this.this$0 = this$0;
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (event.getButton() == 0) {
                    this.this$0.toggleExpandCollapse((Actor)titleLabel);
                }
                super.touchUp(event, x, y, pointer, button);
            }
        });
        titleLabel.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.enter) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
                return true;
            }
            return false;
        });
        this.expandIcon = new OwnImageButton(skin, expandButtonStyle);
        this.expandIcon.setName("expand-collapse");
        this.expandIcon.setChecked(expanded);
        this.expandIcon.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.toggleExpandCollapse((Actor)this.expandIcon);
                return true;
            }
            return false;
        });
        if (shortcut == null) {
            this.expandIcon.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.expandcollapse.group"), skin));
        } else {
            this.expandIcon.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.tooltip.expandcollapse.group"), shortcut, skin));
        }
        if (detachButtonStyle != null) {
            this.detachIcon = new OwnImageButton(skin, detachButtonStyle);
            this.detachIcon.setName("detach-panel");
            this.detachIcon.setChecked(false);
            this.detachIcon.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.detach();
                    return true;
                }
                return false;
            });
            this.detachIcon.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.detach.group"), skin));
        }
        OwnLabel questionLabel = new OwnLabel((CharSequence)"(?)", skin, "question");
        if (shortcut != null && !shortcut.isEmpty()) {
            questionLabel.addListener((EventListener)new OwnTextHotkeyTooltip(title, shortcut, skin));
        }
        Table headerTable = new Table(skin);
        Table titleGroup = new Table(skin);
        titleGroup.add((Actor)this.expandIcon).padRight(10.0f);
        if (icon != null) {
            icon.setColor(skin.getColor("theme"));
            titleGroup.add((Actor)icon).size(icon.getWidth(), icon.getHeight()).padRight(6.4f);
        }
        titleGroup.add((Actor)titleLabel).padRight(6.4f);
        if (shortcut != null && !shortcut.isEmpty()) {
            titleGroup.add((Actor)questionLabel);
        }
        HorizontalGroup headerGroupLeft = new HorizontalGroup();
        headerGroupLeft.space(this.space).align(8);
        if (topIcons != null) {
            for (Actor topIcon : topIcons) {
                if (topIcon == null) continue;
                headerGroupLeft.addActor(topIcon);
            }
        }
        HorizontalGroup headerGroupRight = new HorizontalGroup();
        headerGroupRight.space(this.space).align(16);
        if (this.detachIcon != null) {
            headerGroupRight.addActor((Actor)this.detachIcon);
        }
        headerTable.add((Actor)titleGroup).left().padRight(6.4f);
        if (this.detachIcon != null) {
            headerTable.add((Actor)headerGroupLeft).right().pad(6.4f);
            headerTable.add().expandX();
            headerTable.add((Actor)headerGroupRight).right();
        } else {
            headerTable.add((Actor)headerGroupLeft).right().pad(6.4f).expandX();
        }
        this.add((Actor)headerTable).padBottom(this.space).width(width).row();
        this.contentCell = this.add().prefHeight(0.0f).width(width);
        if (expanded) {
            this.contentCell.setActor(content);
        }
        this.layout();
        this.targetHeight = this.getHeight();
    }

    public CollapsiblePane(Stage stage, String title, Actor content, float width, Skin skin, boolean expanded, String shortcut, Actor ... topIcons) {
        this(stage, title, content, width, skin, "header", "expand-collapse", "detach", expanded, shortcut, topIcons);
    }

    public boolean expandPane() {
        if (!this.expandIcon.isChecked()) {
            this.expandIcon.setChecked(true);
            this.expanding = true;
            this.collapsing = false;
            return true;
        }
        return false;
    }

    public boolean collapsePane() {
        if (this.expandIcon.isChecked()) {
            this.expandIcon.setChecked(false);
            this.expanding = false;
            this.collapsing = true;
            return true;
        }
        return false;
    }

    public void togglePane() {
        if (!this.expandPane()) {
            this.collapsePane();
        }
    }

    private void toggleExpandCollapse(Actor source) {
        boolean expand;
        if (source != this.expandIcon) {
            expand = !this.expandIcon.isChecked();
            this.expandIcon.setProgrammaticChangeEvents(false);
            this.expandIcon.setChecked(expand);
            this.expandIcon.setProgrammaticChangeEvents(true);
        } else {
            expand = this.expandIcon.isChecked();
        }
        if (expand && this.dialogWindow == null) {
            this.contentCell.setActor(this.content);
            this.expanding = true;
            this.collapsing = false;
        } else {
            this.contentCell.clearActor();
            this.expanding = false;
            this.collapsing = true;
        }
        if (this.expandCollapseRunnable != null) {
            this.expandCollapseRunnable.run();
        }
        this.pack();
        EventManager.publish(Event.RECALCULATE_CONTROLS_WINDOW_SIZE, (Object)this, new Object[0]);
    }

    public void detach() {
        this.dialogWindow = this.createWindow(this.labelText, this.content, this.skin, this.stage, this.lastX, this.lastY);
        if (!this.stage.getActors().contains((Object)this.dialogWindow, true)) {
            this.stage.addActor((Actor)this.dialogWindow);
        }
        this.expandIcon.setChecked(false);
        this.expandIcon.setDisabled(true);
        this.detachIcon.setDisabled(true);
    }

    private CollapsibleWindow createWindow(String labelText, Actor content, Skin skin, Stage stage, float x, float y) {
        CollapsibleWindow window = new CollapsibleWindow(labelText, skin);
        window.align(1);
        OwnScrollPane contentScroll = new OwnScrollPane(content, skin, "minimalist-nobg");
        contentScroll.setName("collapsible pane scroll");
        contentScroll.setSize(content.getWidth(), content.getHeight() * 1.1f);
        window.add((Actor)contentScroll).pad(8.0f).row();
        OwnTextButton close = new OwnTextButton(I18n.msg("gui.close"), skin, "default");
        close.setName("close");
        close.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.lastX = window.getX();
                this.lastY = window.getY();
                window.remove();
                this.dialogWindow = null;
                this.expandIcon.setDisabled(false);
                this.detachIcon.setDisabled(false);
                return true;
            }
            return false;
        });
        Container closeContainer = new Container((Actor)close);
        close.setWidth(185.0f);
        closeContainer.align(16);
        window.add((Actor)closeContainer).pad(8.0f).bottom().right();
        window.getTitleTable().align(8);
        window.align(8);
        window.pack();
        x = x < 0.0f ? stage.getWidth() / 2.0f - window.getWidth() / 2.0f : x;
        y = y < 0.0f ? stage.getHeight() / 2.0f - window.getHeight() / 2.0f : y;
        window.setPosition(Math.round(x), FastMath.round((float)y));
        window.pack();
        return window;
    }

    public Button getExpandCollapseActor() {
        return this.expandIcon;
    }
}

