/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.OwnWindow;
import net.jafama.FastMath;

public class CollapsibleWindow
extends OwnWindow {
    protected Actor me;
    protected Skin skin;
    protected float collapseSpeed;
    String expandIcon = "window-expand";
    String collapseIcon = "window-collapse";
    private boolean collapsed;
    private boolean collapsing = false;
    private boolean expanding = false;
    private float collapseHeight;
    private float expandHeight;
    private Vector2 vec2;
    private float maxWidth = -1.0f;
    private float maxHeight = -1.0f;
    private boolean collapsible = true;

    public CollapsibleWindow(String title, Skin skin) {
        this(title, skin, 2000.0f);
    }

    public CollapsibleWindow(String title, Skin skin, String styleName) {
        this(title, skin, styleName, 2000.0f);
    }

    public CollapsibleWindow(String title, Skin skin, float collapseSpeed) {
        super(title, skin);
        this.initWindow(skin, collapseSpeed);
    }

    public CollapsibleWindow(String title, Skin skin, String styleName, float collapseSpeed) {
        super(title, skin, styleName);
        this.initWindow(skin, collapseSpeed);
    }

    private void initWindow(Skin skin, float collapseSpeed) {
        this.me = this;
        this.skin = skin;
        this.collapseSpeed = collapseSpeed;
        this.collapseHeight = 32.0f;
        this.vec2 = new Vector2();
        this.addListener((EventListener)new ClickListener(){
            private float startx;
            private float starty;

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                this.startx = x + CollapsibleWindow.this.getX();
                this.starty = y + CollapsibleWindow.this.getY();
                return super.touchDown(event, x, y, pointer, button);
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                float endx = x + CollapsibleWindow.this.getX();
                float endy = y + CollapsibleWindow.this.getY();
                CollapsibleWindow.this.vec2.set(endx - this.startx, endy - this.starty);
                if (CollapsibleWindow.this.vec2.len() < 3.0f && CollapsibleWindow.this.getHeight() - y <= CollapsibleWindow.this.getPadTop() && y < CollapsibleWindow.this.getHeight() && x > 0.0f && x < CollapsibleWindow.this.getWidth() && button == 0) {
                    CollapsibleWindow.this.toggleCollapsed();
                }
                super.touchUp(event, x, y, pointer, button);
            }
        });
        ((Cell)this.getTitleTable().getCells().get(0)).padLeft(8.0f);
        this.getTitleTable().addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (this.collapsible && type == InputEvent.Type.mouseMoved) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
                return true;
            }
            return false;
        });
        this.addListener(event -> {
            if (this.isResizable() && event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.mouseMoved) {
                    if ((this.edge & 4) != 0 && this.maxHeight == -1.0f) {
                        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.VerticalResize);
                    } else if ((this.edge & 0x10) != 0 && this.maxWidth == -1.0f) {
                        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.HorizontalResize);
                    }
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
            }
            return false;
        });
        if (this.collapsible) {
            this.getTitleTable().addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.expandcollapse"), skin));
        }
    }

    @Override
    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        float width = this.getWidth();
        float height = this.getHeight();
        float padTop = this.getPadTop();
        super.drawBackground(batch, parentAlpha, x, y);
        if (this.collapsible) {
            Drawable icon = this.collapsed ? this.skin.getDrawable(this.expandIcon) : this.skin.getDrawable(this.collapseIcon);
            float iw = icon.getMinWidth();
            float ih = icon.getMinHeight();
            y += height - this.getPadTop() / 2.0f + 5.0f;
            icon.draw(batch, x += width - iw - this.getPadRight(), y -= (padTop - ih) / 2.0f, iw, ih);
        }
    }

    public void act(float delta) {
        super.act(delta);
        if (this.collapsing) {
            float pixels = this.collapseSpeed * delta;
            if (this.getHeight() > this.collapseHeight) {
                float currHeight = this.getHeight();
                float newHeight = FastMath.max((float)this.collapseHeight, (float)(currHeight - pixels));
                this.setHeight(newHeight);
                this.setY(this.getY() + (currHeight - newHeight));
            } else {
                if (this.getStage() != null) {
                    this.getStage().setScrollFocus(null);
                }
                this.collapsing = false;
                this.collapsed = true;
            }
        } else if (this.expanding) {
            float pixels = this.collapseSpeed * delta;
            if (this.getHeight() < this.expandHeight) {
                float currHeight = this.getHeight();
                float newHeight = FastMath.min((float)this.expandHeight, (float)(currHeight + pixels));
                this.setHeight(newHeight);
                this.setY(this.getY() + (currHeight - newHeight));
            } else {
                this.expanding = false;
                this.collapsed = false;
            }
        }
    }

    public void expand() {
        if (!this.collapsed || this.expanding || this.collapsing) {
            return;
        }
        this.expanding = true;
    }

    public void expandInstant() {
        if (!this.collapsed) {
            return;
        }
        this.setHeight(this.expandHeight);
        this.setY(this.getY() - this.expandHeight + this.collapseHeight);
        this.collapsed = false;
    }

    public void collapse() {
        if (this.collapsible) {
            if (this.collapsed || this.expanding || this.collapsing) {
                return;
            }
            this.expandHeight = this.getHeight();
            this.collapsing = true;
        }
    }

    public void collapseInstant() {
        if (this.collapsible) {
            if (this.collapsed) {
                return;
            }
            this.expandHeight = this.getHeight();
            this.setHeight(this.collapseHeight);
            this.setY(this.getY() + this.expandHeight - this.collapseHeight);
            this.collapsed = true;
            if (this.getStage() != null) {
                this.getStage().setScrollFocus(null);
            }
        }
    }

    public void toggleCollapsed() {
        if (this.collapsible) {
            if (this.collapsed) {
                this.expand();
            } else {
                this.collapse();
            }
        }
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
        if (collapsible) {
            this.getTitleTable().addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.expandcollapse"), this.skin));
        } else {
            this.getTitleTable().clearListeners();
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void pack() {
        this.collapsed = false;
        super.pack();
    }

    public void setResizable(boolean w, boolean h) {
        this.setResizable(w || h);
        if (w) {
            this.maxWidth = -1.0f;
        } else {
            this.pack();
            this.maxWidth = this.getWidth();
        }
        if (h) {
            this.maxHeight = -1.0f;
        } else {
            this.pack();
            this.maxHeight = this.getHeight();
        }
    }

    @Override
    public float getPrefWidth() {
        if (this.maxWidth < 0.0f) {
            return super.getPrefWidth();
        }
        return this.maxWidth;
    }

    public float getMaxWidth() {
        if (this.maxWidth < 0.0f) {
            return super.getMaxWidth();
        }
        return this.maxWidth;
    }

    public float getWidth() {
        if (this.maxWidth < 0.0f) {
            return super.getWidth();
        }
        return this.maxWidth;
    }

    public float getPrefHeight() {
        if (this.maxHeight < 0.0f) {
            return super.getPrefHeight();
        }
        return this.maxHeight;
    }

    public float getMaxHeight() {
        if (this.maxHeight < 0.0f) {
            return super.getMaxHeight();
        }
        return this.maxHeight;
    }

    @Override
    public void setModal(boolean isModal) {
        super.setModal(isModal);
        this.setCollapsible(!isModal);
    }

    public float getHeight() {
        if (this.maxHeight < 0.0f) {
            return super.getHeight();
        }
        return this.maxHeight;
    }
}

