/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.SnapshotArray;
import gaiasky.util.scene2d.ActorUtils;
import gaiasky.util.scene2d.MenuItem;
import gaiasky.util.scene2d.Separator;

public class ContextMenu
extends Table {
    private static final Vector2 tmpVector = new Vector2();
    private final Skin skin;
    private final ContextMenuStyle style;
    private ContextMenuListener listener;
    private InputListener stageListener;
    private InputListener sharedMenuItemInputListener;
    private ChangeListener sharedMenuItemChangeListener;
    private InputListener defaultInputListener;
    private ContextMenu parentSubMenu;
    private ContextMenu activeSubMenu;
    private MenuItem activeItem;

    public ContextMenu(Skin skin, String styleName) {
        this.skin = skin;
        this.style = (ContextMenuStyle)skin.get(styleName, ContextMenuStyle.class);
        this.setTouchable(Touchable.enabled);
        this.pad(0.0f);
        this.setBackground(this.style.background);
        this.createListeners();
    }

    public static void removeAll(Stage stage) {
        for (Actor actor : stage.getActors()) {
            if (!(actor instanceof ContextMenu)) continue;
            ContextMenu menu = (ContextMenu)actor;
            menu.removeHierarchy();
        }
    }

    private void createListeners() {
        this.stageListener = new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!ContextMenu.this.getRootMenu().subMenuStructureContains(x, y)) {
                    ContextMenu.this.remove();
                }
                return true;
            }

            public boolean keyDown(InputEvent event, int keycode) {
                SnapshotArray children = ContextMenu.this.getChildren();
                if (children.size == 0 || ContextMenu.this.activeSubMenu != null) {
                    return false;
                }
                if (keycode == 20) {
                    ContextMenu.this.selectNextItem();
                }
                if (ContextMenu.this.activeItem == null) {
                    return false;
                }
                if (keycode == 19) {
                    ContextMenu.this.selectPreviousItem();
                }
                if (keycode == 21 && ContextMenu.this.activeItem.containerMenu.parentSubMenu != null) {
                    ContextMenu.this.activeItem.containerMenu.parentSubMenu.setActiveSubMenu(null);
                }
                if (keycode == 22 && ContextMenu.this.activeItem.getSubMenu() != null) {
                    ContextMenu.this.activeItem.showSubMenu();
                    ContextMenu.this.activeSubMenu.selectNextItem();
                }
                if (keycode == 66) {
                    ContextMenu.this.activeItem.fireChangeEvent();
                }
                return true;
            }
        };
        this.sharedMenuItemInputListener = new InputListener(){

            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                MenuItem item;
                Actor actor;
                if (pointer == -1 && (actor = event.getListenerActor()) instanceof MenuItem && !(item = (MenuItem)actor).isDisabled()) {
                    ContextMenu.this.setActiveItem(item, false);
                }
            }

            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                Actor actor;
                if (pointer == -1 && (actor = event.getListenerActor()) instanceof MenuItem) {
                    MenuItem item = (MenuItem)actor;
                    if (ContextMenu.this.activeSubMenu != null) {
                        return;
                    }
                    if (item == ContextMenu.this.activeItem) {
                        ContextMenu.this.setActiveItem(null, false);
                    }
                }
            }
        };
        this.sharedMenuItemChangeListener = new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!event.isStopped()) {
                    ContextMenu.this.removeHierarchy();
                }
            }
        };
    }

    private ContextMenu getRootMenu() {
        if (this.parentSubMenu != null) {
            return this.parentSubMenu.getRootMenu();
        }
        return this;
    }

    private boolean subMenuStructureContains(float x, float y) {
        if (this.contains(x, y)) {
            return true;
        }
        if (this.activeSubMenu != null) {
            return this.activeSubMenu.subMenuStructureContains(x, y);
        }
        return false;
    }

    private void removeHierarchy() {
        if (this.activeItem != null && this.activeItem.containerMenu.parentSubMenu != null) {
            this.activeItem.containerMenu.parentSubMenu.removeHierarchy();
        }
        this.remove();
    }

    private void selectNextItem() {
        Actor actor;
        int startIndex;
        SnapshotArray children = this.getChildren();
        if (children.size == 0) {
            return;
        }
        int i = startIndex = this.activeItem == null ? 0 : children.indexOf((Object)this.activeItem, true) + 1;
        while (true) {
            if (i >= children.size) {
                i = 0;
            }
            if ((actor = (Actor)children.get(i)) instanceof MenuItem && !((MenuItem)actor).isDisabled()) break;
            ++i;
        }
        this.setActiveItem((MenuItem)actor, true);
    }

    private void selectPreviousItem() {
        Actor actor;
        int startIndex;
        SnapshotArray children = this.getChildren();
        if (children.size == 0) {
            return;
        }
        int i = startIndex = children.indexOf((Object)this.activeItem, true) - 1;
        while (true) {
            if (i == -1) {
                i = children.size - 1;
            }
            if ((actor = (Actor)children.get(i)) instanceof MenuItem && !((MenuItem)actor).isDisabled()) break;
            --i;
        }
        this.setActiveItem((MenuItem)actor, true);
    }

    public <T extends Actor> Cell<T> add(T actor) {
        if (actor instanceof MenuItem) {
            throw new IllegalArgumentException("MenuItems can be only added to ContextMenu by using addItem(MenuItem) method");
        }
        return super.add(actor);
    }

    public void addItem(MenuItem item) {
        super.add((Actor)item).fillX().expandX().row();
        this.pack();
        item.addListener((EventListener)this.sharedMenuItemChangeListener);
        item.addListener((EventListener)this.sharedMenuItemInputListener);
    }

    public void addSeparator() {
        this.add(new Separator(this.skin, "gray")).padTop(2.0f).padBottom(2.0f).fillX().expandX().row();
    }

    public InputListener getDefaultInputListener() {
        return this.getDefaultInputListener(1);
    }

    public InputListener getDefaultInputListener(final int mouseButton) {
        if (this.defaultInputListener == null) {
            this.defaultInputListener = new InputListener(this){
                final /* synthetic */ ContextMenu this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == mouseButton) {
                        this.this$0.showMenu(event.getStage(), event.getStageX(), event.getStageY());
                    }
                }
            };
        }
        return this.defaultInputListener;
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.style.border != null) {
            this.style.border.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void showMenu(Stage stage, float x, float y) {
        this.setPosition(x, y - this.getHeight());
        if (stage.getHeight() - this.getY() > stage.getHeight()) {
            this.setY(this.getY() + this.getHeight());
        }
        ActorUtils.keepWithinStage(stage, (Actor)this);
        stage.addActor((Actor)this);
    }

    public void showMenu(Stage stage, Actor actor) {
        Vector2 pos = actor.localToStageCoordinates(tmpVector.setZero());
        float menuY = pos.y - this.getHeight() <= 0.0f ? pos.y + actor.getHeight() + this.getHeight() - 5.0f : pos.y + 5.0f;
        this.showMenu(stage, pos.x, menuY);
    }

    public boolean contains(float x, float y) {
        return this.getX() < x && this.getX() + this.getWidth() > x && this.getY() < y && this.getY() + this.getHeight() > y;
    }

    void setActiveSubMenu(ContextMenu newSubMenu) {
        if (this.activeSubMenu == newSubMenu) {
            return;
        }
        if (this.activeSubMenu != null) {
            this.activeSubMenu.remove();
        }
        this.activeSubMenu = newSubMenu;
        if (newSubMenu != null) {
            newSubMenu.setParentMenu(this);
        }
    }

    protected void setStage(Stage stage) {
        super.setStage(stage);
        if (stage != null) {
            stage.addListener((EventListener)this.stageListener);
        }
    }

    public boolean remove() {
        if (this.getStage() != null) {
            this.getStage().removeListener((EventListener)this.stageListener);
        }
        if (this.activeSubMenu != null) {
            this.activeSubMenu.remove();
        }
        this.setActiveItem(null, false);
        this.parentSubMenu = null;
        this.activeSubMenu = null;
        return super.remove();
    }

    void setActiveItem(MenuItem newItem, boolean keyboardChange) {
        this.activeItem = newItem;
        if (this.listener != null) {
            this.listener.activeItemChanged(newItem, keyboardChange);
        }
    }

    public MenuItem getActiveItem() {
        return this.activeItem;
    }

    void setParentMenu(ContextMenu parentSubMenu) {
        this.parentSubMenu = parentSubMenu;
    }

    public ContextMenuListener getListener() {
        return this.listener;
    }

    public void setListener(ContextMenuListener listener) {
        this.listener = listener;
    }

    public static class ContextMenuStyle {
        public Drawable background;
        public Drawable border;

        public ContextMenuStyle() {
        }

        public ContextMenuStyle(Drawable background, Drawable border) {
            this.background = background;
            this.border = border;
        }

        public ContextMenuStyle(ContextMenuStyle style) {
            this.background = style.background;
            this.border = style.border;
        }
    }

    public static interface ContextMenuListener {
        public void activeItemChanged(MenuItem var1, boolean var2);
    }
}

