/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ArraySelection;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Logger;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.validator.DirectoryNameValidator;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.function.Consumer;

public class FileChooser
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(FileChooser.class);
    private static final Comparator<FileListItem> dirListComparator = (file1, file2) -> {
        if (Files.isDirectory(file1.file, new LinkOption[0]) && !Files.isDirectory(file2.file, new LinkOption[0])) {
            return -1;
        }
        if (Files.isDirectory(file1.file, new LinkOption[0]) && Files.isDirectory(file2.file, new LinkOption[0])) {
            return file1.name.compareTo(file2.name);
        }
        if (!Files.isDirectory(file1.file, new LinkOption[0]) && !Files.isDirectory(file2.file, new LinkOption[0])) {
            return file1.name.compareTo(file2.name);
        }
        return 1;
    };
    private final FileChooserTarget target;
    private final Path baseDir;
    private final boolean directoryBrowsingEnabled;
    private final boolean fileBrowsingEnabled;
    protected String result;
    protected ResultListener resultListener;
    protected EventListener selectionListener;
    private boolean fileNameEnabled;
    private TextField fileNameInput;
    private Label acceptedFiles;
    private OwnTextField location;
    private List<FileListItem> fileList;
    private float scrollPaneWidth;
    private float maxPathLength;
    private ScrollPane scrollPane;
    private CheckBox hidden;
    private Consumer<Boolean> hiddenConsumer;
    private Path currentDir;
    private Path previousDir;
    private Path nextDir;
    private long lastClick = 0L;
    private boolean showHidden = false;
    private DirectoryStream.Filter<Path> filter;
    private PathnameFilter pathnameFilter;

    public FileChooser(String title, Skin skin, Stage stage, Path baseDir, FileChooserTarget target) {
        this(title, skin, stage, baseDir, target, null);
    }

    public FileChooser(String title, Skin skin, Stage stage, Path baseDir, FileChooserTarget target, EventListener selectionListener) {
        this(title, skin, stage, baseDir, target, selectionListener, true);
    }

    public FileChooser(String title, Skin skin, Stage stage, Path baseDir, FileChooserTarget target, EventListener selectionListener, boolean directoryBrowsingEnabled) {
        super(title, skin, stage);
        this.baseDir = baseDir;
        this.selectionListener = selectionListener;
        this.target = target;
        this.fileBrowsingEnabled = target == FileChooserTarget.FILES;
        this.directoryBrowsingEnabled = directoryBrowsingEnabled;
        this.setCancelText(I18n.msg("gui.close"));
        this.setAcceptText(I18n.msg("gui.select"));
        this.buildSuper();
    }

    @Override
    public void build() {
        this.scrollPaneWidth = 960.0f;
        float scrollPanelHeight = 720.0f;
        this.maxPathLength = 9.5f;
        this.content.top().left();
        this.content.defaults().space(8.0f);
        this.padLeft(16.0f);
        this.padRight(16.0f);
        Table controlsTable = new Table(this.skin);
        OwnTextIconButton home = new OwnTextIconButton("", this.skin, "home");
        home.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.fc.home"), this.skin));
        home.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                try {
                    this.previousDir = this.currentDir;
                    this.changeDirectory(SysUtils.getHomeDir());
                }
                catch (IOException e) {
                    logger.error(e);
                }
                this.lastClick = 0L;
                return true;
            }
            return false;
        });
        OwnTextIconButton back = new OwnTextIconButton("", this.skin, "back");
        back.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.fc.back"), this.skin));
        back.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                try {
                    if (this.previousDir != null) {
                        this.nextDir = this.currentDir;
                        this.changeDirectory(this.previousDir);
                    }
                }
                catch (IOException e) {
                    logger.error(e);
                }
                this.lastClick = 0L;
                return true;
            }
            return false;
        });
        OwnTextIconButton fwd = new OwnTextIconButton("", this.skin, "forward");
        fwd.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.fc.forward"), this.skin));
        fwd.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                try {
                    if (this.nextDir != null) {
                        this.previousDir = this.currentDir;
                        this.changeDirectory(this.nextDir);
                    }
                }
                catch (IOException e) {
                    logger.error(e);
                }
                this.lastClick = 0L;
                return true;
            }
            return false;
        });
        OwnTextIconButton parent = new OwnTextIconButton("", this.skin, "up");
        parent.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.fc.parent"), this.skin));
        parent.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                try {
                    if (this.currentDir.getParent() != null) {
                        this.previousDir = this.currentDir;
                        this.changeDirectory(this.currentDir.getParent());
                    }
                }
                catch (IOException e) {
                    logger.error(e);
                }
                this.lastClick = 0L;
                return true;
            }
            return false;
        });
        controlsTable.add((Actor)home).left().padRight(pad10);
        controlsTable.add((Actor)back).left().padRight(pad10);
        controlsTable.add((Actor)parent).left().padRight(pad10);
        controlsTable.add((Actor)fwd).left().padRight(pad18);
        this.location = new OwnTextField("", this.skin);
        this.location.setWidth(745.0f);
        this.location.setAlignment(8);
        this.location.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                try {
                    Path locPath = Path.of(this.location.getText(), new String[0]);
                    if (Files.exists(locPath, new LinkOption[0]) && Files.isDirectory(locPath, new LinkOption[0])) {
                        this.previousDir = this.currentDir;
                        this.changeDirectory(locPath);
                        GaiaSky.postRunnable(() -> {
                            this.stage.setKeyboardFocus((Actor)this.location);
                            this.location.setCursorPosition(this.location.getText().length());
                        });
                    }
                }
                catch (IOException e) {
                    logger.error(e);
                }
                return true;
            }
            return false;
        });
        controlsTable.add((Actor)this.location).left().padLeft(pad18).row();
        if (this.target == FileChooserTarget.DIRECTORIES || this.target == FileChooserTarget.ALL) {
            OwnTextIconButton newDirectory = new OwnTextIconButton(I18n.msg("gui.fc.newdirectory"), this.skin, "add");
            newDirectory.setWidth(245.0f);
            newDirectory.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    NewDirectoryDialog newDirectoryDialog = new NewDirectoryDialog(this.skin, this.stage);
                    newDirectoryDialog.setAcceptListener(() -> {
                        if (newDirectoryDialog.name.isValid()) {
                            String newName = newDirectoryDialog.getNewDirectoryName();
                            Path newDir = this.currentDir.resolve(newName);
                            try {
                                Files.createDirectory(newDir, new FileAttribute[0]);
                                this.changeDirectory(this.currentDir);
                            }
                            catch (IOException e) {
                                logger.error(e, I18n.msg("notif.error", e.getLocalizedMessage()));
                            }
                        } else {
                            logger.warn(I18n.msg("gui.fc.newdirecotory.invalid"));
                        }
                    });
                    newDirectoryDialog.show(this.stage);
                    this.stage.setKeyboardFocus((Actor)newDirectoryDialog);
                    return true;
                }
                return false;
            });
            controlsTable.add((Actor)newDirectory).colspan(5).right().padLeft(pad18).padTop(pad10).padBottom(pad10);
        }
        HorizontalGroup driveButtonsList = new HorizontalGroup();
        driveButtonsList.left().space(16.0f);
        driveButtonsList.addActor((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.fc.drives") + ":"), this.skin));
        Iterable<Path> drives = FileSystems.getDefault().getRootDirectories();
        Array driveButtons = new Array();
        for (Path drive : drives) {
            OwnTextIconButton driveButton = new OwnTextIconButton(drive.toString(), this.skin, "drive");
            driveButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.fc.drive", drive.toString()), this.skin));
            driveButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    try {
                        this.changeDirectory(drive);
                    }
                    catch (IOException e) {
                        logger.error(e);
                    }
                    this.lastClick = 0L;
                    return true;
                }
                return false;
            });
            driveButtons.add((Object)driveButton);
            driveButtonsList.addActor((Actor)driveButton);
        }
        this.acceptedFiles = new Label((CharSequence)"", this.skin, "sc-header");
        this.acceptedFiles.setAlignment(16);
        this.fileList = new List(this.skin, "light");
        this.scrollPane = new OwnScrollPane((Actor)this.fileList, this.skin, "minimalist");
        this.scrollPane.setScrollingDisabled(true, false);
        this.scrollPane.setSmoothScrolling(true);
        this.scrollPane.setFadeScrollBars(false);
        this.fileList.getSelection().setProgrammaticChangeEvents(false);
        if (this.selectionListener != null) {
            this.fileList.addListener(this.selectionListener);
        }
        this.fileList.addListener(event -> {
            InputEvent ie;
            if (event instanceof InputEvent && (ie = (InputEvent)event).getType() == InputEvent.Type.keyTyped) {
                char ch = ie.getCharacter();
                Array l = this.fileList.getItems();
                FileListItem toSelect = null;
                for (FileListItem fli : l) {
                    if (Character.toUpperCase(fli.name.charAt(0)) != Character.toUpperCase(ch)) continue;
                    toSelect = fli;
                    break;
                }
                if (toSelect != null) {
                    this.fileList.setSelected(toSelect);
                    int si = this.fileList.getSelectedIndex();
                    float px = (float)si * this.fileList.getItemHeight();
                    this.scrollPane.setScrollY(px);
                }
            }
            return false;
        });
        this.fileList.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileListItem selected = (FileListItem)FileChooser.this.fileList.getSelected();
                FileChooser.this.result = selected.name;
                FileChooser.this.fileNameInput.setText(FileChooser.this.result);
                FileChooser.this.lastClick = 0L;
            }
        });
        this.fileList.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                FileListItem selected = (FileListItem)FileChooser.this.fileList.getSelected();
                if (TimeUtils.millis() - FileChooser.this.lastClick < 250L) {
                    Path sel = selected.file;
                    try {
                        if (FileChooser.this.directoryBrowsingEnabled && Files.isDirectory(sel, new LinkOption[0])) {
                            if (selected.name.trim().equals("..")) {
                                FileChooser.this.nextDir = FileChooser.this.currentDir;
                            } else {
                                FileChooser.this.previousDir = FileChooser.this.currentDir;
                            }
                            FileChooser.this.changeDirectory(sel);
                            FileChooser.this.lastClick = 0L;
                        } else if (FileChooser.this.target == FileChooserTarget.FILES && (FileChooser.this.filter == null || FileChooser.this.filter.accept(sel))) {
                            FileChooser.this.acceptButton.fire((Event)new ChangeListener.ChangeEvent());
                            FileChooser.this.lastClick = 0L;
                        }
                    }
                    catch (IOException e) {
                        logger.error(e);
                        FileChooser.this.lastClick = 0L;
                    }
                } else if (event.getType() == InputEvent.Type.touchUp) {
                    FileChooser.this.lastClick = TimeUtils.millis();
                }
            }
        });
        this.fileNameInput = new OwnTextField("", this.skin);
        Label fileNameLabel = new Label((CharSequence)(I18n.msg("gui.fc.filename") + ":"), this.skin);
        this.fileNameInput.setTextFieldListener((textField, c) -> {
            this.result = textField.getText();
        });
        this.hidden = new OwnCheckBox(I18n.msg("gui.fc.showhidden"), this.skin, 8.0f);
        this.hidden.setChecked(false);
        this.hidden.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.showHidden = this.hidden.isChecked();
                try {
                    this.changeDirectory(this.currentDir);
                }
                catch (IOException e) {
                    logger.error(e);
                }
                if (this.hiddenConsumer != null) {
                    this.hiddenConsumer.accept(this.showHidden);
                }
                return true;
            }
            return false;
        });
        this.filter = pathname -> {
            boolean root;
            boolean bl = root = Files.isDirectory(pathname, new LinkOption[0]) && this.directoryBrowsingEnabled || Files.isRegularFile(pathname, new LinkOption[0]) && this.fileBrowsingEnabled;
            if (root && this.pathnameFilter != null && Files.isRegularFile(pathname, new LinkOption[0])) {
                root = this.pathnameFilter.accept((Path)pathname);
            }
            return root;
        };
        this.setTargetListener();
        this.content.add((Actor)this.acceptedFiles).top().left().row();
        this.content.add((Actor)driveButtonsList).top().left().row();
        this.content.add((Actor)controlsTable).top().left().row();
        this.content.add((Actor)this.scrollPane).size(this.scrollPaneWidth, scrollPanelHeight).left().fill().expand().row();
        this.content.add((Actor)this.hidden).top().left().row();
        if (this.fileNameEnabled) {
            this.content.add((Actor)fileNameLabel).fillX().expandX().row();
            this.content.add((Actor)this.fileNameInput).fillX().expandX().row();
            this.stage.setKeyboardFocus((Actor)this.fileNameInput);
        }
        try {
            this.changeDirectory(this.baseDir);
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    private void changeDirectory(Path directory) throws IOException {
        Path lastDir = directory != this.currentDir ? this.currentDir : null;
        this.currentDir = directory;
        String path = this.currentDir.toAbsolutePath().toString();
        this.maxPathLength = 6.5f;
        while ((float)path.length() * this.maxPathLength > this.scrollPaneWidth * 0.9f) {
            path = TextUtils.capString(path, path.length() - 4, true);
        }
        this.location.setText(path);
        Array items = new Array();
        try (DirectoryStream<Path> list = Files.newDirectoryStream(directory, this.filter);){
            for (Path p : list) {
                if (!this.showHidden && p.getFileName().toString().startsWith(".") || (this.pathnameFilter == null || !this.pathnameFilter.accept(p)) && (!Files.isDirectory(p, new LinkOption[0]) || !this.directoryBrowsingEnabled)) continue;
                FileListItem fli = new FileListItem(p);
                items.add((Object)fli);
            }
        }
        items.sort(dirListComparator);
        if (directory.getParent() != null) {
            items.insert(0, (Object)new FileListItem("..", directory.getParent()));
        }
        if (this.target != FileChooserTarget.DIRECTORIES) {
            this.acceptButton.setDisabled(true);
        }
        this.fileList.setItems(items);
        this.scrollPane.layout();
        if (lastDir != null && lastDir.getParent() != null && lastDir.getParent().equals(this.currentDir)) {
            Array l = this.fileList.getItems();
            for (FileListItem fli : l) {
                if (!fli.file.equals(lastDir)) continue;
                this.fileList.setSelected((Object)fli);
                this.acceptButton.setDisabled(!this.isTargetOk(fli.file));
                break;
            }
            float px = this.fileList.getItemHeight() * (float)this.fileList.getSelectedIndex();
            this.scrollPane.setScrollY(px);
        } else {
            this.fileList.setSelected(null);
            this.scrollPane.setScrollY(0.0f);
        }
    }

    private boolean isTargetOk(Path file) {
        return switch (this.target.ordinal()) {
            case 0 -> Files.isRegularFile(file, new LinkOption[0]);
            case 1 -> Files.isDirectory(file, new LinkOption[0]);
            default -> true;
        };
    }

    private void setTargetListener() {
        this.setSelectionListener(event1 -> {
            if (event1 instanceof ChangeListener.ChangeEvent) {
                ArraySelection as;
                List list = (List)event1.getListenerActor();
                if (list != null && (as = list.getSelection()) != null && as.notEmpty()) {
                    FileListItem selected = (FileListItem)as.getLastSelected();
                    this.acceptButton.setDisabled(!this.isTargetOk(selected.file));
                }
                return true;
            }
            return false;
        });
    }

    public void setShowHidden(boolean showHidden) {
        this.hidden.setChecked(showHidden);
    }

    public void setShowHiddenConsumer(Consumer<Boolean> r) {
        this.hiddenConsumer = r;
    }

    public void setAcceptedFiles(String accepted) {
        this.acceptedFiles.setText((CharSequence)I18n.msg("gui.fc.accepted", accepted));
    }

    public Path getResult() {
        String path = String.valueOf(this.currentDir.toAbsolutePath()) + "/";
        if (this.result != null && !this.result.isEmpty()) {
            String folder;
            Path fileName = this.currentDir.getFileName();
            String string = folder = fileName != null ? fileName.toString() : "";
            if (folder.equals(this.result)) {
                if (Files.exists(Paths.get(path, this.result), new LinkOption[0])) {
                    path = path + this.result;
                }
            } else {
                path = path + this.result;
            }
        }
        return Paths.get(path, new String[0]);
    }

    public FileChooser setFilter(DirectoryStream.Filter<Path> filter) {
        this.filter = filter;
        return this;
    }

    public FileChooser setFileFilter(PathnameFilter f) {
        this.pathnameFilter = f;
        try {
            this.changeDirectory(this.currentDir);
        }
        catch (IOException e) {
            logger.error(e);
        }
        return this;
    }

    private void setSelectionListener(EventListener listener) {
        if (listener != null) {
            if (this.selectionListener != null) {
                this.fileList.removeListener(this.selectionListener);
            }
            this.selectionListener = listener;
            if (!this.fileList.getListeners().contains((Object)this.selectionListener, true)) {
                this.fileList.addListener(this.selectionListener);
            }
        }
    }

    public FileChooser setFileNameEnabled(boolean fileNameEnabled) {
        this.fileNameEnabled = fileNameEnabled;
        return this;
    }

    public void setResultListener(ResultListener result) {
        this.resultListener = result;
    }

    @Override
    public boolean accept() {
        if (this.resultListener != null) {
            this.resultListener.result(true, this.getResult());
        }
        return true;
    }

    @Override
    public void cancel() {
        if (this.resultListener != null) {
            this.resultListener.result(false, this.getResult());
        }
    }

    @Override
    public void dispose() {
    }

    public static enum FileChooserTarget {
        FILES,
        DIRECTORIES,
        ALL;

    }

    public static interface PathnameFilter {
        public boolean accept(Path var1);
    }

    public static class FileListItem {
        public Path file;
        public String name;

        public FileListItem(Path file) {
            this.file = file;
            this.name = file.getFileName().toString();
        }

        public FileListItem(String name, Path file) {
            this.file = file;
            this.name = name;
        }

        public String toString() {
            return " " + this.name;
        }
    }

    public static interface ResultListener {
        public boolean result(boolean var1, Path var2);
    }

    private static class NewDirectoryDialog
    extends GenericDialog {
        public OwnTextField name;

        public NewDirectoryDialog(Skin skin, Stage ui) {
            super(I18n.msg("gui.fc.newdirectory.title"), skin, ui);
            this.setAcceptText(I18n.msg("gui.ok"));
            this.setCancelText(I18n.msg("gui.cancel"));
            this.buildSuper();
        }

        @Override
        protected void build() {
            this.content.clear();
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.fc.newdirectory.name"), this.skin)).left().padRight(pad18);
            this.name = new OwnTextField("", this.skin);
            this.name.setWidth(350.0f);
            this.name.setMessageText(I18n.msg("gui.fc.newdirectory"));
            this.name.setValidator(new DirectoryNameValidator());
            this.content.add((Actor)this.name).left();
        }

        public String getNewDirectoryName() {
            if (this.name != null && !this.name.getText().isEmpty()) {
                return this.name.getText();
            }
            return I18n.msg("gui.fc.newdirectory");
        }

        @Override
        public void setKeyboardFocus() {
            this.stage.setKeyboardFocus((Actor)this.name);
        }

        @Override
        protected boolean accept() {
            return true;
        }

        @Override
        protected void cancel() {
        }

        @Override
        public void dispose() {
        }
    }
}

