/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class Link
extends Label {
    private String linkURL;

    public Link(CharSequence text, Label.LabelStyle style, String linkURL) {
        super(text, style);
        this.linkURL = linkURL;
        this.initialize();
    }

    public Link(CharSequence text, Skin skin, String fontName, Color color, String linkto) {
        super(text, skin, fontName, color);
        this.linkURL = linkto;
        this.initialize();
    }

    public Link(CharSequence text, Skin skin, String fontName, String colorName, String linkto) {
        super(text, skin, fontName, colorName);
        this.linkURL = linkto;
        this.initialize();
    }

    public Link(CharSequence text, Skin skin, String styleName, String linkto) {
        super(text, skin, styleName);
        this.linkURL = linkto;
        this.initialize();
    }

    public Link(CharSequence text, Skin skin, String linkTo) {
        super(text, skin, "link");
        this.linkURL = linkTo;
        this.initialize();
    }

    private void initialize() {
        this.addListener((EventListener)new ClickListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return super.touchDown(event, x, y, pointer, button);
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 0 && Link.this.linkURL != null && !Link.this.linkURL.isEmpty()) {
                    Gdx.net.openURI(Link.this.linkURL);
                }
                super.touchUp(event, x, y, pointer, button);
            }
        });
        this.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.enter) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
                return true;
            }
            return false;
        });
    }

    public String getLinkURL() {
        return this.linkURL;
    }

    public void setLinkURL(String linkURL) {
        this.linkURL = linkURL;
    }
}

