/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnTextTooltip;

public class LinkButton
extends OwnImageButton {
    private final String linkURL;

    public LinkButton(String linkURL, Skin skin) {
        super(skin, "link");
        this.linkURL = linkURL;
        this.initialize(skin);
    }

    private void initialize(Skin skin) {
        this.addListener((EventListener)new ClickListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return super.touchDown(event, x, y, pointer, button);
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (event.getButton() == 0 && LinkButton.this.linkURL != null && !LinkButton.this.linkURL.isEmpty()) {
                    Gdx.net.openURI(LinkButton.this.linkURL);
                }
                super.touchUp(event, x, y, pointer, button);
            }
        });
        this.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.touchUp && ((InputEvent)event).getButton() == 0) {
                    Gdx.net.openURI(this.linkURL);
                } else if (type == InputEvent.Type.enter) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
                return true;
            }
            return false;
        });
        this.addListener((EventListener)new OwnTextTooltip(this.linkURL, skin, 10));
    }
}

