/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.Scaling;
import gaiasky.gui.main.GSKeys;
import gaiasky.util.scene2d.ContextMenu;
import gaiasky.util.scene2d.OsUtils;

public class MenuItem
extends Button {
    private static final Vector2 tmpVector = new Vector2();
    ContextMenu containerMenu;
    private MenuItemStyle style;
    private Image image;
    private boolean generateDisabledImage = true;
    private Label label;
    private Color shortcutLabelColor;
    private Label shortcutLabel;
    private Image subMenuImage;
    private Cell<Image> subMenuIconCell;
    private ContextMenu subMenu;

    public MenuItem(String text, Skin skin) {
        this(text, skin, (Image)null, (MenuItemStyle)((Object)skin.get(MenuItemStyle.class)));
    }

    public MenuItem(String text, Skin skin, String styleName) {
        this(text, skin, (Image)null, (MenuItemStyle)((Object)skin.get(styleName, MenuItemStyle.class)));
    }

    public MenuItem(String text, Skin skin, ChangeListener changeListener) {
        this(text, skin, (Image)null, (MenuItemStyle)((Object)skin.get(MenuItemStyle.class)));
        this.addListener((EventListener)changeListener);
    }

    public MenuItem(String text, Skin skin, Drawable drawable) {
        this(text, skin, drawable, (MenuItemStyle)((Object)skin.get(MenuItemStyle.class)));
    }

    public MenuItem(String text, Skin skin, Drawable drawable, ChangeListener changeListener) {
        this(text, skin, drawable, (MenuItemStyle)((Object)skin.get(MenuItemStyle.class)));
        this.addListener((EventListener)changeListener);
    }

    public MenuItem(String text, Skin skin, Drawable drawable, String styleName) {
        this(text, skin, drawable, (MenuItemStyle)((Object)skin.get(styleName, MenuItemStyle.class)));
    }

    public MenuItem(String text, Skin skin, Image image) {
        this(text, skin, image, (MenuItemStyle)((Object)skin.get(MenuItemStyle.class)));
    }

    public MenuItem(String text, Skin skin, Image image, ChangeListener changeListener) {
        this(text, skin, image, (MenuItemStyle)((Object)skin.get(MenuItemStyle.class)));
        this.addListener((EventListener)changeListener);
    }

    public MenuItem(String text, Skin skin, Image image, String styleName) {
        this(text, skin, image, (MenuItemStyle)((Object)skin.get(styleName, MenuItemStyle.class)));
    }

    public MenuItem(String text, Skin skin, Image image, MenuItemStyle style) {
        super((Button.ButtonStyle)style);
        this.init(text, skin, image, style);
    }

    public MenuItem(String text, Skin skin, Drawable drawable, MenuItemStyle style) {
        super((Button.ButtonStyle)style);
        this.init(text, skin, new Image(drawable), style);
    }

    private void init(String text, Skin skin, Image image, MenuItemStyle style) {
        this.style = style;
        this.image = image;
        this.setSkin(skin);
        this.defaults().space(3.0f);
        if (image != null) {
            image.setScaling(Scaling.fit);
        }
        this.add((Actor)image).size(22.0f).padRight(5.0f);
        this.label = new Label((CharSequence)text, new Label.LabelStyle(style.font, style.fontColor));
        this.label.setAlignment(8);
        this.add((Actor)this.label).expand().fill();
        this.shortcutLabel = new Label((CharSequence)"", skin, "menuitem-shortcut");
        this.add((Actor)this.shortcutLabel).padLeft(10.0f).right();
        this.shortcutLabelColor = this.shortcutLabel.getStyle().fontColor;
        this.subMenuImage = new Image(style.subMenu);
        this.subMenuIconCell = this.add((Actor)this.subMenuImage).padLeft(3.0f).padRight(3.0f).size(style.subMenu.getMinWidth(), style.subMenu.getMinHeight());
        this.subMenuIconCell.setActor(null);
        this.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (MenuItem.this.subMenu != null) {
                    event.stop();
                }
            }
        });
        this.addListener((EventListener)new InputListener(){

            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (MenuItem.this.subMenu != null) {
                    MenuItem.this.subMenu.setActiveItem(null, false);
                    MenuItem.this.subMenu.setActiveSubMenu(null);
                }
                if (MenuItem.this.subMenu == null || MenuItem.this.isDisabled()) {
                    MenuItem.this.hideSubMenu();
                } else {
                    MenuItem.this.showSubMenu();
                }
            }
        });
    }

    public ContextMenu getSubMenu() {
        return this.subMenu;
    }

    public void setSubMenu(ContextMenu subMenu) {
        this.subMenu = subMenu;
        if (subMenu == null) {
            this.subMenuIconCell.setActor(null);
        } else {
            this.subMenuIconCell.setActor((Actor)this.subMenuImage);
        }
    }

    void packContainerMenu() {
        if (this.containerMenu != null) {
            this.containerMenu.pack();
        }
    }

    protected void setParent(Group parent) {
        super.setParent(parent);
        this.containerMenu = parent instanceof ContextMenu ? (ContextMenu)parent : null;
    }

    void hideSubMenu() {
        if (this.containerMenu != null) {
            this.containerMenu.setActiveSubMenu(null);
        }
    }

    void showSubMenu() {
        Stage stage = this.getStage();
        Vector2 pos = this.localToStageCoordinates(tmpVector.setZero());
        float availableSpaceLeft = pos.x;
        float availableSpaceRight = stage.getWidth() - (pos.x + this.getWidth());
        boolean canFitOnTheRight = pos.x + this.getWidth() + this.subMenu.getWidth() <= stage.getWidth();
        float subMenuX = canFitOnTheRight || availableSpaceRight > availableSpaceLeft ? pos.x + this.getWidth() - 1.0f : pos.x - this.subMenu.getWidth() + 1.0f;
        this.subMenu.setPosition(subMenuX, pos.y - this.subMenu.getHeight() + this.getHeight());
        if (this.subMenu.getY() < 0.0f) {
            this.subMenu.setY(this.subMenu.getY() + this.subMenu.getHeight() - this.getHeight());
        }
        stage.addActor((Actor)this.subMenu);
        this.containerMenu.setActiveSubMenu(this.subMenu);
    }

    void fireChangeEvent() {
        ChangeListener.ChangeEvent changeEvent = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent::new);
        this.fire((Event)changeEvent);
        Pools.free((Object)changeEvent);
    }

    public MenuItemStyle getStyle() {
        return this.style;
    }

    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof MenuItemStyle)) {
            throw new IllegalArgumentException("style must be a MenuItemStyle.");
        }
        super.setStyle(style);
        this.style = (MenuItemStyle)style;
        if (this.label != null) {
            TextButton.TextButtonStyle textButtonStyle = (TextButton.TextButtonStyle)style;
            Label.LabelStyle labelStyle = this.label.getStyle();
            labelStyle.font = textButtonStyle.font;
            labelStyle.fontColor = textButtonStyle.fontColor;
            this.label.setStyle(labelStyle);
        }
    }

    public void draw(Batch batch, float parentAlpha) {
        Color fontColor = this.isDisabled() && this.style.disabledFontColor != null ? this.style.disabledFontColor : (this.isPressed() && this.style.downFontColor != null ? this.style.downFontColor : (this.isChecked() && this.style.checkedFontColor != null ? (this.isOver() && this.style.checkedOverFontColor != null ? this.style.checkedOverFontColor : this.style.checkedFontColor) : (this.isOver() && this.style.overFontColor != null ? this.style.overFontColor : this.style.fontColor)));
        if (fontColor != null) {
            this.label.getStyle().fontColor = fontColor;
        }
        this.shortcutLabel.getStyle().fontColor = this.isDisabled() ? this.style.disabledFontColor : this.shortcutLabelColor;
        if (this.image != null && this.generateDisabledImage) {
            if (this.isDisabled()) {
                this.image.setColor(Color.GRAY);
            } else {
                this.image.setColor(Color.WHITE);
            }
        }
        super.draw(batch, parentAlpha);
    }

    public boolean isOver() {
        if (this.containerMenu == null || this.containerMenu.getActiveItem() == null) {
            return super.isOver();
        }
        return this.containerMenu.getActiveItem() == this;
    }

    public boolean isGenerateDisabledImage() {
        return this.generateDisabledImage;
    }

    public void setGenerateDisabledImage(boolean generateDisabledImage) {
        this.generateDisabledImage = generateDisabledImage;
    }

    public CharSequence getShortcut() {
        return this.shortcutLabel.getText();
    }

    public MenuItem setShortcut(int keycode) {
        return this.setShortcut(GSKeys.toString(keycode));
    }

    public MenuItem setShortcut(String text) {
        this.shortcutLabel.setText((CharSequence)text);
        this.packContainerMenu();
        return this;
    }

    public MenuItem setShortcut(int ... keycodes) {
        this.shortcutLabel.setText((CharSequence)OsUtils.getShortcutFor(keycodes));
        this.packContainerMenu();
        return this;
    }

    protected void setStage(Stage stage) {
        super.setStage(stage);
        this.label.invalidate();
    }

    public Image getImage() {
        return this.image;
    }

    public Cell<?> getImageCell() {
        return this.getCell((Actor)this.image);
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell<?> getLabelCell() {
        return this.getCell((Actor)this.label);
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    public void setText(CharSequence text) {
        this.label.setText(text);
    }

    public Cell<Image> getSubMenuIconCell() {
        return this.subMenuIconCell;
    }

    public Cell<Label> getShortcutCell() {
        return this.getCell((Actor)this.shortcutLabel);
    }

    public static class MenuItemStyle
    extends TextButton.TextButtonStyle {
        public Drawable subMenu;

        public MenuItemStyle() {
        }

        public MenuItemStyle(Drawable subMenu) {
            this.subMenu = subMenu;
        }

        public MenuItemStyle(MenuItemStyle style) {
            super((TextButton.TextButtonStyle)style);
            this.subMenu = style.subMenu;
        }
    }
}

