/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;

public class OwnButton
extends Button {
    OwnButton me = this;
    Cursor.SystemCursor cursor;
    private boolean changeCursor = true;

    public OwnButton(Skin skin) {
        super(skin);
        this.initialize();
    }

    public OwnButton(Skin skin, String styleName) {
        super(skin, styleName);
        this.initialize();
    }

    public OwnButton(Skin skin, String styleName, boolean changeCursor) {
        super(skin, styleName);
        this.changeCursor = changeCursor;
        this.initialize();
    }

    public OwnButton(Actor child, Skin skin, String styleName, boolean changeCursor) {
        super(child, skin, styleName);
        this.changeCursor = changeCursor;
        this.initialize();
    }

    public void setCheckedNoFire(boolean isChecked) {
        this.setProgrammaticChangeEvents(false);
        this.setChecked(isChecked);
        this.setProgrammaticChangeEvents(true);
    }

    private void initialize() {
        this.cursor = Cursor.SystemCursor.Hand;
        this.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (this.changeCursor && type == InputEvent.Type.enter) {
                    if (!this.me.isDisabled()) {
                        Gdx.graphics.setSystemCursor(this.cursor);
                    }
                    return true;
                }
                if (this.changeCursor && type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                    return true;
                }
                if (type == InputEvent.Type.touchDown) {
                    this.getStage().setKeyboardFocus((Actor)this);
                }
            }
            return false;
        });
    }
}

