/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.SnapshotArray;

public class OwnCheckBox
extends CheckBox {
    private final Color regularColor = this.getLabel().getColor().cpy();
    private float ownWidth = 0.0f;
    private float ownHeight = 0.0f;

    public OwnCheckBox(String text, Skin skin) {
        super(text, skin);
        this.getCells().get(0);
    }

    public OwnCheckBox(String text, Skin skin, float space) {
        super(text, skin);
        ((Cell)this.getCells().get(0)).padRight(space);
    }

    public OwnCheckBox(String text, Skin skin, String styleName, float space) {
        super(text, skin, styleName);
        ((Cell)this.getCells().get(0)).padRight(space);
    }

    public void setDisabled(boolean isDisabled) {
        super.setDisabled(isDisabled);
        if (isDisabled) {
            this.getLabel().setColor(Color.GRAY);
        } else {
            this.getLabel().setColor(this.regularColor);
        }
    }

    public void setWidth(float width) {
        this.ownWidth = width;
        super.setWidth(width);
    }

    public void setMinWidth(float width) {
        this.setWidth(Math.max(width, this.getWidth()));
    }

    public void setHeight(float height) {
        this.ownHeight = height;
        super.setHeight(height);
    }

    public void setMinHeight(float height) {
        this.setHeight(Math.max(height, this.getHeight()));
    }

    public void setSize(float width, float height) {
        this.ownWidth = width;
        this.ownHeight = height;
        super.setSize(width, height);
    }

    public float getPrefWidth() {
        if (this.ownWidth != 0.0f) {
            return this.ownWidth;
        }
        return super.getPrefWidth();
    }

    public float getPrefHeight() {
        if (this.ownHeight != 0.0f) {
            return this.ownHeight;
        }
        return super.getPrefHeight();
    }

    public void draw(Batch batch, float parentAlpha) {
        Stage stage;
        Drawable checkbox = null;
        if (this.isDisabled()) {
            checkbox = this.isChecked() && this.getStyle().checkboxOnDisabled != null ? this.getStyle().checkboxOnDisabled : this.getStyle().checkboxOffDisabled;
        }
        if (checkbox == null) {
            boolean focused;
            boolean over = this.isOver() && !this.isDisabled();
            boolean bl = focused = this.hasKeyboardFocus() && !this.isDisabled();
            checkbox = this.isChecked() && this.getStyle().checkboxOn != null ? (focused && this.getStyle().checkedFocused != null ? this.getStyle().checkedFocused : (over && this.getStyle().checkboxOnOver != null ? this.getStyle().checkboxOnOver : this.getStyle().checkboxOn)) : (over && this.getStyle().checkboxOver != null ? this.getStyle().checkboxOver : (focused && this.getStyle().focused != null ? this.getStyle().focused : this.getStyle().checkboxOff));
        }
        this.getImage().setDrawable(checkbox);
        this.getLabel().getStyle().fontColor = this.getFontColor();
        this.validate();
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (this.isPressed() && !this.isDisabled()) {
            offsetX = this.getStyle().pressedOffsetX;
            offsetY = this.getStyle().pressedOffsetY;
        } else if (this.isChecked() && !this.isDisabled()) {
            offsetX = this.getStyle().checkedOffsetX;
            offsetY = this.getStyle().checkedOffsetY;
        } else {
            offsetX = this.getStyle().unpressedOffsetX;
            offsetY = this.getStyle().unpressedOffsetY;
        }
        boolean offset = offsetX != 0.0f || offsetY != 0.0f;
        SnapshotArray children = this.getChildren();
        if (offset) {
            for (int i = 0; i < children.size; ++i) {
                ((Actor)children.get(i)).moveBy(offsetX, offsetY);
            }
        }
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            if (this.getClip()) {
                batch.flush();
                float padLeft = this.getPadLeftValue().get((Actor)this);
                float padBottom = this.getPadBottomValue().get((Actor)this);
                if (this.clipBegin(padLeft, padBottom, this.getWidth() - padLeft - this.getPadBottomValue().get((Actor)this), this.getHeight() - padBottom - this.getPadTopValue().get((Actor)this))) {
                    this.drawChildren(batch, parentAlpha);
                    batch.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, parentAlpha);
            }
            this.resetTransform(batch);
        } else {
            this.validate();
            if (this.isTransform()) {
                this.applyTransform(batch, this.computeTransform());
            }
            this.drawChildren(batch, parentAlpha);
            if (this.isTransform()) {
                this.resetTransform(batch);
            }
        }
        if (offset) {
            for (int i = 0; i < children.size; ++i) {
                ((Actor)children.get(i)).moveBy(-offsetX, -offsetY);
            }
        }
        if ((stage = this.getStage()) != null && stage.getActionsRequestRendering() && this.isPressed() != this.getClickListener().isPressed()) {
            Gdx.graphics.requestRendering();
        }
    }
}

