/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;

public class OwnImageButton
extends ImageButton {
    OwnImageButton me = this;
    Cursor.SystemCursor cursor;
    private float ownWidth = 0.0f;
    private float ownHeight = 0.0f;

    public OwnImageButton(Skin skin) {
        super(skin);
        this.initialize();
    }

    public OwnImageButton(Skin skin, String styleName) {
        super(skin, styleName);
        this.initialize();
    }

    public OwnImageButton(ImageButton.ImageButtonStyle style) {
        super(style);
        this.initialize();
    }

    public void setCheckedNoFire(boolean isChecked) {
        this.setProgrammaticChangeEvents(false);
        this.setChecked(isChecked);
        this.setProgrammaticChangeEvents(true);
    }

    private void initialize() {
        this.cursor = Cursor.SystemCursor.Hand;
        this.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.enter) {
                    if (!this.me.isDisabled()) {
                        Gdx.graphics.setSystemCursor(this.cursor);
                    }
                    return true;
                }
                if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                    return true;
                }
            }
            return false;
        });
    }

    protected void updateImage() {
        Color theme;
        this.getImage().setDrawable(this.getImageDrawable());
        try {
            theme = this.getSkin().getColor("highlight");
        }
        catch (Exception e) {
            theme = null;
        }
        if (this.isOver()) {
            if (theme != null) {
                this.getImage().setColor(theme);
            } else {
                this.getImage().setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.getImage().setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void draw(Batch batch, float parentAlpha) {
        this.updateImage();
        super.draw(batch, parentAlpha);
    }

    public void setSize(float width, float height) {
        this.ownWidth = width;
        this.ownHeight = height;
        super.setSize(width, height);
    }

    public float getPrefWidth() {
        if (this.ownWidth != 0.0f) {
            return this.ownWidth;
        }
        return super.getPrefWidth();
    }

    public float getPrefHeight() {
        if (this.ownHeight != 0.0f) {
            return this.ownHeight;
        }
        return super.getPrefHeight();
    }
}

