/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import gaiasky.util.TextUtils;

public class OwnLabel
extends Label
implements Disableable {
    private final Color regularColor = this.getColor().cpy();
    private float ownPrefWidth = 0.0f;
    private float ownPrefHeight = 0.0f;
    private boolean disabled = false;

    public OwnLabel(CharSequence text, Skin skin, float width) {
        super(text, skin);
        this.setWidth(width);
    }

    public OwnLabel(CharSequence text, Skin skin, String styleName, int breakCharacters) {
        super((CharSequence)TextUtils.breakCharacters(text, breakCharacters), skin, styleName);
    }

    public OwnLabel(CharSequence text, Skin skin) {
        super(text, skin);
    }

    public OwnLabel(CharSequence text, Label.LabelStyle style) {
        super(text, style);
    }

    public OwnLabel(CharSequence text, Skin skin, String fontName, Color color) {
        super(text, skin, fontName, color);
    }

    public OwnLabel(CharSequence text, Skin skin, String fontName, String colorName) {
        super(text, skin, fontName, colorName);
    }

    public OwnLabel(CharSequence text, Skin skin, String styleName) {
        super(text, skin, styleName);
    }

    public void receiveScrollEvents() {
        this.addListener(e -> {
            if (e instanceof InputEvent) {
                InputEvent ie = (InputEvent)e;
                e.setBubbles(false);
                if (ie.getType() == InputEvent.Type.enter && this.getStage() != null) {
                    return this.getStage().setScrollFocus((Actor)this);
                }
                if (ie.getType() == InputEvent.Type.exit && this.getStage() != null) {
                    return this.getStage().setScrollFocus(null);
                }
            }
            return true;
        });
    }

    public void setWidth(float width) {
        this.ownPrefWidth = width;
        super.setWidth(width);
    }

    public void setHeight(float height) {
        this.ownPrefHeight = height;
        super.setHeight(height);
    }

    public void setSize(float width, float height) {
        this.ownPrefWidth = width;
        this.ownPrefHeight = height;
        super.setSize(width, height);
    }

    public float getPrefWidth() {
        if (this.ownPrefWidth != 0.0f) {
            return this.ownPrefWidth;
        }
        return super.getPrefWidth();
    }

    public float getPrefHeight() {
        if (this.ownPrefHeight != 0.0f) {
            return this.ownPrefHeight;
        }
        return super.getPrefHeight();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean isDisabled) {
        if (isDisabled) {
            this.disabled = true;
            this.setColor(Color.GRAY);
        } else {
            this.disabled = false;
            this.setColor(this.regularColor);
        }
    }
}

