/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.util.scene2d.OwnLabel;

public class OwnProgressBar
extends ProgressBar {
    private final boolean vertical;
    private float prefWidth = 0.0f;
    private float prefHeight = 0.0f;
    private OwnLabel titleLabel;

    public OwnProgressBar(float min, float max, float stepSize, boolean vertical, ProgressBar.ProgressBarStyle style) {
        super(min, max, stepSize, vertical, style);
        this.vertical = vertical;
    }

    public OwnProgressBar(float min, float max, float stepSize, boolean vertical, Skin skin, String styleName) {
        super(min, max, stepSize, vertical, skin, styleName);
        this.vertical = vertical;
    }

    public OwnProgressBar(float min, float max, float stepSize, boolean vertical, Skin skin) {
        super(min, max, stepSize, vertical, skin);
        this.vertical = vertical;
    }

    public void setTitle(String title, Skin skin) {
        this.titleLabel = new OwnLabel((CharSequence)title, skin, "small");
    }

    public float getPrefWidth() {
        if (!this.vertical && this.prefWidth > 0.0f) {
            return this.prefWidth;
        }
        return super.getPrefWidth();
    }

    public void setPrefWidth(float prefWidth) {
        this.prefWidth = prefWidth;
    }

    public float getPrefHeight() {
        if (this.vertical && this.prefHeight > 0.0f) {
            return this.prefHeight;
        }
        return super.getPrefHeight();
    }

    public void setPrefHeight(float prefHeight) {
        this.prefHeight = prefHeight;
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.titleLabel != null) {
            float padY = 2.0f;
            float padX = 10.8f;
            this.titleLabel.setPosition(this.getX() + padX, this.getY() + this.getHeight() - this.titleLabel.getHeight() - padY);
            this.titleLabel.draw(batch, parentAlpha);
        }
    }
}

