/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ActorGestureListener;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import net.jafama.FastMath;

public class OwnScrollPane
extends ScrollPane {
    private float ownWidth = 0.0f;
    private float ownHeight = 0.0f;
    private boolean expand = false;
    private boolean bubbles = true;

    public OwnScrollPane(Actor widget, Skin skin) {
        this(widget, (ScrollPane.ScrollPaneStyle)skin.get(ScrollPane.ScrollPaneStyle.class));
    }

    public OwnScrollPane(Actor widget, Skin skin, String styleName) {
        this(widget, (ScrollPane.ScrollPaneStyle)skin.get(styleName, ScrollPane.ScrollPaneStyle.class));
    }

    public OwnScrollPane(Actor widget, ScrollPane.ScrollPaneStyle style) {
        super(widget, style);
        for (EventListener cl : this.getListeners()) {
            if (!(cl instanceof ActorGestureListener)) continue;
            this.removeListener(cl);
        }
        this.setFocusModeListener();
    }

    private void setFocusModeListener() {
        this.addListener(e -> {
            if (e instanceof InputEvent) {
                InputEvent ie = (InputEvent)e;
                e.setBubbles(this.bubbles);
                if (ie.getType() == InputEvent.Type.enter && this.getStage() != null) {
                    return this.getStage().setScrollFocus((Actor)this);
                }
            }
            return false;
        });
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    public void setWidth(float width) {
        this.ownWidth = width;
        super.setWidth(width);
    }

    public void setHeight(float height) {
        this.ownHeight = height;
        super.setHeight(height);
    }

    public void setSize(float width, float height) {
        this.ownWidth = width;
        this.ownHeight = height;
        super.setSize(width, height);
    }

    public float getPrefWidth() {
        if (this.ownWidth != 0.0f) {
            if (this.expand && this.getActor() instanceof Layout) {
                return FastMath.max((float)this.ownWidth, (float)super.getPrefWidth());
            }
            return this.ownWidth;
        }
        return super.getPrefWidth();
    }

    public void layout() {
        super.layout();
        this.bubbles = !this.isScrollX() && !this.isScrollY();
    }

    public float getPrefHeight() {
        if (this.ownHeight != 0.0f) {
            if (this.expand && this.getActor() instanceof Layout) {
                return FastMath.max((float)this.ownHeight, (float)super.getPrefHeight());
            }
            return this.ownHeight;
        }
        return super.getPrefHeight();
    }
}

