/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pools;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.scene2d.OwnLabel;
import java.text.DecimalFormat;

public class OwnSlider
extends Slider {
    private float ownWidth = 0.0f;
    private float ownHeight = 0.0f;
    private float mapMin;
    private float mapMax;
    private boolean map = false;
    private Skin skin;
    private boolean displayValueMapped = false;
    private boolean showValueLabel = true;
    private OwnLabel valueLabel;
    private String valuePrefix;
    private String valueSuffix;
    private float padX = 4.8f;
    private float padY = 4.8f;
    private DecimalFormat nf;
    private EventListener labelListener;
    private boolean programmaticChangeEvents = true;

    public OwnSlider(float min, float max, float stepSize, float mapMin, float mapMax, boolean vertical, Skin skin) {
        super(min, max, stepSize, vertical, (Slider.SliderStyle)skin.get("default-" + (vertical ? "vertical" : "horizontal"), OwnSliderStyle.class));
        if (vertical) {
            this.padX = -8.0f;
        } else {
            this.padY = -1.0f;
        }
        this.skin = skin;
        this.setUp(mapMin, mapMax);
    }

    public OwnSlider(float min, float max, float stepSize, float mapMin, float mapMax, Skin skin) {
        this(min, max, stepSize, mapMin, mapMax, false, skin);
    }

    public OwnSlider(float min, float max, float stepSize, Skin skin) {
        this(min, max, stepSize, min, max, false, skin);
    }

    public OwnSlider(float min, float max, float stepSize, boolean vertical, Skin skin) {
        this(min, max, stepSize, min, max, vertical, skin);
    }

    public OwnSlider(float min, float max, float stepSize, boolean vertical, Skin skin, String styleName) {
        super(min, max, stepSize, vertical, (Slider.SliderStyle)skin.get(styleName, OwnSliderStyle.class));
    }

    public void setValueFormatter(DecimalFormat df) {
        this.nf = df;
    }

    public void setUp(float mapMin, float mapMax) {
        this.setUp(mapMin, mapMax, new DecimalFormat("####0.0#"));
    }

    public void setUp(float mapMin, float mapMax, DecimalFormat nf) {
        this.nf = nf;
        this.setMapValues(mapMin, mapMax);
        this.valueLabel = new OwnLabel((CharSequence)this.getValueString(), this.skin);
        this.labelListener = event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.valueLabel.setText(this.getValueString());
                return true;
            }
            return false;
        };
        this.addListener(this.labelListener);
    }

    public void setMapValues(float mapMin, float mapMax) {
        this.mapMin = mapMin;
        this.mapMax = mapMax;
        this.map = true;
    }

    public void removeMapValues() {
        this.mapMin = 0.0f;
        this.mapMax = 0.0f;
        this.map = false;
    }

    public String getValueString() {
        return (this.valuePrefix != null ? this.valuePrefix : "") + this.nf.format(this.displayValueMapped ? this.getMappedValue() : this.getValue()) + (this.valueSuffix != null ? this.valueSuffix : "");
    }

    public float getMappedValue() {
        if (this.map) {
            return MathUtilsDouble.lint(this.getValue(), this.getMinValue(), this.getMaxValue(), this.mapMin, this.mapMax);
        }
        return this.getValue();
    }

    public void setMappedValue(double mappedValue) {
        this.setMappedValue((float)mappedValue);
    }

    public void setMappedValue(float mappedValue) {
        if (this.map) {
            this.setValue(MathUtilsDouble.lint(mappedValue, this.mapMin, this.mapMax, this.getMinValue(), this.getMaxValue()));
        } else {
            this.setValue(mappedValue);
        }
        if (!this.programmaticChangeEvents && this.labelListener != null) {
            ChangeListener.ChangeEvent changeEvent = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent::new);
            this.labelListener.handle((Event)changeEvent);
            Pools.free((Object)changeEvent);
        }
    }

    public void setDisplayValueMapped(boolean displayValueMapped) {
        this.displayValueMapped = displayValueMapped;
    }

    public void showValueLabel(boolean showValueLabel) {
        this.showValueLabel = showValueLabel;
    }

    public void setValuePrefix(String valuePrefix) {
        this.valuePrefix = valuePrefix;
    }

    public void setValueSuffix(String valueSuffix) {
        this.valueSuffix = valueSuffix;
    }

    public void setWidth(float width) {
        this.ownWidth = width;
        super.setWidth(width);
    }

    public void setHeight(float height) {
        this.ownHeight = height;
        super.setHeight(height);
    }

    public void setSize(float width, float height) {
        this.ownWidth = width;
        this.ownHeight = height;
        super.setSize(width, height);
    }

    public float getPrefWidth() {
        if (this.ownWidth != 0.0f) {
            return this.ownWidth;
        }
        return super.getPrefWidth();
    }

    public float getPrefHeight() {
        if (this.ownHeight != 0.0f) {
            return this.ownHeight;
        }
        return super.getPrefHeight();
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.valueLabel != null && this.showValueLabel) {
            if (this.isVertical()) {
                this.valueLabel.setPosition(this.getX() + this.padX, this.getY() + this.getPrefHeight() - (this.valueLabel.getPrefHeight() + this.padY));
            } else {
                this.valueLabel.setPosition(this.getX() + this.getPrefWidth() - (this.valueLabel.getPrefWidth() + this.padX), this.getY() + this.padY);
            }
            this.valueLabel.draw(batch, parentAlpha);
        }
    }

    @Null
    protected Drawable getBackgroundDrawable() {
        Drawable bg = super.getBackgroundDrawable();
        if (this.hasKeyboardFocus() && !this.isDisabled()) {
            bg = ((OwnSliderStyle)this.getStyle()).backgroundFocused;
        }
        return bg;
    }

    protected Drawable getKnobBeforeDrawable() {
        Drawable knobBefore = super.getKnobBeforeDrawable();
        if (this.hasKeyboardFocus() && !this.isDisabled()) {
            knobBefore = ((OwnSliderStyle)this.getStyle()).knobBeforeFocused;
        }
        return knobBefore;
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
        super.setProgrammaticChangeEvents(programmaticChangeEvents);
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (this.valueLabel != null) {
            this.valueLabel.setDisabled(disabled);
        }
    }

    public static class OwnSliderStyle
    extends Slider.SliderStyle {
        @Null
        public Drawable backgroundFocused;
        @Null
        public Drawable knobBeforeFocused;

        public OwnSliderStyle() {
        }

        public OwnSliderStyle(OwnSliderStyle style) {
            super((Slider.SliderStyle)style);
            this.backgroundFocused = style.backgroundFocused;
            this.knobBeforeFocused = style.knobBeforeFocused;
        }
    }
}

