/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Null;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSlider;
import java.text.DecimalFormat;
import java.util.function.Function;

public class OwnSliderPlus
extends Slider {
    private final Skin skin;
    private OwnSliderPlus me;
    private float ownWidth = 0.0f;
    private float ownHeight = 0.0f;
    private float mapMin;
    private float mapMax;
    private boolean map = false;
    private OwnLabel titleLabel;
    private OwnLabel valueLabel;
    private boolean displayValueMapped = false;
    private String valuePrefix;
    private String valueSuffix;
    private DecimalFormat nf;
    private Function<Float, String> valueLabelTransform;
    private Color labelColorBackup;

    public OwnSliderPlus(String title, float min, float max, float stepSize, float mapMin, float mapMax, Skin skin, String labelStyle) {
        super(min, max, stepSize, false, (Slider.SliderStyle)skin.get("default-horizontal", OwnSlider.OwnSliderStyle.class));
        this.skin = skin;
        this.setUp(title, mapMin, mapMax, labelStyle);
    }

    public OwnSliderPlus(String title, float min, float max, float stepSize, float mapMin, float mapMax, Skin skin) {
        this(title, min, max, stepSize, mapMin, mapMax, skin, "default");
    }

    public OwnSliderPlus(String title, float min, float max, float stepSize, Skin skin) {
        super(min, max, stepSize, false, (Slider.SliderStyle)skin.get("default-horizontal", OwnSlider.OwnSliderStyle.class));
        this.skin = skin;
        this.setUp(title, min, max, "default");
    }

    public OwnSliderPlus(String title, float min, float max, float stepSize, Skin skin, String style) {
        super(min, max, stepSize, false, (Slider.SliderStyle)skin.get(style, OwnSlider.OwnSliderStyle.class));
        this.skin = skin;
        this.setUp(title, min, max, "default");
    }

    public OwnSliderPlus(String title, float min, float max, float stepSize, boolean vertical, Skin skin) {
        super(min, max, stepSize, vertical, (Slider.SliderStyle)skin.get("default-horizontal", OwnSlider.OwnSliderStyle.class));
        this.skin = skin;
        this.setUp(title, min, max, "default");
    }

    public OwnSliderPlus(String title, float min, float max, float stepSize, boolean vertical, Skin skin, String labelStyleName) {
        super(min, max, stepSize, vertical, (Slider.SliderStyle)skin.get("default-horizontal", OwnSlider.OwnSliderStyle.class));
        this.skin = skin;
        this.setUp(title, min, max, labelStyleName);
    }

    public void setUp(String title, float mapMin, float mapMax, String labelStyleName) {
        this.setUp(title, mapMin, mapMax, new DecimalFormat("####0.###"), labelStyleName);
    }

    public void setUp(String title, float mapMin, float mapMax, DecimalFormat nf, String labelStyleName) {
        this.me = this;
        this.nf = nf;
        this.setMapValues(mapMin, mapMax);
        this.titleLabel = title != null && !title.isEmpty() ? new OwnLabel((CharSequence)title, this.skin, labelStyleName) : null;
        this.valueLabel = new OwnLabel((CharSequence)this.getValueString(), this.skin, labelStyleName);
        this.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.valueLabel.setText(this.getValueString());
                return true;
            }
            return false;
        });
        this.addListener((EventListener)new FocusListener(){

            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (actor == OwnSliderPlus.this.me) {
                    if (focused) {
                        OwnSliderPlus.this.me.setLabelColor(OwnSliderPlus.this.skin.getColor("yellow"));
                    } else {
                        OwnSliderPlus.this.me.restoreLabelColor();
                    }
                }
            }
        });
    }

    public void setValueLabelTransform(Function<Float, String> transform) {
        this.valueLabelTransform = transform;
    }

    public void setNumberFormatter(DecimalFormat nf) {
        this.nf = nf;
    }

    public void setDisplayValueMapped(boolean displayValueMapped) {
        this.displayValueMapped = displayValueMapped;
    }

    public void setMapValues(float mapMin, float mapMax) {
        this.mapMin = mapMin;
        this.mapMax = mapMax;
        this.map = mapMin != this.getMinValue() || mapMax != this.getMaxValue();
    }

    public void removeMapValues() {
        this.mapMin = 0.0f;
        this.mapMax = 0.0f;
        this.map = false;
    }

    public String getValueString() {
        float actualValue = this.displayValueMapped ? this.getMappedValue() : this.getValue();
        String valueString = this.valueLabelTransform != null ? this.valueLabelTransform.apply(Float.valueOf(actualValue)) : this.nf.format(actualValue);
        return (this.valuePrefix != null ? this.valuePrefix : "") + valueString + (this.valueSuffix != null ? this.valueSuffix : "");
    }

    public boolean setValue(float value) {
        boolean result = super.setValue(value);
        this.valueLabel.setText(this.getValueString());
        return result;
    }

    public float getMappedValue() {
        if (this.map) {
            return MathUtilsDouble.lint(this.getValue(), this.getMinValue(), this.getMaxValue(), this.mapMin, this.mapMax);
        }
        return this.getValue();
    }

    public void setMappedValue(double mappedValue) {
        this.setMappedValue((float)mappedValue);
    }

    public void setMappedValue(float mappedValue) {
        if (this.map) {
            this.setValue(MathUtilsDouble.lint(mappedValue, this.mapMin, this.mapMax, this.getMinValue(), this.getMaxValue()));
        } else {
            this.setValue(mappedValue);
        }
    }

    public void setValuePrefix(String valuePrefix) {
        this.valuePrefix = valuePrefix;
    }

    public void setValueSuffix(String valueSuffix) {
        this.valueSuffix = valueSuffix;
    }

    public void setWidth(float width) {
        this.ownWidth = width;
        super.setWidth(width);
    }

    public void setHeight(float height) {
        this.ownHeight = height;
        super.setHeight(height);
    }

    public void setSize(float width, float height) {
        this.ownWidth = width;
        this.ownHeight = height;
        super.setSize(width, height);
    }

    public float getPrefWidth() {
        if (this.ownWidth != 0.0f) {
            return this.ownWidth;
        }
        return super.getPrefWidth();
    }

    public float getPrefHeight() {
        if (this.ownHeight != 0.0f) {
            return this.ownHeight;
        }
        return super.getPrefHeight();
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        float padX = 4.8f;
        float padY = 3.2f;
        if (this.titleLabel != null) {
            this.titleLabel.setPosition(this.getX() + padX, this.getY() + this.getHeight() - this.titleLabel.getHeight() - padY);
            this.titleLabel.draw(batch, parentAlpha);
        }
        if (this.valueLabel != null) {
            this.valueLabel.setPosition(this.getX() + this.getPrefWidth() - (this.valueLabel.getPrefWidth() + padX * 2.0f), this.getY() + this.getHeight() - this.valueLabel.getHeight() - padY);
            this.valueLabel.draw(batch, parentAlpha);
        }
    }

    @Null
    protected Drawable getBackgroundDrawable() {
        Drawable bg = super.getBackgroundDrawable();
        if (this.hasKeyboardFocus() && !this.isDisabled()) {
            bg = ((OwnSlider.OwnSliderStyle)this.getStyle()).backgroundFocused;
        }
        return bg;
    }

    protected Drawable getKnobBeforeDrawable() {
        Drawable knobBefore = super.getKnobBeforeDrawable();
        if (this.hasKeyboardFocus() && !this.isDisabled()) {
            knobBefore = ((OwnSlider.OwnSliderStyle)this.getStyle()).knobBeforeFocused;
        }
        return knobBefore;
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (this.valueLabel != null) {
            this.valueLabel.setDisabled(disabled);
        }
        if (this.titleLabel != null) {
            this.titleLabel.setDisabled(disabled);
        }
    }

    public void setLabelColor(Color c) {
        this.setLabelColor(c.r, c.g, c.b, c.a);
    }

    public void setLabelColor(float r, float g, float b, float a) {
        if (this.titleLabel != null) {
            this.labelColorBackup = this.titleLabel.getColor().cpy();
            this.titleLabel.setColor(r, g, b, a);
            if (this.valueLabel != null) {
                this.valueLabel.setColor(r, g, b, a);
            }
        }
    }

    public void restoreLabelColor() {
        if (this.labelColorBackup != null && this.titleLabel != null) {
            this.titleLabel.setColor(this.labelColorBackup);
            if (this.valueLabel != null) {
                this.valueLabel.setColor(this.labelColorBackup);
            }
        }
    }
}

