/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.utils.DelayedRemovalArray;

public class OwnTextButton
extends TextButton {
    OwnTextButton me = this;
    private float ownWidth = 0.0f;
    private float ownHeight = 0.0f;

    public OwnTextButton(String text, Skin skin) {
        super(text, skin);
        this.initialize();
    }

    public OwnTextButton(String text, Skin skin, String styleName) {
        super(text, skin, styleName);
        this.initialize();
    }

    public OwnTextButton(String text, TextButton.TextButtonStyle style) {
        super(text, style);
        this.initialize();
    }

    private void initialize() {
        this.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.enter) {
                    if (!this.me.isDisabled()) {
                        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                    }
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
            }
            return false;
        });
    }

    public void setColor(Color color) {
        this.getLabel().setColor(color);
    }

    public void setWidth(float width) {
        this.ownWidth = width;
        super.setWidth(width);
    }

    public void setMinWidth(float width) {
        this.setWidth(Math.max(width, this.getWidth()));
    }

    public void setHeight(float height) {
        this.ownHeight = height;
        super.setHeight(height);
    }

    public void setMinHeight(float height) {
        this.setHeight(Math.max(height, this.getHeight()));
    }

    public void setSize(float width, float height) {
        this.ownWidth = width;
        this.ownHeight = height;
        super.setSize(width, height);
    }

    public float getPrefWidth() {
        if (this.ownWidth != 0.0f) {
            return this.ownWidth;
        }
        return super.getPrefWidth();
    }

    public float getPrefHeight() {
        if (this.ownHeight != 0.0f) {
            return this.ownHeight;
        }
        return super.getPrefHeight();
    }

    public void setCheckedNoFire(boolean isChecked) {
        this.setProgrammaticChangeEvents(false);
        this.setChecked(isChecked);
        this.setProgrammaticChangeEvents(true);
    }

    public void removeTooltipListeners() {
        DelayedRemovalArray listeners = this.getListeners();
        listeners.begin();
        int n = listeners.size;
        for (int i = 0; i < n; ++i) {
            if (!(listeners.get(i) instanceof Tooltip)) continue;
            listeners.removeValue((Object)((EventListener)listeners.get(i)), true);
        }
        listeners.end();
    }
}

