/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Null;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.validator.CallbackValidator;
import gaiasky.util.validator.DoubleValidator;
import gaiasky.util.validator.FloatValidator;
import gaiasky.util.validator.IValidator;
import gaiasky.util.validator.IntValidator;
import gaiasky.util.validator.LongValidator;

public class OwnTextField
extends TextField {
    private final Skin skin;
    private float ownWidth = 0.0f;
    private float ownHeight = 0.0f;
    private IValidator validator = null;
    private String lastCorrectText = "";
    private Color regularColor;
    private Color errorColor;
    private final boolean clearButtonFlag = true;
    private final String clearButtonDrawableUp = "clear";
    private final String clearButtonDrawableDown = "clear-down";
    private Drawable clearDrawable;
    private float clearX;
    private float clearY;
    private float clearW;
    private float clearH;
    private EventListener validatorListener;
    private EventListener validatorTooltipListener;

    public OwnTextField(@Null String text, Skin skin) {
        super(text, new TextField.TextFieldStyle((TextField.TextFieldStyle)skin.get(TextField.TextFieldStyle.class)));
        this.skin = skin;
        this.regularColor = this.getColor().cpy();
        this.initClearButton();
    }

    public OwnTextField(String text, Skin skin, IValidator validator) {
        this(text, skin);
        this.validator = validator;
        this.initValidator();
        this.initClearButton();
    }

    public OwnTextField(String text, Skin skin, String styleName) {
        super(text, new TextField.TextFieldStyle((TextField.TextFieldStyle)skin.get(styleName, TextField.TextFieldStyle.class)));
        this.skin = skin;
        this.regularColor = this.getColor().cpy();
        this.initClearButton();
    }

    public OwnTextField(String text, Skin skin, String styleName, IValidator validator) {
        this(text, skin, styleName);
        this.validator = validator;
        this.initValidator();
    }

    public void initClearButton() {
        this.clearDrawable = this.skin.getDrawable("clear");
        this.clearW = this.clearDrawable.getMinWidth();
        this.clearH = this.clearDrawable.getMinHeight();
        final OwnTextField me = this;
        this.addListener((EventListener)new ClickListener(this){
            final /* synthetic */ OwnTextField this$0;
            {
                this.this$0 = this$0;
            }

            public void clicked(InputEvent event, float x, float y) {
                if (!me.isDisabled() && x >= this.this$0.clearX && x <= this.this$0.clearX + this.this$0.clearW && y >= this.this$0.clearY && y <= this.this$0.clearY + this.this$0.clearH) {
                    boolean bak = me.getProgrammaticChangeEvents();
                    me.setProgrammaticChangeEvents(true);
                    me.setText("");
                    me.setProgrammaticChangeEvents(bak);
                }
            }

            public boolean mouseMoved(InputEvent event, float x, float y) {
                if (!me.isDisabled()) {
                    this.this$0.clearDrawable = x >= this.this$0.clearX && x <= this.this$0.clearX + this.this$0.clearW && y >= this.this$0.clearY && y <= this.this$0.clearY + this.this$0.clearH ? this.this$0.skin.getDrawable("clear-down") : this.this$0.skin.getDrawable("clear");
                }
                return super.mouseMoved(event, x, y);
            }
        });
    }

    public void setValidator(IValidator validator) {
        if (validator == null) {
            if (this.validatorListener != null) {
                this.removeListener(this.validatorListener);
                this.validatorListener = null;
            }
            if (this.validatorTooltipListener != null) {
                this.removeListener(this.validatorTooltipListener);
                this.validatorTooltipListener = null;
            }
        } else {
            this.validator = validator;
            this.initValidator();
        }
    }

    public void setErrorColor(Color errorColor) {
        this.errorColor = errorColor;
    }

    public boolean isValid() {
        return this.validator == null || this.validator.validate(this.getText());
    }

    public float getFloatValue(float defaultValue) {
        return (float)this.getDoubleValue(defaultValue);
    }

    public double getDoubleValue(double defaultValue) {
        try {
            return Parser.parseFloatException(this.getText());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long getIntValue(int defaultValue) {
        return (int)this.getLongValue(defaultValue);
    }

    public long getLongValue(long defaultValue) {
        try {
            return Parser.parseLongException(this.getText());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setToRegularColor() {
        this.setColor(this.regularColor);
        this.getStyle().fontColor = this.regularColor;
    }

    public void setToErrorColor() {
        this.setColor(this.errorColor);
        this.getStyle().fontColor = this.errorColor;
    }

    private void initValidator() {
        if (this.validator != null) {
            this.errorColor = ColorUtils.gRedC;
            this.regularColor = this.getColor().cpy();
            this.validatorListener = event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    String str = this.getText();
                    if (this.validator.validate(str)) {
                        this.setToRegularColor();
                        this.lastCorrectText = str;
                    } else {
                        this.setToErrorColor();
                    }
                    return true;
                }
                if (event instanceof FocusListener.FocusEvent) {
                    String str;
                    if (!((FocusListener.FocusEvent)event).isFocused() && !this.validator.validate(str = this.getText())) {
                        this.setText(this.lastCorrectText);
                        this.setToRegularColor();
                    }
                    return true;
                }
                return false;
            };
            this.addListener(this.validatorListener);
            this.addValidatorTooltip();
        }
    }

    private void addValidatorTooltip() {
        this.addValidatorTooltip(this.validator);
    }

    private void addValidatorTooltip(IValidator validator) {
        if (validator != null) {
            if (validator instanceof FloatValidator) {
                FloatValidator fv = (FloatValidator)validator;
                this.validatorTooltipListener = new OwnTextTooltip(I18n.msg("gui.validator.values", fv.getMinString(), fv.getMaxString()), this.skin);
                this.addListener(this.validatorTooltipListener);
            } else if (validator instanceof DoubleValidator) {
                DoubleValidator dv = (DoubleValidator)validator;
                this.validatorTooltipListener = new OwnTextTooltip(I18n.msg("gui.validator.values", dv.getMinString(), dv.getMaxString()), this.skin);
                this.addListener(this.validatorTooltipListener);
            } else if (validator instanceof IntValidator) {
                IntValidator iv = (IntValidator)validator;
                this.validatorTooltipListener = new OwnTextTooltip(I18n.msg("gui.validator.values", iv.getMinString(), iv.getMaxString()), this.skin);
                this.addListener(this.validatorTooltipListener);
            } else if (validator instanceof LongValidator) {
                LongValidator lv = (LongValidator)validator;
                this.validatorTooltipListener = new OwnTextTooltip(I18n.msg("gui.validator.values", lv.getMinString(), lv.getMaxString()), this.skin);
                this.addListener(this.validatorTooltipListener);
            }
            if (validator instanceof CallbackValidator) {
                CallbackValidator cv = (CallbackValidator)validator;
                this.addValidatorTooltip(cv.getParent());
            }
        }
    }

    public void setWidth(float width) {
        this.ownWidth = width;
        super.setWidth(width);
    }

    public void setHeight(float height) {
        this.ownHeight = height;
        super.setHeight(height);
    }

    public void setSize(float width, float height) {
        this.ownWidth = width;
        this.ownHeight = height;
        super.setSize(width, height);
    }

    public float getPrefWidth() {
        if (this.ownWidth != 0.0f) {
            return this.ownWidth;
        }
        return super.getPrefWidth();
    }

    public float getPrefHeight() {
        if (this.ownHeight != 0.0f) {
            return this.ownHeight;
        }
        return super.getPrefHeight();
    }

    public void moveCursor(boolean forward, boolean jump) {
        super.moveCursor(forward, jump);
    }

    public void goHome(boolean jump) {
        this.cursor = 0;
    }

    public void goEnd(boolean jump) {
        this.cursor = this.text.length();
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        this.clearX = width - this.clearW - 6.0f;
        this.clearY = (height - this.clearH) / 2.0f;
        this.clearDrawable.draw(batch, x + this.clearX, y + this.clearY, this.clearW, this.clearH);
    }
}

