/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import gaiasky.util.TextUtils;
import gaiasky.util.scene2d.OwnLabel;

public class OwnTextHotkeyTooltip
extends Tooltip<Table> {
    private final OwnLabel label;
    private HorizontalGroup groupHotkeys;
    private OwnLabel labelHotkey;

    public OwnTextHotkeyTooltip(String text, String hotkey, Skin skin, int breakSpaces) {
        String[] stringArray;
        if (hotkey != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = hotkey;
        } else {
            stringArray = null;
        }
        this(text, stringArray, skin, TooltipManager.getInstance(), (TextTooltip.TextTooltipStyle)skin.get(TextTooltip.TextTooltipStyle.class), breakSpaces);
    }

    public OwnTextHotkeyTooltip(String text, String[] hotkeys, Skin skin, int breakSpaces) {
        this(text, hotkeys, skin, TooltipManager.getInstance(), (TextTooltip.TextTooltipStyle)skin.get(TextTooltip.TextTooltipStyle.class), breakSpaces);
    }

    public OwnTextHotkeyTooltip(String text, String hotkey, Skin skin) {
        this(text, hotkey, skin, -1);
    }

    public OwnTextHotkeyTooltip(String text, String[] hotkeys, Skin skin) {
        this(text, hotkeys, skin, -1);
    }

    public OwnTextHotkeyTooltip(String text, String[] hotkeys, Skin skin, TooltipManager manager, TextTooltip.TextTooltipStyle style, int breakSpaces) {
        super(null, manager);
        if (breakSpaces > 0) {
            text = TextUtils.breakSpaces(text, breakSpaces);
        }
        Table table = new Table(skin);
        this.label = new OwnLabel((CharSequence)text, skin);
        if (hotkeys != null && hotkeys.length > 0) {
            this.groupHotkeys = new HorizontalGroup();
            this.groupHotkeys.pad(2.0f);
            int n = hotkeys.length;
            for (int i = 0; i < hotkeys.length; ++i) {
                String hotkey = hotkeys[i];
                this.labelHotkey = new OwnLabel((CharSequence)("[" + hotkey + "]"), skin, "hotkey");
                this.groupHotkeys.addActor((Actor)this.labelHotkey);
                if (i >= n - 1) continue;
                this.groupHotkeys.addActor((Actor)new OwnLabel((CharSequence)" / ", skin));
            }
        }
        table.add((Actor)this.label).padRight(this.groupHotkeys != null ? 10.0f : 0.0f);
        if (this.groupHotkeys != null) {
            table.add((Actor)this.groupHotkeys);
        }
        table.pack();
        this.getContainer().setActor((Actor)table);
        this.getContainer().pack();
        this.setStyle(style);
        this.getContainer().pad(8.0f, 16.0f, 8.0f, 16.0f);
    }

    public void setStyle(TextTooltip.TextTooltipStyle style) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        this.label.setStyle(style.label);
        this.getContainer().setBackground(style.background);
        this.getContainer().maxWidth(style.wrapWidth);
    }
}

