/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Align;
import gaiasky.util.scene2d.OwnTextButton;

public class OwnTextIconButton
extends OwnTextButton {
    private final Skin skin;
    private Image icon;
    private TextIconButtonStyle style;
    private float pad = 2.0f;
    private float space = -1.0f;
    private int contentAlign = 1;

    public OwnTextIconButton(String text, Skin skin, String styleName) {
        super(text, skin);
        this.skin = skin;
        this.setStyle((TextButton.TextButtonStyle)skin.get(styleName, TextIconButtonStyle.class), "default");
    }

    public OwnTextIconButton(String text, int contentAlign, Skin skin, String styleName) {
        super(text, skin);
        this.skin = skin;
        this.contentAlign = contentAlign;
        this.setStyle((TextButton.TextButtonStyle)skin.get(styleName, TextIconButtonStyle.class), "default");
    }

    public OwnTextIconButton(String text, Skin skin, String styleName, String textButtonStyle) {
        super(text, skin);
        this.skin = skin;
        this.setStyle((TextButton.TextButtonStyle)skin.get(styleName, TextIconButtonStyle.class), textButtonStyle);
    }

    public OwnTextIconButton(String text, int align, Skin skin, String styleName, String textButtonStyle) {
        super(text, skin);
        this.skin = skin;
        this.contentAlign = align;
        this.setStyle((TextButton.TextButtonStyle)skin.get(styleName, TextIconButtonStyle.class), textButtonStyle);
    }

    public OwnTextIconButton(String text, Image up, Skin skin) {
        super(text, skin);
        this.skin = skin;
        this.setIcon(up);
    }

    public OwnTextIconButton(String text, Image up, Skin skin, String styleName) {
        super(text, skin, styleName);
        this.skin = skin;
        this.setIcon(up);
    }

    public OwnTextIconButton(String text, int contentAlign, Image up, Skin skin, String styleName) {
        super(text, skin, styleName);
        this.skin = skin;
        this.contentAlign = contentAlign;
        this.setIcon(up);
    }

    public void setContentAlign(int align) {
        this.contentAlign = align;
    }

    public void setPad(float pad) {
        this.pad = pad;
        this.setIcon(this.icon);
    }

    public void setSpace(float space) {
        this.space = space;
        this.setIcon(this.icon);
    }

    public void setStyle(TextButton.TextButtonStyle style, String defaultTextButtonStyle) {
        if (!(style instanceof TextIconButtonStyle)) {
            throw new IllegalArgumentException("style must be an ImageButtonStyle.");
        }
        if (style.font == null || style.fontColor == null) {
            TextButton.TextButtonStyle toggle = (TextButton.TextButtonStyle)this.skin.get(defaultTextButtonStyle, TextButton.TextButtonStyle.class);
            style = new TextIconButtonStyle(toggle, (TextIconButtonStyle)style);
        }
        super.setStyle((Button.ButtonStyle)style);
        this.style = (TextIconButtonStyle)style;
        this.setIcon(new Image(((TextIconButtonStyle)style).imageUp));
        if (this.icon != null) {
            this.updateImage();
        }
    }

    public void setDisabled(boolean isDisabled) {
        super.setDisabled(isDisabled);
        if (isDisabled) {
            if (this.style != null && this.style.disabledFontColor != null) {
                this.icon.setColor(this.style.disabledFontColor);
                this.setIcon(this.icon);
            }
        } else if (this.style != null && this.style.fontColor != null) {
            this.icon.setColor(this.style.fontColor);
            this.setIcon(this.icon);
        }
    }

    protected void updateImage() {
        if (this.style != null) {
            Drawable drawable = this.style.imageUp;
            if (this.isChecked() && this.style.imageDown != null) {
                drawable = this.style.imageDown;
            } else if (this.isOver() && this.style.imageOver != null) {
                drawable = this.style.imageOver;
            }
            this.icon.setDrawable(drawable);
        }
    }

    public void setIcon(Image icon) {
        this.icon = icon;
        this.clearChildren();
        if (Align.isRight((int)this.contentAlign)) {
            this.align(this.contentAlign);
            this.add((Actor)this.getLabel()).align(this.contentAlign).padRight(this.space <= 0.0f ? (this.getLabel().getText().length > 0 ? 12.8f : 1.0f) : this.space);
            this.add((Actor)this.icon).align(this.contentAlign).pad(this.pad);
        } else {
            this.align(this.contentAlign);
            this.add((Actor)this.icon).align(this.contentAlign).pad(this.pad).padRight(this.space <= 0.0f ? (this.getLabel().getText().length > 0 ? 12.8f : 1.0f) : this.space);
            this.add((Actor)this.getLabel()).align(this.contentAlign).padRight(this.pad);
        }
    }

    public void draw(Batch batch, float parentAlpha) {
        this.updateImage();
        super.draw(batch, parentAlpha);
    }

    public static class TextIconButtonStyle
    extends TextButton.TextButtonStyle {
        Drawable imageUp;
        Drawable imageDown;
        Drawable imageOver;

        public TextIconButtonStyle() {
        }

        public TextIconButtonStyle(TextButton.TextButtonStyle def, TextIconButtonStyle style) {
            super(def);
            Drawable imageUp = style.imageUp;
            Drawable imageDown = style.imageDown;
            Drawable imageHover = style.imageOver;
            this.imageUp = imageUp;
            this.imageDown = imageDown;
            this.imageOver = imageHover;
            if (style.up != null) {
                this.up = style.up;
            }
            if (style.down != null) {
                this.down = style.down;
            }
            if (style.font != null) {
                this.font = style.font;
            }
            if (style.fontColor != null) {
                this.fontColor = style.fontColor;
            }
            if (style.downFontColor != null) {
                this.downFontColor = style.downFontColor;
            }
            if (style.focused != null) {
                this.focused = style.focused;
            }
            if (style.checked != null) {
                this.checked = style.checked;
            }
            if (style.checkedFocused != null) {
                this.checkedFocused = style.checkedFocused;
            }
        }
    }
}

