/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import gaiasky.util.TextUtils;
import gaiasky.util.scene2d.OwnLabel;

public class OwnTextTooltip
extends Tooltip<Label> {
    private final OwnLabel label;

    public OwnTextTooltip(String text, Skin skin, int breakSpaces) {
        this(text, TooltipManager.getInstance(), (TextTooltip.TextTooltipStyle)skin.get(TextTooltip.TextTooltipStyle.class), breakSpaces);
    }

    public OwnTextTooltip(String text, Skin skin) {
        this(text, skin, 12);
    }

    public OwnTextTooltip(String text, Skin skin, String styleName) {
        this(text, TooltipManager.getInstance(), (TextTooltip.TextTooltipStyle)skin.get(styleName, TextTooltip.TextTooltipStyle.class), -1);
    }

    public OwnTextTooltip(String text, TextTooltip.TextTooltipStyle style) {
        this(text, TooltipManager.getInstance(), style, -1);
    }

    public OwnTextTooltip(String text, TooltipManager manager, Skin skin) {
        this(text, manager, (TextTooltip.TextTooltipStyle)skin.get(TextTooltip.TextTooltipStyle.class), -1);
    }

    public OwnTextTooltip(String text, TooltipManager manager, Skin skin, String styleName) {
        this(text, manager, (TextTooltip.TextTooltipStyle)skin.get(styleName, TextTooltip.TextTooltipStyle.class), -1);
    }

    public OwnTextTooltip(String text, TooltipManager manager, TextTooltip.TextTooltipStyle style, int breakSpaces) {
        super(null, manager);
        text = TextUtils.breakSpaces(text, breakSpaces);
        this.label = new OwnLabel((CharSequence)text, style.label);
        this.getContainer().setActor((Actor)this.label);
        this.setStyle(style);
        this.getContainer().pad(8.0f);
    }

    public void setStyle(TextTooltip.TextTooltipStyle style) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        ((Label)this.getContainer().getActor()).setStyle(style.label);
        this.getContainer().setBackground(style.background);
        this.getContainer().maxWidth(style.wrapWidth);
    }

    public void setText(String newText) {
        if (this.label != null) {
            this.label.setText(newText);
        }
    }
}

