/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import net.jafama.FastMath;

public class OwnWindow
extends Table {
    private static final Vector2 tmpPosition = new Vector2();
    private static final Vector2 tmpSize = new Vector2();
    private static final int MOVE = 32;
    protected int edge;
    protected boolean dragging;
    boolean isMovable = true;
    boolean isModal;
    boolean isResizable;
    int resizeBorder = 8;
    boolean keepWithinStage = true;
    Label titleLabel;
    Table titleTable;
    boolean drawTitleTable;
    private Window.WindowStyle style;

    public OwnWindow(String title, Skin skin) {
        this(title, (Window.WindowStyle)skin.get(Window.WindowStyle.class));
        this.setSkin(skin);
    }

    public OwnWindow(String title, Skin skin, String styleName) {
        this(title, (Window.WindowStyle)skin.get(styleName, Window.WindowStyle.class));
        this.setSkin(skin);
    }

    public OwnWindow(String title, Window.WindowStyle style) {
        if (title == null) {
            throw new IllegalArgumentException("title cannot be null.");
        }
        this.setTouchable(Touchable.enabled);
        this.setClip(true);
        this.titleLabel = new Label((CharSequence)title, new Label.LabelStyle(style.titleFont, style.titleFontColor));
        this.titleLabel.setEllipsis(true);
        this.titleTable = new Table(){

            public void draw(Batch batch, float parentAlpha) {
                if (OwnWindow.this.drawTitleTable) {
                    super.draw(batch, parentAlpha);
                }
            }
        };
        this.titleTable.add((Actor)this.titleLabel).expandX().fillX().minWidth(0.0f);
        this.addActor((Actor)this.titleTable);
        this.setStyle(style);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.addCaptureListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                OwnWindow.this.toFront();
                return false;
            }
        });
        this.addListener((EventListener)new InputListener(){
            float startX;
            float startY;
            float lastX;
            float lastY;

            private void updateEdge(float x, float y) {
                float border = (float)OwnWindow.this.resizeBorder / 2.0f;
                float width = OwnWindow.this.getWidth();
                float height = OwnWindow.this.getHeight();
                float padTop = OwnWindow.this.getPadTop();
                float padRight = OwnWindow.this.getPadRight();
                float right = width - padRight;
                OwnWindow.this.edge = 0;
                if (OwnWindow.this.isResizable && x >= OwnWindow.this.getPadLeft() - border && x <= right + border && y >= OwnWindow.this.getPadBottom() - border) {
                    if (x < OwnWindow.this.getPadLeft() + border) {
                        OwnWindow.this.edge |= 8;
                    }
                    if (x > right - border) {
                        OwnWindow.this.edge |= 0x10;
                    }
                    if (y < OwnWindow.this.getPadBottom() + border) {
                        OwnWindow.this.edge |= 4;
                    }
                    if (OwnWindow.this.edge != 0) {
                        border += 25.0f;
                    }
                    if (x < OwnWindow.this.getPadLeft() + border) {
                        OwnWindow.this.edge |= 8;
                    }
                    if (x > right - border) {
                        OwnWindow.this.edge |= 0x10;
                    }
                    if (y < OwnWindow.this.getPadBottom() + border) {
                        OwnWindow.this.edge |= 4;
                    }
                }
                if (OwnWindow.this.isMovable && OwnWindow.this.edge == 0 && y <= height && y >= height - padTop && x >= OwnWindow.this.getPadLeft() && x <= right) {
                    OwnWindow.this.edge = 32;
                }
            }

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 0) {
                    this.updateEdge(x, y);
                    OwnWindow.this.dragging = OwnWindow.this.edge != 0;
                    this.startX = x;
                    this.startY = y;
                    this.lastX = x - OwnWindow.this.getWidth();
                    this.lastY = y - OwnWindow.this.getHeight();
                }
                return OwnWindow.this.edge != 0 || OwnWindow.this.isModal;
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OwnWindow.this.dragging = false;
            }

            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                float amountY;
                float amountX;
                boolean clampPosition;
                if (!OwnWindow.this.dragging) {
                    return;
                }
                float width = OwnWindow.this.getWidth();
                float height = OwnWindow.this.getHeight();
                float windowX = OwnWindow.this.getX();
                float windowY = OwnWindow.this.getY();
                float minWidth = OwnWindow.this.getMinWidth();
                float minHeight = OwnWindow.this.getMinHeight();
                Stage stage = OwnWindow.this.getStage();
                boolean bl = clampPosition = OwnWindow.this.keepWithinStage && stage != null && OwnWindow.this.getParent() == stage.getRoot();
                if ((OwnWindow.this.edge & 0x20) != 0) {
                    amountX = x - this.startX;
                    float amountY2 = y - this.startY;
                    windowX += amountX;
                    windowY += amountY2;
                }
                if ((OwnWindow.this.edge & 8) != 0) {
                    amountX = x - this.startX;
                    if (width - amountX < minWidth) {
                        amountX = -(minWidth - width);
                    }
                    if (clampPosition && windowX + amountX < 0.0f) {
                        amountX = -windowX;
                    }
                    width -= amountX;
                    windowX += amountX;
                }
                if ((OwnWindow.this.edge & 4) != 0) {
                    amountY = y - this.startY;
                    if (height - amountY < minHeight) {
                        amountY = -(minHeight - height);
                    }
                    if (clampPosition && windowY + amountY < 0.0f) {
                        amountY = -windowY;
                    }
                    height -= amountY;
                    windowY += amountY;
                }
                if ((OwnWindow.this.edge & 0x10) != 0) {
                    amountX = x - this.lastX - width;
                    if (width + amountX < minWidth) {
                        amountX = minWidth - width;
                    }
                    if (clampPosition && windowX + width + amountX > stage.getWidth()) {
                        amountX = stage.getWidth() - windowX - width;
                    }
                    width += amountX;
                }
                if ((OwnWindow.this.edge & 2) != 0) {
                    amountY = y - this.lastY - height;
                    if (height + amountY < minHeight) {
                        amountY = minHeight - height;
                    }
                    if (clampPosition && windowY + height + amountY > stage.getHeight()) {
                        amountY = stage.getHeight() - windowY - height;
                    }
                    height += amountY;
                }
                OwnWindow.this.setBounds(windowX, windowY, width, height);
            }

            public boolean mouseMoved(InputEvent event, float x, float y) {
                this.updateEdge(x, y);
                return OwnWindow.this.isModal;
            }

            public boolean keyDown(InputEvent event, int keycode) {
                return OwnWindow.this.isModal;
            }

            public boolean keyUp(InputEvent event, int keycode) {
                return OwnWindow.this.isModal;
            }

            public boolean keyTyped(InputEvent event, char character) {
                return OwnWindow.this.isModal;
            }
        });
    }

    public Window.WindowStyle getStyle() {
        return this.style;
    }

    public void setStyle(Window.WindowStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.setBackground(style.background);
        this.titleLabel.setStyle(new Label.LabelStyle(style.titleFont, style.titleFontColor));
        this.invalidateHierarchy();
    }

    public void keepWithinStage() {
        if (!this.keepWithinStage) {
            return;
        }
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        Camera camera = stage.getCamera();
        if (camera instanceof OrthographicCamera) {
            OrthographicCamera orthographicCamera = (OrthographicCamera)camera;
            float parentWidth = stage.getWidth();
            float parentHeight = stage.getHeight();
            if (this.getX(16) - camera.position.x > parentWidth / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x + parentWidth / 2.0f / orthographicCamera.zoom, this.getY(16), 16);
            }
            if (this.getX(8) - camera.position.x < -parentWidth / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x - parentWidth / 2.0f / orthographicCamera.zoom, this.getY(8), 8);
            }
            if (this.getY(2) - camera.position.y > parentHeight / 2.0f / orthographicCamera.zoom) {
                this.setPosition(this.getX(2), camera.position.y + parentHeight / 2.0f / orthographicCamera.zoom, 2);
            }
            if (this.getY(4) - camera.position.y < -parentHeight / 2.0f / orthographicCamera.zoom) {
                this.setPosition(this.getX(4), camera.position.y - parentHeight / 2.0f / orthographicCamera.zoom, 4);
            }
        } else if (this.getParent() == stage.getRoot()) {
            float parentWidth = stage.getWidth();
            float parentHeight = stage.getHeight();
            if (this.getX() < 0.0f) {
                this.setX(0.0f);
            }
            if (this.getRight() > parentWidth) {
                this.setX(parentWidth - this.getWidth());
            }
            if (this.getY() < 0.0f) {
                this.setY(0.0f);
            }
            if (this.getTop() > parentHeight) {
                this.setY(parentHeight - this.getHeight());
            }
        }
    }

    public void draw(Batch batch, float parentAlpha) {
        Stage stage = this.getStage();
        if (stage != null && stage.getKeyboardFocus() == null) {
            stage.setKeyboardFocus((Actor)this);
        }
        this.keepWithinStage();
        if (this.style.stageBackground != null) {
            this.stageToLocalCoordinates(tmpPosition.set(0.0f, 0.0f));
            if (stage != null) {
                this.stageToLocalCoordinates(tmpSize.set(stage.getWidth(), stage.getHeight()));
            }
            this.drawStageBackground(batch, parentAlpha, this.getX() + OwnWindow.tmpPosition.x, this.getY() + OwnWindow.tmpPosition.y, this.getX() + OwnWindow.tmpSize.x, this.getY() + OwnWindow.tmpSize.y);
        }
        super.draw(batch, parentAlpha);
    }

    protected void drawStageBackground(Batch batch, float parentAlpha, float x, float y, float width, float height) {
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.style.stageBackground.draw(batch, x, y, width, height);
    }

    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        super.drawBackground(batch, parentAlpha, x, y);
        this.titleTable.getColor().a = this.getColor().a;
        float padTop = this.getPadTop();
        float padLeft = this.getPadLeft();
        this.titleTable.setSize(this.getWidth() - padLeft - this.getPadRight(), padTop);
        this.titleTable.setPosition(padLeft, this.getHeight() - padTop);
        this.drawTitleTable = true;
        this.titleTable.draw(batch, parentAlpha);
        this.drawTitleTable = false;
    }

    public Actor hit(float x, float y, boolean touchable) {
        if (!this.isVisible()) {
            return null;
        }
        Actor hit = super.hit(x, y, touchable);
        if (hit == null && this.isModal && (!touchable || this.getTouchable() == Touchable.enabled)) {
            return this;
        }
        float height = this.getHeight();
        if (hit == null || hit == this) {
            return hit;
        }
        if (y <= height && y >= height - this.getPadTop() && x >= 0.0f && x <= this.getWidth()) {
            Actor current = hit;
            while (current.getParent() != this) {
                current = current.getParent();
            }
            if (this.getCell(current) != null) {
                return this;
            }
        }
        return hit;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void setModal(boolean isModal) {
        this.isModal = isModal;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public void setResizable(boolean isResizable) {
        this.isResizable = isResizable;
    }

    public float getPrefWidth() {
        return FastMath.max((float)super.getPrefWidth(), (float)(this.titleTable.getPrefWidth() + this.getPadLeft() + this.getPadRight()));
    }

    public Table getTitleTable() {
        return this.titleTable;
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    protected HorizontalGroup hg(Actor ... actors) {
        HorizontalGroup hg = new HorizontalGroup();
        for (Actor a : actors) {
            hg.addActor(a);
        }
        return hg;
    }
}

