/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class Separator
extends Widget {
    private final SeparatorStyle style;

    public Separator(Skin skin) {
        this.style = (SeparatorStyle)skin.get(SeparatorStyle.class);
    }

    public Separator(Skin skin, String styleName) {
        this.style = (SeparatorStyle)skin.get(styleName, SeparatorStyle.class);
    }

    public Separator(SeparatorStyle style) {
        this.style = style;
    }

    public float getPrefHeight() {
        return this.style.thickness;
    }

    public float getPrefWidth() {
        return this.style.thickness;
    }

    public void draw(Batch batch, float parentAlpha) {
        Color c = this.getColor();
        batch.setColor(c.r, c.g, c.b, c.a * parentAlpha);
        this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public SeparatorStyle getStyle() {
        return this.style;
    }

    public static class SeparatorStyle {
        public Drawable background;
        public int thickness;

        public SeparatorStyle() {
        }

        public SeparatorStyle(SeparatorStyle style) {
            this.background = style.background;
            this.thickness = style.thickness;
        }

        public SeparatorStyle(Drawable bg, int thickness) {
            this.background = bg;
            this.thickness = thickness;
        }
    }
}

