/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class TabbedPane
extends Table {
    Table tabTitleTable;
    Stack tabBodyStack;
    int selectedIndex;
    int tabTitleAlign = 8;
    private TabbedPaneStyle style;

    public TabbedPane(Skin skin) {
        super(skin);
        this.initialize((TabbedPaneStyle)skin.get(TabbedPaneStyle.class));
    }

    public TabbedPane(Skin skin, int tabTitleAlign) {
        super(skin);
        this.tabTitleAlign = tabTitleAlign;
        this.initialize((TabbedPaneStyle)skin.get(TabbedPaneStyle.class));
    }

    public TabbedPane(Skin skin, String styleName) {
        super(skin);
        this.initialize((TabbedPaneStyle)skin.get(styleName, TabbedPaneStyle.class));
    }

    public TabbedPane(Skin skin, String styleName, int tabTitleAlign) {
        super(skin);
        this.tabTitleAlign = tabTitleAlign;
        this.initialize((TabbedPaneStyle)skin.get(styleName, TabbedPaneStyle.class));
    }

    public TabbedPane(TabbedPaneStyle style) {
        this.initialize(style);
    }

    public TabbedPane(TabbedPaneStyle style, int tabTitleAlign) {
        this.tabTitleAlign = tabTitleAlign;
        this.initialize(style);
    }

    public TabbedPane() {
        this.initialize();
    }

    private void initialize(TabbedPaneStyle style) {
        this.setStyle(style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.initialize();
    }

    private void initialize() {
        this.setTouchable(Touchable.enabled);
        this.tabTitleTable = new Table();
        this.tabBodyStack = new Stack();
        this.selectedIndex = -1;
        Cell leftCell = this.add((Actor)new Image(this.style.titleBegin));
        Cell midCell = this.add((Actor)this.tabTitleTable);
        Cell rightCell = this.add((Actor)new Image(this.style.titleEnd));
        switch (this.tabTitleAlign) {
            case 8: {
                leftCell.width(leftCell.getActor().getWidth()).bottom();
                midCell.left();
                rightCell.expandX().fillX().bottom();
                break;
            }
            case 16: {
                leftCell.expandX().fillX().bottom();
                midCell.right();
                rightCell.width(rightCell.getActor().getWidth()).bottom();
                break;
            }
            case 1: {
                leftCell.expandX().fillX().bottom();
                midCell.center();
                rightCell.expandX().fillX().bottom();
                break;
            }
            default: {
                throw new IllegalArgumentException("TabbedPane align must be one of left, center, right");
            }
        }
        this.row();
        Table t = new Table();
        t.setBackground(this.style.bodyBackground);
        t.add((Actor)this.tabBodyStack);
        this.add((Actor)t).colspan(3).expand().fill();
    }

    public Table debug() {
        this.tabTitleTable.debug();
        return super.debug();
    }

    public TabbedPaneStyle getStyle() {
        return this.style;
    }

    public void setStyle(TabbedPaneStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.invalidateHierarchy();
    }

    public void addTab(String title, Actor actor) {
        int index = this.tabTitleTable.getCells().size;
        TabTitleButton button = new TabTitleButton(index, title, this.style);
        button.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                TabTitleButton tabTitleButton = (TabTitleButton)event.getListenerActor();
                TabbedPane.this.setSelectedIndex(tabTitleButton.index);
            }
        });
        this.tabTitleTable.add((Actor)button);
        this.tabBodyStack.add(actor);
        this.setSelectedIndex(index);
        this.setSelectedIndex(0);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (this.selectedIndex == index) {
            return;
        }
        int tabs = this.tabTitleTable.getCells().size;
        if (this.selectedIndex >= 0 && this.selectedIndex < tabs) {
            this.setSelectedTab(false);
        }
        this.selectedIndex = index;
        if (this.selectedIndex >= 0 && this.selectedIndex < tabs) {
            this.setSelectedTab(true);
        }
        this.fireStateChanged();
    }

    private void setSelectedTab(boolean value) {
        TabTitleButton tabTitleButton = (TabTitleButton)((Cell)this.tabTitleTable.getCells().get(this.selectedIndex)).getActor();
        tabTitleButton.setDisabled(value);
        tabTitleButton.setChecked(value);
        ((Actor)this.tabBodyStack.getChildren().get(this.selectedIndex)).setVisible(value);
    }

    protected void fireStateChanged() {
        ChangeListener.ChangeEvent changeEvent = new ChangeListener.ChangeEvent();
        changeEvent.setBubbles(false);
        this.fire((Event)changeEvent);
    }

    public static class TabbedPaneStyle {
        public Drawable titleBegin;
        public Drawable titleEnd;
        public Drawable bodyBackground;
        public Drawable titleButtonSelected;
        public Drawable titleButtonUnselected;
        public BitmapFont font;
        public Color fontColor;
        public Color downFontColor;
        public Color overFontColor;
        public Color checkedFontColor;
        public Color checkedOverFontColor;
        public Color disabledFontColor;

        public TabbedPaneStyle() {
        }

        public TabbedPaneStyle(Drawable titleBegin, Drawable titleEnd, Drawable bodyBackground, Drawable titleButtonSelected, Drawable titleButtonUnselected, BitmapFont font) {
            this.titleBegin = titleBegin;
            this.titleEnd = titleEnd;
            this.bodyBackground = bodyBackground;
            this.titleButtonSelected = titleButtonSelected;
            this.titleButtonUnselected = titleButtonUnselected;
            this.font = font;
        }

        public TabbedPaneStyle(TabbedPaneStyle style) {
            this.titleBegin = style.titleBegin;
            this.titleEnd = style.titleEnd;
            this.bodyBackground = style.bodyBackground;
            this.titleButtonSelected = style.titleButtonSelected;
            this.titleButtonUnselected = style.titleButtonUnselected;
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.downFontColor != null) {
                this.downFontColor = new Color(style.downFontColor);
            }
            if (style.overFontColor != null) {
                this.overFontColor = new Color(style.overFontColor);
            }
            if (style.checkedFontColor != null) {
                this.checkedFontColor = new Color(style.checkedFontColor);
            }
            if (style.checkedOverFontColor != null) {
                this.checkedFontColor = new Color(style.checkedOverFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
        }
    }

    private static class TabTitleButton
    extends TextButton {
        private final int index;

        private TabTitleButton(int index, String text, TabbedPaneStyle style) {
            super(text, TabTitleButton.toTextButtonStyle(style));
            this.index = index;
        }

        private static TextButton.TextButtonStyle toTextButtonStyle(TabbedPaneStyle style) {
            TextButton.TextButtonStyle buttonStyle = new TextButton.TextButtonStyle(style.titleButtonUnselected, null, style.titleButtonSelected, style.font);
            buttonStyle.fontColor = style.fontColor;
            buttonStyle.downFontColor = style.downFontColor;
            buttonStyle.overFontColor = style.overFontColor;
            buttonStyle.checkedFontColor = style.checkedFontColor;
            buttonStyle.checkedOverFontColor = style.checkedOverFontColor;
            buttonStyle.disabledFontColor = style.disabledFontColor;
            return buttonStyle;
        }
    }
}

