/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.scene2d;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;

public class TextureWidget
extends Widget {
    private final Texture texture;
    private float width;
    private float height;
    private boolean flipX;
    private boolean flipY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;

    public TextureWidget(FrameBuffer fb) {
        this.texture = (Texture)fb.getColorBufferTexture();
        this.width = fb.getWidth();
        this.height = fb.getHeight();
    }

    public TextureWidget(Texture texture) {
        this.texture = texture;
        this.width = texture.getWidth();
        this.height = texture.getHeight();
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.texture != null) {
            if (this.flipX || this.flipY || this.scaleX != 1.0f || this.scaleY != 1.0f) {
                batch.draw(this.texture, this.getX(), this.getY(), 0.0f, 0.0f, (float)this.texture.getWidth(), (float)this.texture.getHeight(), this.scaleX, this.scaleY, 0.0f, 0, 0, this.texture.getWidth(), this.texture.getHeight(), this.flipX, this.flipY);
            } else {
                batch.draw(this.texture, this.getX(), this.getY(), this.width, this.height);
            }
        }
    }

    public void setFlip(boolean x, boolean y) {
        this.flipX = x;
        this.flipY = y;
    }

    public void setScale(float scale) {
        this.setScale(scale, scale);
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.width *= scaleX;
        this.height *= scaleY;
    }

    public float getMinWidth() {
        return this.width;
    }

    public float getMinHeight() {
        return this.height;
    }

    public float getPrefWidth() {
        return this.width;
    }

    public float getPrefHeight() {
        return this.height;
    }

    public float getMaxWidth() {
        return this.width;
    }

    public float getMaxHeight() {
        return this.height;
    }
}

