/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.screenshot;

import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import gaiasky.render.BufferedFrame;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.screenshot.IFileImageRenderer;
import gaiasky.util.screenshot.ImageRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class BufferedFileImageRenderer
implements IFileImageRenderer {
    private static final Logger.Log logger = Logger.getLogger(BufferedFileImageRenderer.class);
    private static final Timer timer = new Timer(true);
    private final List<BufferedFrame> outputFrameBuffer;
    private final Pool<BufferedFrame> bfPool;
    private final int bufferSize;

    public BufferedFileImageRenderer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.outputFrameBuffer = new ArrayList<BufferedFrame>(bufferSize);
        this.bfPool = Pools.get(BufferedFrame.class, (int)bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveScreenshot(String folder, String filePrefix, int w, int h, boolean immediate, Settings.ImageFormat type, float quality) {
        String res;
        if (!immediate) {
            if (this.outputFrameBuffer.size() >= this.bufferSize) {
                this.flush();
            }
            List<BufferedFrame> list = this.outputFrameBuffer;
            synchronized (list) {
                BufferedFrame bf = (BufferedFrame)this.bfPool.obtain();
                bf.pixmap = ImageRenderer.renderToPixmap(w, h);
                bf.folder = folder;
                bf.filename = filePrefix;
                this.outputFrameBuffer.add(bf);
            }
            res = "buffer";
        } else {
            res = ImageRenderer.renderToImageGl20(folder, filePrefix, w, h, type, quality);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        List<BufferedFrame> list = this.outputFrameBuffer;
        synchronized (list) {
            final ArrayList<BufferedFrame> outputFrameBufferCopy = new ArrayList<BufferedFrame>(this.outputFrameBuffer);
            this.outputFrameBuffer.clear();
            final int size = outputFrameBufferCopy.size();
            if (size > 0) {
                logger.info(I18n.msg("notif.flushframebuffer"));
                TimerTask tt = new TimerTask(this){
                    final /* synthetic */ BufferedFileImageRenderer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        String folder = null;
                        for (BufferedFrame bf : outputFrameBufferCopy) {
                            ImageRenderer.writePixmapToImage(bf.folder, bf.filename, bf.pixmap, Settings.settings.frame.format, Settings.settings.frame.quality);
                            folder = bf.folder;
                            this.this$0.bfPool.free((Object)bf);
                        }
                        logger.info(I18n.msg("notif.flushframebuffer.finished", size, folder));
                    }
                };
                timer.schedule(tt, 0L);
            }
        }
    }
}

