/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.screenshot;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import gaiasky.util.Settings;
import gaiasky.util.screenshot.JPGWriter;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Arrays;

public class ImageRenderer {
    private static int sequenceNumber = 0;

    public static String renderToImageGl20(String absoluteLocation, String baseFileName, int w, int h, Settings.ImageFormat format, float quality) {
        Pixmap pixmap = ImageRenderer.getScreenshot(0, 0, w, h, true);
        String file = ImageRenderer.writePixmapToImage(absoluteLocation, baseFileName, pixmap, format, quality);
        pixmap.dispose();
        return file;
    }

    public static Pixmap renderToPixmap(int w, int h) {
        return ImageRenderer.getScreenshot(0, 0, w, h, true);
    }

    public static String writePixmapToImage(String absoluteLocation, String baseFileName, Pixmap pixmap, Settings.ImageFormat format, float quality) {
        FileHandle dir = Gdx.files.absolute(absoluteLocation);
        dir.mkdirs();
        FileHandle fh = ImageRenderer.getTarget(absoluteLocation, baseFileName, format);
        switch (format) {
            case PNG: {
                PixmapIO.writePNG((FileHandle)fh, (Pixmap)pixmap);
                break;
            }
            case JPG: {
                JPGWriter.setQuality(quality);
                JPGWriter.write(fh, pixmap);
            }
        }
        return fh.path();
    }

    private static Pixmap getScreenshot(int x, int y, int w, int h, boolean flipY) {
        Gdx.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        ByteBuffer pixels = pixmap.getPixels();
        Gdx.gl.glReadPixels(x, y, w, h, 6408, 5121, (Buffer)pixels);
        int numBytes = w * h * 4;
        byte[] lines = new byte[numBytes];
        if (flipY) {
            int numBytesPerLine = w * 4;
            for (int i = 0; i < h; ++i) {
                pixels.position((h - i - 1) * numBytesPerLine);
                pixels.get(lines, i * numBytesPerLine, numBytesPerLine);
                for (int j = 3; j < w * 4; j += 4) {
                    lines[j + i * w * 4] = -1;
                }
            }
            pixels.clear();
            pixels.put(lines);
        } else {
            pixels.clear();
            pixels.get(lines);
        }
        return pixmap;
    }

    private static synchronized FileHandle getTarget(String absoluteLocation, String baseFileName, Settings.ImageFormat format) {
        FileHandle fh = Gdx.files.absolute(absoluteLocation + File.separator + baseFileName + ImageRenderer.getNextSeqNumSuffix() + "." + format.extension);
        while (fh.exists()) {
            fh = Gdx.files.absolute(absoluteLocation + File.separator + baseFileName + ImageRenderer.getNextSeqNumSuffix() + "." + format.extension);
        }
        return fh;
    }

    private static synchronized String getNextSeqNumSuffix() {
        return "_" + ImageRenderer.intToString(sequenceNumber++, 5);
    }

    private static String intToString(int num, int digits) {
        assert (digits > 0) : "Invalid number of digits";
        char[] zeros = new char[digits];
        Arrays.fill(zeros, '0');
        DecimalFormat df = new DecimalFormat(String.valueOf(zeros));
        return df.format(num);
    }

    public static synchronized int getSequenceNumber() {
        return sequenceNumber;
    }

    public static synchronized void resetSequenceNumber() {
        sequenceNumber = 0;
    }
}

