/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.screenshot;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import gaiasky.util.Logger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;

public class JPGWriter {
    private static final Logger.Log logger = Logger.getLogger(JPGWriter.class);
    private static float QUALITY = 0.93f;
    private static JPEGImageWriteParam jpegParams;

    public static void updateJPEGParams() {
        jpegParams = new JPEGImageWriteParam(null);
        jpegParams.setCompressionMode(2);
        jpegParams.setCompressionQuality(QUALITY);
    }

    public static void setQuality(float quality) {
        if (quality != QUALITY) {
            QUALITY = quality;
            JPGWriter.updateJPEGParams();
        }
    }

    public static void write(FileHandle file, Pixmap pix) {
        try (FileImageOutputStream outputStream = new FileImageOutputStream(file.file());){
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
            writer.setOutput(outputStream);
            writer.write(null, new IIOImage(JPGWriter.pixmapToBufferedImage(pix), null, null), jpegParams);
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    static BufferedImage pixmapToBufferedImage(Pixmap p) {
        int w = p.getWidth();
        int h = p.getHeight();
        BufferedImage img = new BufferedImage(w, h, 1);
        int[] pixels = new int[w * h];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int value = p.getPixel(x, y);
                int R = (value & 0xFF000000) >>> 24;
                int G = (value & 0xFF0000) >>> 16;
                int B = (value & 0xFF00) >>> 8;
                int i = x + y * w;
                pixels[i] = R << 16 | G << 8 | B;
            }
        }
        img.setRGB(0, 0, w, h, pixels, 0, w);
        return img;
    }

    static {
        JPGWriter.updateJPEGParams();
    }
}

