/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.screenshot;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.api.IGui;
import gaiasky.gui.main.FrameOutputGui;
import gaiasky.render.api.IPostProcessor;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.GlobalResources;
import gaiasky.util.OneTimeRunnable;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.screenshot.BasicFileImageRenderer;
import gaiasky.util.screenshot.IFileImageRenderer;
import gaiasky.util.screenshot.ImageRenderer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ScreenshotsManager
implements IObserver {
    private static final String SCREENSHOT_FILENAME = "screenshot";
    private final GaiaSky gaiaSky;
    private final SceneRenderer sceneRenderer;
    private final IGui renderGui;
    public IFileImageRenderer frameRenderer;
    public IFileImageRenderer screenshotRenderer;

    public ScreenshotsManager(GaiaSky gaiaSky, SceneRenderer sceneRenderer, GlobalResources globalResources) {
        this.gaiaSky = gaiaSky;
        this.sceneRenderer = sceneRenderer;
        this.frameRenderer = new BasicFileImageRenderer();
        this.screenshotRenderer = new BasicFileImageRenderer();
        this.renderGui = new FrameOutputGui(globalResources.getSkin(), Gdx.graphics, Float.valueOf(Settings.settings.program.ui.scale));
        this.renderGui.initialize(null, globalResources.getSpriteBatch());
        this.renderGui.doneLoading(null);
        EventManager.instance.subscribe((IObserver)this, Event.RENDER_FRAME, Event.RENDER_FRAME_BUFFER, Event.FLUSH_FRAMES, Event.SCREENSHOT_CMD, Event.UPDATE_GUI, Event.DISPOSE);
    }

    private static String getCurrentTimeStamp() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        Date now = new Date();
        return sdfDate.format(now);
    }

    public void renderFrame() {
        this.gaiaSky.getCameraManager().backupCamera();
        Settings settings = Settings.settings;
        if (settings.frame.active) {
            switch (settings.frame.mode) {
                case SIMPLE: {
                    this.frameRenderer.saveScreenshot(settings.frame.location, settings.frame.prefix, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true, settings.frame.format, settings.frame.quality);
                    break;
                }
                case ADVANCED: {
                    GaiaSky.instance.resizeImmediate(settings.frame.resolution[0], settings.frame.resolution[1], false, true, false, true);
                    this.renderToImage(this.sceneRenderer, this.gaiaSky.getCameraManager(), this.gaiaSky.getT(), this.gaiaSky.getPostProcessor().getPostProcessBean(IPostProcessor.RenderType.frame), settings.frame.resolution[0], settings.frame.resolution[1], settings.frame.location, settings.frame.prefix, this.frameRenderer, settings.frame.format, settings.frame.quality);
                    GaiaSky.instance.resizeImmediate(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false, true, false, true);
                }
            }
        }
        this.gaiaSky.getCameraManager().restoreCamera();
    }

    private void renderScreenshot(int width, int height, String directory) {
        this.gaiaSky.getCameraManager().backupCamera();
        Settings settings = Settings.settings;
        String file = null;
        String filename = ScreenshotsManager.getCurrentTimeStamp() + "_screenshot";
        switch (settings.screenshot.mode) {
            case SIMPLE: {
                file = ImageRenderer.renderToImageGl20(directory, filename, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), settings.screenshot.format, settings.screenshot.quality);
                break;
            }
            case ADVANCED: {
                GaiaSky.instance.resizeImmediate(width, height, false, true, false, true);
                file = this.renderToImage(this.sceneRenderer, this.gaiaSky.getCameraManager(), this.gaiaSky.getT(), this.gaiaSky.getPostProcessor().getPostProcessBean(IPostProcessor.RenderType.screenshot), width, height, directory, filename, this.screenshotRenderer, settings.screenshot.format, settings.screenshot.quality);
                GaiaSky.instance.resizeImmediate(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false, true, false, true);
            }
        }
        if (file != null) {
            EventManager.publish(Event.SCREENSHOT_INFO, this, file);
            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.screenshot", file));
        }
        this.gaiaSky.getCameraManager().restoreCamera();
    }

    public void renderCurrentFrameBuffer(String folder, String file, int w, int h) {
        String f = ImageRenderer.renderToImageGl20(folder, file, w, h, Settings.settings.screenshot.format, Settings.settings.screenshot.quality);
        if (f != null) {
            EventManager.publish(Event.SCREENSHOT_INFO, this, f);
            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.screenshot", file));
        }
    }

    public void takeScreenshot(final int width, final int height, final String directory) {
        OneTimeRunnable process = new OneTimeRunnable(this, "screenshot-cmd"){
            final /* synthetic */ ScreenshotsManager this$0;
            {
                this.this$0 = this$0;
                super(name);
            }

            @Override
            protected void process() {
                this.this$0.renderScreenshot(width, height, directory);
            }
        };
        process.post();
    }

    public String renderToImage(SceneRenderer sceneRenderer, ICamera camera, double dt, IPostProcessor.PostProcessBean ppb, int width, int height, String folder, String filename, IFileImageRenderer imageRenderer, Settings.ImageFormat format, float quality) {
        boolean postprocessing;
        FrameBuffer frameBuffer = sceneRenderer.getFrameBuffer(width, height);
        boolean bl = postprocessing = ppb.pp.buildEnabledEffectsList() > 0;
        if (!postprocessing) {
            frameBuffer.begin();
        }
        sceneRenderer.clearScreen();
        sceneRenderer.render(camera, dt, width, height, width, height, frameBuffer, ppb);
        if (postprocessing) {
            frameBuffer.begin();
        }
        if (Settings.settings.frame.time) {
            this.renderGui().resize(width, height);
            this.renderGui().render(width, height);
        }
        String res = imageRenderer.saveScreenshot(folder, filename, width, height, false, format, quality);
        frameBuffer.end();
        return res;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case RENDER_FRAME: {
                this.renderFrame();
                break;
            }
            case RENDER_FRAME_BUFFER: {
                String folder = (String)data[0];
                String file = (String)data[1];
                Integer w = (Integer)data[2];
                Integer h = (Integer)data[3];
                this.renderCurrentFrameBuffer(folder, file, w, h);
                break;
            }
            case FLUSH_FRAMES: {
                this.frameRenderer.flush();
                break;
            }
            case SCREENSHOT_CMD: {
                this.takeScreenshot((Integer)data[0], (Integer)data[1], (String)data[2]);
                break;
            }
            case UPDATE_GUI: {
                this.renderGui().update((Double)data[0]);
                break;
            }
            case DISPOSE: {
                if (this.renderGui == null) break;
                this.renderGui.dispose();
            }
        }
    }

    private IGui renderGui() {
        return this.renderGui;
    }
}

