/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.svt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.badlogic.gdx.files.FileHandle;
import gaiasky.gui.main.ConsoleLogger;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.svt.SVTQuadtree;
import gaiasky.util.svt.SVTQuadtreeBuilder;
import gaiasky.util.svt.SVTQuadtreeNode;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import net.jafama.FastMath;

public class SVTMain {
    private static Logger.Log logger;

    public static void main(String[] args) {
        try {
            String ASSETS_LOC = Settings.ASSETS_LOC + "/";
            I18n.locale = Locale.getDefault();
            Gdx.files = new Lwjgl3Files();
            File dummyVersion = new File(ASSETS_LOC + "data/dummyversion");
            if (!dummyVersion.exists()) {
                dummyVersion = new File(ASSETS_LOC + "dummyversion");
            }
            SettingsManager.initialize(new FileInputStream(ASSETS_LOC + "/conf/config.yaml"), new FileInputStream(dummyVersion));
            I18n.initialize(new FileHandle(ASSETS_LOC + "i18n/gsbundle"), new FileHandle(ASSETS_LOC + "i18n/objects"));
            new ConsoleLogger();
            logger = Logger.getLogger(SVTQuadtreeBuilder.class);
        }
        catch (Exception e) {
            System.err.println("Initialization error");
            e.printStackTrace(System.err);
            return;
        }
        Path loc = Paths.get("/media/tsagrista/Daten/Gaia/gaiasky/data/virtualtex-earth-diffuse/tex/", new String[0]);
        SVTQuadtreeBuilder builder = new SVTQuadtreeBuilder();
        SVTQuadtree<Path> tree = builder.build("test", loc, 512);
        int maxResolution = (int)((double)tree.tileSize * FastMath.pow((double)2.0, (double)tree.depth));
        logger.info("SVT initialized with " + tree.root.length + " roots, " + tree.numTiles + " tiles (" + tree.tileSize + "x" + tree.tileSize + "), depth " + tree.depth + " and maximum resolution of " + maxResolution * tree.root.length + "x" + maxResolution);
        SVTMain.test(tree, 0, 0.55, 0.55);
        SVTMain.test(tree, 0, 0.25, 0.95);
        SVTMain.test(tree, 1, 0.55, 0.45);
        SVTMain.test(tree, 1, 0.75, 0.95);
        SVTMain.test(tree, 3, 0.75, 0.95);
        SVTMain.test(tree, 5, 0.05, 0.4);
        SVTMain.test(tree, 6, 0.75, 0.95);
    }

    private static void test(SVTQuadtree<Path> tree, int level, double u, double v) {
        logger.info("L" + level + " u: " + u + ", v: " + v);
        SVTQuadtreeNode<Path> tile = tree.getTileFromUV(level, u, v);
        logger.info(tile != null ? tile : "null");
    }
}

