/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.svt;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.record.CloudComponent;
import gaiasky.scene.record.MaterialComponent;
import gaiasky.scene.record.NamedComponent;
import gaiasky.scene.record.VirtualTextureComponent;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.svt.SVTQuadtreeNode;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;

public class SVTManager
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(SVTManager.class);
    private static final int CACHE_BUFFER_SIZE = 1024 * Settings.settings.scene.renderer.virtualTextures.cacheSize;
    private static final int STATE_NOT_LOADED = 0;
    private static final int STATE_LOADING = 1;
    private static final int STATE_LOADED = 2;
    private static final int STATE_QUEUED = 3;
    private static final int STATE_CACHED = 4;
    private static int svtSequenceId = 1;
    private AssetManager manager;
    private final IntMap<Array<VirtualTextureComponent>> vtIdMap;
    private final Array<SVTQuadtreeNode<Path>> observedTiles = new Array(50);
    private final Map<String, Pixmap> tilePixmaps = new HashMap<String, Pixmap>();
    private final Deque<SVTQuadtreeNode<Path>> queuedTiles;
    private int tileSize = -1;
    private int cacheSizeInTiles = -1;
    private SVTQuadtreeNode<Path>[][] cacheBufferArray;
    private final Map<SVTQuadtreeNode<Path>, int[]> tileLocation = new HashMap<SVTQuadtreeNode<Path>, int[]>();
    private Texture cacheBuffer;
    private FloatBuffer floatBuffer;
    private boolean DEBUG_UI_VIEW = false;

    public static int nextSvtId() {
        return svtSequenceId++;
    }

    public SVTManager() {
        this.vtIdMap = new IntMap(30);
        this.queuedTiles = new ArrayDeque<SVTQuadtreeNode<Path>>(50);
    }

    public void doneLoading(AssetManager manager) {
        this.manager = manager;
        EventManager.instance.subscribe((IObserver)this, Event.SVT_MATERIAL_INFO);
    }

    public void updateObservedTiles(FloatBuffer tileDetectionBuffer) {
        this.observedTiles.clear();
        int size = tileDetectionBuffer.capacity() / 4;
        tileDetectionBuffer.rewind();
        for (int i = 0; i < size; ++i) {
            float level = tileDetectionBuffer.get();
            float x = tileDetectionBuffer.get();
            float y = tileDetectionBuffer.get();
            float id = tileDetectionBuffer.get();
            if (!(id > 0.0f) || !this.vtIdMap.containsKey((int)id)) continue;
            Array svts = (Array)this.vtIdMap.get((int)id);
            for (VirtualTextureComponent svt : svts) {
                this.observeSvt(svt, level, x, y);
            }
        }
        tileDetectionBuffer.clear();
        if (!this.observedTiles.isEmpty() && this.cacheBuffer == null) {
            PixmapTextureData cacheTextureData = new PixmapTextureData(new Pixmap(CACHE_BUFFER_SIZE, CACHE_BUFFER_SIZE, Pixmap.Format.RGBA8888), Pixmap.Format.RGBA8888, false, false, false);
            this.cacheBuffer = new Texture((TextureData)cacheTextureData);
            this.cacheBuffer.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            this.floatBuffer = BufferUtils.createFloatBuffer((int)4);
        }
        this.processObservedTiles();
    }

    private void observeSvt(VirtualTextureComponent svt, float level, float x, float y) {
        SVTQuadtreeNode<Path> tile;
        if (this.tileSize < 0) {
            this.tileSize = svt.tileSize;
            this.cacheSizeInTiles = CACHE_BUFFER_SIZE / this.tileSize;
            this.cacheBufferArray = new SVTQuadtreeNode[this.cacheSizeInTiles][this.cacheSizeInTiles];
        }
        if ((tile = svt.tree.getTile((int)level, (int)x, (int)y)) == null && level > 0.0f) {
            double[] uv = svt.tree.getUV((int)level, (int)x, (int)y);
            int l = (int)level;
            while ((tile = svt.tree.getTileFromUV(--l, uv[0], uv[1])) == null && l > 0) {
            }
        }
        if (tile != null && !this.observedTiles.contains(tile, true)) {
            this.observedTiles.add(tile);
        }
    }

    public void processObservedTiles() {
        SVTQuadtreeNode<Path> tile;
        long now = TimeUtils.millis();
        for (SVTQuadtreeNode tile2 : this.observedTiles) {
            String path = ((Path)tile2.object).toString();
            switch (tile2.state) {
                case 0: {
                    if (!this.manager.contains(path)) {
                        this.manager.load(path, Pixmap.class);
                        tile2.state = 1;
                        break;
                    }
                    if (tile2.state != 0) break;
                    tile2.state = 1;
                    break;
                }
                case 1: {
                    if (!this.manager.isLoaded(path)) break;
                    Pixmap pixmap = (Pixmap)this.manager.get(path);
                    if (pixmap.getWidth() != tile2.tree.tileSize) {
                        logger.warn("Rescaling tile: " + tile2.toStringShort());
                        Pixmap aux = new Pixmap(tile2.tree.tileSize, tile2.tree.tileSize, pixmap.getFormat());
                        aux.drawPixmap(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 0, 0, tile2.tree.tileSize, tile2.tree.tileSize);
                        this.manager.unload(path);
                        pixmap = aux;
                    }
                    this.tilePixmaps.put(path, pixmap);
                    this.queuedTiles.offerFirst(tile2);
                    tile2.state = 3;
                    break;
                }
                case 2: {
                    this.queuedTiles.offerFirst(tile2);
                    tile2.state = 3;
                    break;
                }
                case 3: 
                case 4: {
                    tile2.accessed = now;
                }
            }
        }
        int addedTiles = 0;
        int removedTiles = 0;
        SVTQuadtreeNode<Path> finalTile = null;
        block7: while ((tile = this.queuedTiles.poll()) != null && addedTiles < Settings.settings.scene.renderer.virtualTextures.maxTilesPerFrame) {
            finalTile = tile;
            if (tile.state != 3) continue;
            if (!this.tileLocation.containsKey(tile)) {
                if (this.tileLocation.size() < this.cacheSizeInTiles * this.cacheSizeInTiles) {
                    for (int j = 0; j < this.cacheSizeInTiles; ++j) {
                        for (int i = 0; i < this.cacheSizeInTiles; ++i) {
                            if (this.cacheBufferArray[i][j] != null) continue;
                            this.putTileInCache(tile, i, j, now);
                            ++addedTiles;
                            continue block7;
                        }
                    }
                    continue;
                }
                SVTQuadtreeNode<Path> lru = null;
                for (int j = 0; j < this.cacheSizeInTiles; ++j) {
                    for (int i = 0; i < this.cacheSizeInTiles; ++i) {
                        SVTQuadtreeNode<Path> candidate = this.cacheBufferArray[i][j];
                        if (candidate.level <= 0 || lru != null && candidate.accessed >= lru.accessed) continue;
                        lru = candidate;
                    }
                }
                if (lru == null) continue;
                int[] pair = this.tileLocation.get(lru);
                this.removeTileFromCache(lru);
                ++removedTiles;
                this.putTileInCache(tile, pair[0], pair[1], now);
                ++addedTiles;
                continue;
            }
            tile.state = 4;
        }
        if (addedTiles > 0) {
            logger.debug("Paged in " + addedTiles + " virtual tiles.");
        }
        if (removedTiles > 0) {
            logger.debug("Paged out " + removedTiles + " virtual tiles.");
        }
        if (this.DEBUG_UI_VIEW && (addedTiles > 0 || removedTiles > 0)) {
            SVTQuadtreeNode<Path> lastTile = finalTile;
            GaiaSky.postRunnable(() -> EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "SVT cache", this.cacheBuffer, Float.valueOf(0.05f)));
            this.DEBUG_UI_VIEW = false;
        }
    }

    private void putTileInCache(SVTQuadtreeNode<Path> tile, int i, int j, long now) {
        VirtualTextureComponent component;
        assert (!this.tileLocation.containsKey(tile)) : "Tile is already in the cache: " + String.valueOf(tile);
        this.tileLocation.put(tile, new int[]{i, j});
        this.cacheBufferArray[i][j] = tile;
        String path = ((Path)tile.object).toString();
        Pixmap pixmap = this.tilePixmaps.get(path);
        int x = i * tile.tree.tileSize;
        int y = j * tile.tree.tileSize;
        this.cacheBuffer.draw(pixmap, x, y);
        this.fillIndirectionBuffer(tile, i, j);
        tile.accessed = now;
        tile.state = 4;
        Object object = tile.tree.aux;
        if (object instanceof VirtualTextureComponent && !(component = (VirtualTextureComponent)object).svtAttributesSet()) {
            component.setSVTAttributes(this.cacheBuffer);
        }
        logger.debug("Tile added -> xy[" + x + "," + y + "] ij[" + i + "," + j + "]: " + String.valueOf(tile));
    }

    private void removeTileFromCache(SVTQuadtreeNode<Path> tile) {
        int[] pair = this.tileLocation.remove(tile);
        int i = pair[0];
        int j = pair[1];
        this.cacheBufferArray[i][j] = null;
        this.clearIndirectionBuffer(tile);
        tile.accessed = 0L;
        tile.state = 2;
        logger.debug("Tile removed -> ij[" + i + "," + j + "]: " + String.valueOf(tile));
    }

    private void clearIndirectionBuffer(SVTQuadtreeNode<Path> tile) {
        this.fillIndirectionTileWith(tile, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private void fillIndirectionBuffer(SVTQuadtreeNode<Path> tile, int cacheX, int cacheY) {
        float x = cacheX;
        float y = cacheY;
        this.fillIndirectionTileWith(tile, x, y, tile.level, 1.0f);
    }

    private void fillIndirectionTileWith(SVTQuadtreeNode<Path> tile, float r, float g, float b, float a) {
        this.floatBuffer.rewind();
        this.floatBuffer.put(0, r);
        this.floatBuffer.put(1, g);
        this.floatBuffer.put(2, b);
        this.floatBuffer.put(3, a);
        double[] tileUV = tile.getUV();
        int[] xy = tile.tree.getColRow(tile.level, tileUV[0], tileUV[1]);
        Object object = tile.tree.aux;
        if (object instanceof VirtualTextureComponent) {
            VirtualTextureComponent component = (VirtualTextureComponent)object;
            if (component.indirectionBuffer != null) {
                component.indirectionBuffer.draw(this.floatBuffer, xy[0], xy[1], 1, 1, tile.mipLevel(), 6408, 5126);
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.SVT_MATERIAL_INFO) {
            Integer id = (Integer)data[0];
            NamedComponent comp = (NamedComponent)data[1];
            if (comp instanceof MaterialComponent) {
                MaterialComponent mc = (MaterialComponent)comp;
                for (VirtualTextureComponent vtc : mc.svts) {
                    this.addToVTMap(id, vtc);
                }
            } else if (comp instanceof CloudComponent) {
                CloudComponent cc = (CloudComponent)comp;
                this.addToVTMap(id, cc.diffuseSvt);
            }
        }
    }

    private void addToVTMap(int id, VirtualTextureComponent component) {
        Array array;
        if (component == null) {
            return;
        }
        if (!this.vtIdMap.containsKey(id)) {
            this.vtIdMap.put(id, (Object)new Array());
        }
        if (!(array = (Array)this.vtIdMap.get(id)).contains((Object)component, true)) {
            array.add((Object)component);
        }
    }
}

