/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.svt;

import com.badlogic.gdx.utils.LongMap;
import gaiasky.util.svt.SVTQuadtreeNode;
import net.jafama.FastMath;

public class SVTQuadtree<T> {
    public final int MAX_LEVEL = 15;
    public final String name;
    public final int tileSize;
    public int numTiles;
    public int depth = 0;
    public SVTQuadtreeNode<T>[] root;
    public LongMap<SVTQuadtreeNode<T>>[] levels;
    public Object aux;

    public SVTQuadtree(String name, int tileSize, int rootPositions) {
        this.name = name;
        this.tileSize = tileSize;
        this.root = new SVTQuadtreeNode[rootPositions];
        this.levels = new LongMap[16];
    }

    public void insert(int level, int col, int row, T object) {
        assert (level >= 0 && level <= 15) : "Level out of bounds: " + level;
        assert (col >= 0 && row >= 0) : "Invalid UV: " + col + ", " + row;
        if (this.levels[level] == null) {
            this.levels[level] = new LongMap();
        }
        SVTQuadtreeNode<T> parent = null;
        if (level > 0) {
            double[] uv = this.getUV(level, col, row);
            parent = this.getTileFromUV(level - 1, uv[0], uv[1]);
        }
        SVTQuadtreeNode<T> tile = new SVTQuadtreeNode<T>(this, parent, level, col, row, object);
        this.levels[level].put(tile.getKey(), tile);
        ++this.numTiles;
    }

    public SVTQuadtreeNode<T> getTile(int level, int col, int row) {
        assert (level >= 0 && level <= 15) : "Level out of bounds: " + level;
        assert (col >= 0 && row >= 0) : "Invalid Col/Row: " + col + ", " + row;
        if (level > this.depth) {
            return null;
        }
        if (this.levels[level] == null) {
            return null;
        }
        return (SVTQuadtreeNode)this.levels[level].get(this.getKey(level, col, row));
    }

    public SVTQuadtreeNode<T> getTileFromUV(int level, double u, double v) {
        int[] pair = this.getColRow(level, u, v);
        return this.getTile(level, pair[0], pair[1]);
    }

    public long getUTileCount(int level) {
        return (long)this.root.length * (1L << level);
    }

    public long getVTileCount(int level) {
        if (level == 0) {
            return 1L;
        }
        return 2L << level - 1;
    }

    public int[] getColRow(int level, double u, double v) {
        return this.getColRow(level, u, v, new int[2]);
    }

    public int[] getColRow(int level, double u, double v, int[] colRow) {
        long vCount = this.getVTileCount(level);
        long uCount = vCount * (long)this.root.length;
        colRow[0] = (int)(u * (double)uCount);
        colRow[1] = (int)((double)vCount - v * (double)vCount);
        return colRow;
    }

    public double[] getUV(int level, int col, int row) {
        return this.getUV(level, col, row, new double[2]);
    }

    public double[] getUV(int level, int col, int row, double[] uv) {
        double vCount = this.getVTileCount(level);
        double uCount = vCount * (double)this.root.length;
        uv[0] = (double)col / uCount;
        uv[1] = (vCount - (double)row) / vCount;
        return uv;
    }

    public boolean contains(int level, int col, int row) {
        return this.levels[level] != null && this.levels[level].containsKey(this.getKey(level, col, row));
    }

    public long getKey(int level, int col, int row) {
        return (long)level << 45 | (long)col << 26 | (long)row;
    }

    public long getKey(SVTQuadtreeNode<T> tile) {
        return tile.getKey();
    }

    public int[] getResolution() {
        int tiles = (int)FastMath.pow((double)2.0, (double)this.depth);
        return new int[]{this.tileSize * tiles * this.root.length, this.tileSize * tiles};
    }
}

