/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.svt;

import gaiasky.util.Logger;
import gaiasky.util.comp.FilenameComparator;
import gaiasky.util.i18n.I18n;
import gaiasky.util.svt.SVTQuadtree;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public class SVTQuadtreeBuilder {
    private static final Logger.Log logger = Logger.getLogger(SVTQuadtreeBuilder.class);

    public SVTQuadtree<Path> build(String name, Path location, int tileSize) {
        Stream<Path> stream;
        FilenameComparator comp = new FilenameComparator();
        SVTQuadtree<Path> tree = new SVTQuadtree<Path>(name, tileSize, 2);
        long levels = 0L;
        try {
            stream = Files.list(location);
            try {
                levels = stream.filter(element -> element.getFileName().toString().matches("^(level)?0{1,2}$")).count();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            logger.error(e, "Error reading SVT level directories: " + String.valueOf(location));
        }
        if (levels != 1L) {
            logger.error("Can't initialize SVT without a level 0 directory: " + String.valueOf(location));
            return null;
        }
        logger.info(I18n.msg("notif.loading", "SVT quadtree: " + String.valueOf(location)));
        try {
            stream = Files.list(location);
            try {
                AtomicInteger depth = new AtomicInteger(0);
                stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(comp).forEach(directory -> {
                    String dirName = directory.getFileName().toString();
                    if (dirName.matches("^(level)?\\d{1,2}$")) {
                        int beginIndex = dirName.startsWith("level") ? 5 : 0;
                        int level = Integer.parseInt(dirName.substring(beginIndex));
                        logger.debug("visit: " + dirName + " (l" + level + ")");
                        try (Stream<Path> files = Files.list(directory);){
                            files.sorted(comp).forEach(file -> {
                                String fileName = file.getFileName().toString();
                                if (fileName.matches("tx[_\\-\\s.]\\d+[_\\-\\s.]\\d+\\.\\w+")) {
                                    String[] tokens = fileName.split("[_\\-\\s.]");
                                    int col = Integer.parseInt(tokens[1].trim());
                                    int row = Integer.parseInt(tokens[2].trim());
                                    logger.debug("l" + level + " -> col: " + col + " row: " + row);
                                    tree.insert(level, col, row, (Path)file);
                                    if (level > depth.get()) {
                                        depth.set(level);
                                    }
                                } else {
                                    logger.error("Wrong tile name format: " + fileName);
                                }
                            });
                        }
                        catch (IOException e) {
                            logger.error(e, "Error building SVT quadtree: " + String.valueOf(location));
                        }
                    } else {
                        logger.warn("Wrong directory name format, skipping: " + dirName);
                    }
                });
                tree.depth = depth.get();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e, "Error building SVT quadtree: " + String.valueOf(location));
            return null;
        }
        return tree;
    }
}

