/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.svt;

import gaiasky.scene.record.VirtualTextureComponent;
import gaiasky.util.svt.SVTQuadtree;

public class SVTQuadtreeNode<T>
implements Comparable<SVTQuadtreeNode> {
    public final SVTQuadtree<T> tree;
    public final SVTQuadtreeNode<T> parent;
    public final int level;
    public final int col;
    public final int row;
    public final T object;
    public int state = 0;
    public long accessed = 0L;

    public SVTQuadtreeNode(SVTQuadtree<T> tree, SVTQuadtreeNode<T> parent, int level, int col, int row, T object) {
        this.tree = tree;
        this.parent = parent;
        this.level = level;
        this.col = col;
        this.row = row;
        this.object = object;
    }

    public double[] getUV() {
        double numCols = this.tree.getUTileCount(this.level);
        double numRows = this.tree.getVTileCount(this.level);
        return new double[]{(double)this.col / numCols, 1.0 - (double)this.row / numRows};
    }

    public int mipLevel() {
        return this.tree.depth - this.level;
    }

    public String toString() {
        return "Node {L" + this.level + ", col=" + this.col + ", row=" + this.row + ", o=" + String.valueOf(this.object) + "}";
    }

    public String toStringShort() {
        return "id" + ((VirtualTextureComponent)this.tree.aux).id + "-L" + this.level + "[" + this.col + "," + this.row + "]";
    }

    @Override
    public int compareTo(SVTQuadtreeNode o) {
        return Integer.compare(this.level, o.level);
    }

    public long getKey() {
        return this.tree.getKey(this.level, this.col, this.row);
    }
}

