/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.time;

import com.badlogic.gdx.math.MathUtils;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.time.ITimeFrameProvider;
import java.time.Instant;
import java.util.Arrays;
import net.jafama.FastMath;

public class GlobalClock
implements IObserver,
ITimeFrameProvider {
    private static final Logger.Log logger = Logger.getLogger(GlobalClock.class);
    public Instant time;
    public float fps = -1.0f;
    long lastTime;
    private Instant targetTime;
    private double hDiff;
    private double dt;
    private double timeWarp;
    private float lastUpdate = 1.0f;
    public final int warpSteps = 49;
    private final double[] timeWarpVector;

    public GlobalClock(double timeWrap, Instant instant) {
        this.timeWarp = timeWrap;
        this.hDiff = 0.0;
        this.time = instant;
        this.targetTime = null;
        this.lastTime = this.time.toEpochMilli();
        this.timeWarpVector = this.generateTimeWarpVector(49);
        EventManager.instance.subscribe((IObserver)this, Event.TIME_WARP_CMD, Event.TIME_WARP_DECREASE_CMD, Event.TIME_WARP_INCREASE_CMD, Event.TIME_CHANGE_CMD, Event.TARGET_TIME_CMD);
    }

    public double[] generateTimeWarpVector() {
        return this.generateTimeWarpVector(49);
    }

    public double[] generateTimeWarpVector(int steps) {
        int i;
        double[] warp = new double[steps * 2 + 1];
        warp[steps] = 0.0;
        double w = 0.0;
        for (i = steps + 1; i < warp.length; ++i) {
            warp[i] = this.increaseWarp(w);
            w = warp[i];
        }
        w = 0.0;
        for (i = steps - 1; i >= 0; --i) {
            warp[i] = this.decreaseWarp(w);
            w = warp[i];
        }
        return warp;
    }

    private double increaseWarp(double timeWarp) {
        if (timeWarp == 0.0) {
            return 0.125;
        }
        if (timeWarp == -0.125) {
            return 0.0;
        }
        if (timeWarp < 0.0) {
            return timeWarp / 2.0;
        }
        return timeWarp * 2.0;
    }

    private double decreaseWarp(double timeWarp) {
        if (timeWarp == 0.125) {
            return 0.0;
        }
        if (timeWarp == 0.0) {
            return -0.125;
        }
        if (timeWarp < 0.0) {
            return timeWarp * 2.0;
        }
        return timeWarp / 2.0;
    }

    @Override
    public void update(double dt) {
        this.dt = dt;
        Settings settings = Settings.settings;
        double d = dt = settings.runtime.timeOn ? this.dt : 0.0;
        if (dt != 0.0) {
            long currentTime;
            if (this.fps > 0.0f) {
                dt = 1.0f / this.fps;
            }
            int sign = (int)FastMath.signum((double)this.timeWarp);
            double h = FastMath.abs((double)(dt * this.timeWarp * 2.777777777777778E-4));
            this.hDiff = h * (double)sign;
            double ms = (double)sign * h * 3600000.0;
            this.lastTime = currentTime = this.time.toEpochMilli();
            long newTime = currentTime + (long)ms;
            if (this.targetTime != null) {
                long target = this.targetTime.toEpochMilli();
                if (this.timeWarp > 0.0 && currentTime <= target && newTime > target || this.timeWarp < 0.0 && currentTime >= target && newTime < target) {
                    newTime = target;
                    this.targetTime = null;
                    this.setTimeWarp(0.0);
                }
            }
            if (newTime > settings.runtime.maxTimeMs) {
                if (currentTime < settings.runtime.maxTimeMs) {
                    logger.info("Maximum time reached (" + (double)settings.runtime.maxTimeMs * 3.168808781402895E-11 + " years)!");
                    EventManager.publish(Event.TIME_STATE_CMD, this, false);
                }
                newTime = settings.runtime.maxTimeMs;
                this.time = Instant.ofEpochMilli(newTime);
                EventManager.publish(Event.TIME_CHANGE_INFO, this, this.time);
                this.lastUpdate = 0.0f;
            } else if (newTime < settings.runtime.minTimeMs) {
                if (currentTime > settings.runtime.minTimeMs) {
                    logger.info("Minimum time reached (" + (double)settings.runtime.minTimeMs * 3.168808781402895E-11 + " years)!");
                    EventManager.publish(Event.TIME_STATE_CMD, this, false);
                }
                newTime = settings.runtime.minTimeMs;
                this.time = Instant.ofEpochMilli(newTime);
                EventManager.publish(Event.TIME_CHANGE_INFO, this, this.time);
                this.lastUpdate = 0.0f;
            } else {
                this.time = Instant.ofEpochMilli(newTime);
            }
            this.lastUpdate = (float)((double)this.lastUpdate + dt);
            if ((double)this.lastUpdate > 0.5) {
                EventManager.publish(Event.TIME_CHANGE_INFO, this, this.time);
                this.lastUpdate = 0.0f;
            }
        } else if (this.time.toEpochMilli() - this.lastTime != 0L) {
            this.hDiff = (double)(this.time.toEpochMilli() - this.lastTime) * 2.7777777777777776E-7;
            this.lastTime = this.time.toEpochMilli();
        } else {
            this.hDiff = 0.0;
        }
    }

    @Override
    public Instant getTime() {
        return this.time;
    }

    @Override
    public double getTimeSeconds() {
        return (double)this.time.toEpochMilli() / 1000.0;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case TARGET_TIME_CMD: {
                if (data.length > 0) {
                    this.targetTime = (Instant)data[0];
                    break;
                }
                this.targetTime = null;
                break;
            }
            case TIME_WARP_CMD: {
                this.setTimeWarp((Double)data[0]);
                break;
            }
            case TIME_WARP_INCREASE_CMD: {
                double tw = this.findNearestWarpSnapValue(this.timeWarp, 1.0);
                this.setTimeWarp(tw);
                break;
            }
            case TIME_WARP_DECREASE_CMD: {
                double tw = this.findNearestWarpSnapValue(this.timeWarp, -1.0);
                this.setTimeWarp(tw);
                break;
            }
            case TIME_CHANGE_CMD: {
                Instant newinstant = (Instant)data[0];
                long newt = newinstant.toEpochMilli();
                boolean updt = false;
                Settings settings = Settings.settings;
                if (newt > settings.runtime.maxTimeMs) {
                    newt = settings.runtime.maxTimeMs;
                    logger.info("Time overflow, set to maximum (" + (double)settings.runtime.maxTimeMs * 3.168808781402895E-11 + " years)");
                    updt = true;
                }
                if (newt < settings.runtime.minTimeMs) {
                    newt = settings.runtime.minTimeMs;
                    logger.info("Time overflow, set to minimum (" + (double)settings.runtime.minTimeMs * 3.168808781402895E-11 + " years)");
                    updt = true;
                }
                if (updt) {
                    this.time = Instant.ofEpochMilli(newt);
                    break;
                }
                this.time = newinstant;
                break;
            }
        }
    }

    public double findNearestWarpSnapValue(double value, double dir) {
        double v;
        int idx = Arrays.binarySearch(this.timeWarpVector, value);
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (value == (v = this.timeWarpVector[idx = MathUtils.clamp((int)idx, (int)0, (int)(this.timeWarpVector.length - 1))])) {
            return dir > 0.0 ? this.timeWarpVector[Math.min(this.timeWarpVector.length - 1, idx + 1)] : this.timeWarpVector[Math.max(0, idx - 1)];
        }
        return dir < 0.0 ? this.timeWarpVector[Math.max(0, idx - 1)] : this.timeWarpVector[idx];
    }

    public double nearestPowerOf2(double n, double dir) {
        if (n == 1.0 && dir < 0.0) {
            return 0.5;
        }
        if (n == -1.0 && dir > 0.0) {
            return -0.5;
        }
        long a = (int)(Math.log(n) / FastMath.log((double)2.0));
        return (long)FastMath.pow((double)2.0, (double)((double)a + dir));
    }

    public void setTimeWarp(double tw) {
        this.timeWarp = tw;
        this.checkTimeWarpValue();
        EventManager.publish(Event.TIME_WARP_CHANGED_INFO, this, this.timeWarp);
    }

    private void checkTimeWarpValue() {
        if (this.timeWarp > Constants.MAX_WARP) {
            this.timeWarp = Constants.MAX_WARP;
        }
        if (this.timeWarp < Constants.MIN_WARP) {
            this.timeWarp = Constants.MIN_WARP;
        }
    }

    @Override
    public double getHdiff() {
        return this.hDiff;
    }

    @Override
    public double getDt() {
        return this.dt;
    }

    @Override
    public double getWarpFactor() {
        return this.timeWarp;
    }

    @Override
    public boolean isFixedRateMode() {
        return this.fps > 0.0f;
    }

    @Override
    public float getFixedRate() {
        return this.fps;
    }

    @Override
    public boolean isTimeOn() {
        return this.timeWarp != 0.0;
    }
}

