/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.time;

import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.util.time.ITimeFrameProvider;
import java.time.Instant;

public class RealTimeClock
implements ITimeFrameProvider {
    private static final double SEC_TO_HOUR = 2.777777777777778E-4;
    private double dt;
    private long time = Instant.now().toEpochMilli();
    private double lastUpdate = 0.0;

    @Override
    public double getHdiff() {
        return 2.777777777777778E-4;
    }

    @Override
    public double getDt() {
        return this.dt;
    }

    @Override
    public Instant getTime() {
        return Instant.ofEpochMilli(this.time);
    }

    @Override
    public double getTimeSeconds() {
        return (double)this.time / 1000.0;
    }

    @Override
    public void update(double dt) {
        this.dt = dt;
        this.time = TimeUtils.millis();
        this.lastUpdate += dt;
        if (this.lastUpdate > 0.5) {
            EventManager.publish(Event.TIME_CHANGE_INFO, this, this.time);
            this.lastUpdate = 0.0;
        }
    }

    @Override
    public double getWarpFactor() {
        return 2.777777777777778E-4;
    }

    @Override
    public boolean isFixedRateMode() {
        return false;
    }

    @Override
    public float getFixedRate() {
        return -1.0f;
    }

    @Override
    public boolean isTimeOn() {
        return true;
    }
}

