/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.tree;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import gaiasky.data.api.IOctantLoader;
import gaiasky.render.ComponentTypes;
import gaiasky.render.api.ILineRenderable;
import gaiasky.render.system.LineRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.view.OctreeObjectView;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.parse.Parser;
import gaiasky.util.tree.IOctreeObject;
import gaiasky.util.tree.LoadStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.jafama.FastMath;

public class OctreeNode
implements ILineRenderable {
    private static final Vector3D auxD1 = new Vector3D();
    private static final Vector3D auxD2 = new Vector3D();
    private static final Vector3D auxD3 = new Vector3D();
    private static final Vector3D auxD4 = new Vector3D();
    public static int nOctantsObserved = 0;
    public static int nObjectsObserved = 0;
    public static int maxDepth;
    public final Vector3D min;
    public final Vector3D max;
    public final Vector3D centre;
    public final Vector3D size;
    public final int depth;
    private final double radius;
    public long pageId;
    public int numObjectsRec;
    public int numObjects;
    public int numChildrenRec;
    public int numChildren;
    public OctreeNode parent;
    public OctreeNode[] children = new OctreeNode[8];
    public List<IOctreeObject> objects;
    public IOctantLoader loader;
    public double viewAngle;
    public double distToCamera;
    public boolean observed;
    public float opacity;
    ComponentTypes ct = new ComponentTypes(ComponentTypes.ComponentType.Others);
    Color col = new Color();
    private LoadStatus status;

    private OctreeNode(double x, double y, double z, double hsx, double hsy, double hsz, int depth) {
        this.min = new Vector3D(x - hsx, y - hsy, z - hsz);
        this.max = new Vector3D(x + hsx, y + hsy, z + hsz);
        this.centre = new Vector3D(x, y, z);
        this.size = new Vector3D(hsx * 2.0, hsy * 2.0, hsz * 2.0);
        this.depth = depth;
        this.observed = false;
        this.status = LoadStatus.NOT_LOADED;
        this.radius = FastMath.sqrt((double)(hsx * hsx + hsy * hsy + hsz * hsz));
    }

    public OctreeNode(long pageId, double x, double y, double z, double hsx, double hsy, double hsz, int depth) {
        this.pageId = pageId;
        this.min = new Vector3D(x - hsx, y - hsy, z - hsz);
        this.max = new Vector3D(x + hsx, y + hsy, z + hsz);
        this.centre = new Vector3D(x, y, z);
        this.size = new Vector3D(hsx * 2.0, hsy * 2.0, hsz * 2.0);
        this.depth = depth;
        this.observed = false;
        this.status = LoadStatus.NOT_LOADED;
        this.radius = FastMath.sqrt((double)(hsx * hsx + hsy * hsy + hsz * hsz));
    }

    public OctreeNode(double x, double y, double z, double hsx, double hsy, double hsz, int depth, OctreeNode parent, int i) {
        this(x, y, z, hsx, hsy, hsz, depth);
        this.parent = parent;
        parent.children[i] = this;
        this.pageId = this.computePageId();
    }

    public OctreeNode(double x, double y, double z, double hsx, double hsy, double hsz, int childrenCount, int nObjects, int ownObjects, int depth) {
        this(x, y, z, hsx, hsy, hsz, depth);
        this.numChildren = childrenCount;
        this.numObjectsRec = nObjects;
        this.numObjects = ownObjects;
    }

    public OctreeNode(long pageid, double x, double y, double z, double hsx, double hsy, double hsz, int childrenCount, int nObjects, int ownObjects, int depth) {
        this(pageid, x, y, z, hsx, hsy, hsz, depth);
        this.numChildren = childrenCount;
        this.numObjectsRec = nObjects;
        this.numObjects = ownObjects;
    }

    public static long hash(double x, double y, double z) {
        long result = 3L;
        result = result * 31L + OctreeNode.hash(x);
        result = result * 31L + OctreeNode.hash(y);
        result = result * 31L + OctreeNode.hash(z);
        return result;
    }

    public static long hash(double value) {
        long bits = Double.doubleToLongBits(value);
        return bits ^ bits >>> 32;
    }

    public long computePageId() {
        StringBuilder id = new StringBuilder();
        this.computePageIdRec(id);
        return Parser.parseLong(id.toString());
    }

    protected void computePageIdRec(StringBuilder id) {
        if (this.depth == 0) {
            return;
        }
        if (this.parent != null) {
            this.parent.computePageIdRec(id);
            id.append(this.getParentIndex() + 1);
        }
    }

    protected int getParentIndex() {
        if (this.parent != null) {
            for (int i = 0; i < 8; ++i) {
                if (this.parent.children[i] != this) continue;
                return i;
            }
        }
        return 0;
    }

    public boolean containsObject(IOctreeObject object) {
        boolean has = this.objects.contains(object);
        if (!has && this.children != null && this.numChildren > 0) {
            for (OctreeNode child : this.children) {
                if (child == null || !this.containsObject(object)) continue;
                return true;
            }
        }
        return has;
    }

    public void resolveChildren(Map<Long, Pair<OctreeNode, long[]>> map) {
        Pair<OctreeNode, long[]> me = map.get(this.pageId);
        if (me == null) {
            throw new RuntimeException("OctreeNode with page ID " + this.pageId + " not found in map.");
        }
        long[] childrenIds = me.getSecond();
        int i = 0;
        for (long childId : childrenIds) {
            if (childId != -1L) {
                OctreeNode child;
                this.children[i] = child = map.get(childId).getFirst();
                child.parent = this;
            }
            ++i;
        }
        for (OctreeNode child : this.children) {
            if (child == null) continue;
            child.resolveChildren(map);
        }
    }

    @Override
    public float getOpacity() {
        return this.opacity;
    }

    public boolean add(IOctreeObject e) {
        if (this.objects == null) {
            this.objects = new ArrayList<IOctreeObject>(1);
        }
        this.objects.add(e);
        this.numObjects = this.objects.size();
        if (e instanceof OctreeObjectView) {
            Entity entity = ((OctreeObjectView)e).getEntity();
            if (Mapper.starSet.has(entity)) {
                this.numObjects = this.objects.size() - 1 + ((StarSet)Mapper.starSet.get(entity)).data().size();
            } else if (Mapper.particleSet.has(entity)) {
                this.numObjects = this.objects.size() - 1 + ((ParticleSet)Mapper.particleSet.get(entity)).data().size();
            }
        }
        return true;
    }

    public boolean addAll(List<IOctreeObject> l) {
        if (this.objects == null) {
            this.objects = new ArrayList<IOctreeObject>(l.size());
        }
        this.objects.addAll(l);
        this.numObjects = this.objects.size();
        return true;
    }

    public void setObjects(List<IOctreeObject> l) {
        this.objects = l;
        this.numObjects = this.objects.size();
    }

    public boolean insert(IOctreeObject e, int level) {
        int node = 0;
        if (e.getPosition().y.doubleValue() > this.min.y + (this.max.y - this.min.y) / 2.0) {
            node += 4;
        }
        if (e.getPosition().z.doubleValue() > this.min.z + (this.max.z - this.min.z) / 2.0) {
            node += 2;
        }
        if (e.getPosition().x.doubleValue() > this.min.x + (this.max.x - this.min.x) / 2.0) {
            ++node;
        }
        if (level == this.depth + 1) {
            return this.children[node].add(e);
        }
        return this.children[node].insert(e, level);
    }

    public void toTree(TreeSet<IOctreeObject> tree) {
        tree.addAll(this.objects);
        if (this.children != null) {
            for (int i = 0; i < 8; ++i) {
                this.children[i].toTree(tree);
            }
        }
    }

    public void addChildrenToList(ArrayList<OctreeNode> list) {
        if (this.children != null) {
            for (int i = 0; i < 8; ++i) {
                if (this.children[i] == null) continue;
                list.add(this.children[i]);
                this.children[i].addChildrenToList(list);
            }
        }
    }

    public void addParticlesTo(Array<IOctreeObject> particles) {
        if (this.objects != null) {
            for (IOctreeObject elem : this.objects) {
                particles.add((Object)elem);
            }
        }
        for (int i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            this.children[i].addParticlesTo(particles);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean rec) {
        StringBuilder str = new StringBuilder(this.depth);
        if (rec) {
            str.append("  ".repeat(Math.max(0, this.depth)));
        }
        int idx = this.parent != null ? Arrays.asList(this.parent.children).indexOf(this) : 0;
        str.append(idx).append(":L").append(this.depth).append(" ");
        str.append("id:").append(this.pageId);
        str.append(" Obj(own/rec):(").append(this.numObjects).append("/").append(this.numObjectsRec).append(")");
        str.append(" Nchld:").append(this.numChildren).append("\n");
        if (this.numChildren > 0 && rec) {
            for (OctreeNode child : this.children) {
                if (child == null) continue;
                str.append(child.toString(true));
            }
        }
        return str.toString();
    }

    public int[][] stats() {
        int[][] result = new int[this.getMaxDepth()][2];
        this.statsRec(result);
        return result;
    }

    private void statsRec(int[][] mat) {
        int[] nArray = mat[this.depth];
        nArray[0] = nArray[0] + 1;
        int[] nArray2 = mat[this.depth];
        nArray2[1] = nArray2[1] + this.numObjects;
        for (OctreeNode child : this.children) {
            if (child == null) continue;
            child.statsRec(mat);
        }
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public void removeChild(OctreeNode child) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null || this.children[i] != child) continue;
                child.parent = null;
                this.children[i] = null;
            }
        }
    }

    public int numChildren() {
        int num = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            ++num;
        }
        return num;
    }

    public int numNodesRec() {
        int numNodes = 1;
        for (int i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            numNodes += this.children[i].numNodesRec();
        }
        return numNodes;
    }

    @Override
    public ComponentTypes getComponentType() {
        return this.ct;
    }

    @Override
    public double getDistToCamera() {
        return 0.0;
    }

    public boolean contains(double x, double y, double z) {
        return this.min.x <= x && this.max.x >= x && this.min.y <= y && this.max.y >= y && this.min.z <= z && this.max.z >= z;
    }

    public boolean contains(Vector3D v) {
        return this.min.x <= v.x && this.max.x >= v.x && this.min.y <= v.y && this.max.y >= v.y && this.min.z <= v.z && this.max.z >= v.z;
    }

    public OctreeNode getBestOctant(Vector3D position) {
        if (!this.contains(position)) {
            return null;
        }
        OctreeNode candidate = null;
        for (int i = 0; i < 8; ++i) {
            OctreeNode child = this.children[i];
            if (child == null || (candidate = child.getBestOctant(position)) == null) continue;
            return candidate;
        }
        return this;
    }

    public int getMaxDepth() {
        int maxChildrenDepth = 0;
        if (this.children != null) {
            for (OctreeNode child : this.children) {
                int d;
                if (child == null || (d = child.getMaxDepth()) <= maxChildrenDepth) continue;
                maxChildrenDepth = d;
            }
        }
        return maxChildrenDepth + 1;
    }

    public void update(Vector3Q parentTransform, ICamera cam, List<IOctreeObject> roulette, float opacity, boolean updateNumLabels) {
        this.opacity = opacity;
        this.observed = false;
        this.distToCamera = auxD1.set(this.centre).add(cam.getInversePos()).len();
        this.viewAngle = FastMath.atan((double)(this.radius / this.distToCamera)) * 2.0;
        float cf = MathUtilsDouble.clamp(cam.getFovFactor() * 2.5f, 0.15f, 1.0f);
        float th0 = Settings.settings.scene.octree.threshold[0] * cf;
        float th1 = Settings.settings.scene.octree.threshold[1] * cf;
        boolean isCameraFocus = this.hasFocusObject(cam);
        if (this.viewAngle < (double)th0 && !isCameraFocus) {
            this.setChildrenObserved(false);
        } else {
            this.observed = this.computeObserved(cam);
            if (this.observed || isCameraFocus) {
                ++nOctantsObserved;
                if (this.status == LoadStatus.NOT_LOADED && Settings.settings.runtime.octreeLoadActive) {
                    assert (this.loader != null) : "Octant loader is null!";
                    this.loader.queue(this);
                } else if (this.status == LoadStatus.LOADED) {
                    assert (this.loader != null) : "Octant loader is null!";
                    this.loader.touch(this);
                    this.addObjectsTo(roulette);
                    if (updateNumLabels) {
                        this.updateNumberLabels(th0);
                    }
                }
                double alpha = 1.0;
                if (Settings.settings.scene.octree.fade && this.viewAngle < (double)th1) {
                    alpha = MathUtilsDouble.clamp(MathUtilsDouble.flint(this.viewAngle, th0, th1, 0.0, 1.0), 0.0, 1.0);
                }
                this.opacity *= (float)alpha;
                for (int i = 0; i < 8; ++i) {
                    OctreeNode child = this.children[i];
                    if (child == null) continue;
                    child.update(parentTransform, cam, roulette, this.opacity, updateNumLabels);
                }
            }
        }
    }

    private boolean hasFocusObject(ICamera camera) {
        return this.objects != null && this.objects.stream().anyMatch(o -> camera.isFocus(((OctreeObjectView)o).getEntity()));
    }

    private void addObjectsTo(List<IOctreeObject> roulette) {
        if (this.objects != null) {
            roulette.addAll(this.objects);
            for (IOctreeObject obj : this.objects) {
                nObjectsObserved += obj.getStarCount();
            }
        }
    }

    private void updateNumberLabels(double threshold) {
        if (this.objects != null) {
            double octantFactor = 0.0;
            if ((double)this.opacity > 0.0 && this.viewAngle > threshold) {
                octantFactor = MathUtilsDouble.flint(this.viewAngle, threshold, 2.9, 0.0, 0.6);
            }
            int newNumLabels = (int)((double)Settings.settings.scene.star.group.numLabels * octantFactor);
            int newNumBillboard = (int)((double)Settings.settings.scene.star.group.numBillboard * octantFactor);
            for (IOctreeObject obj : this.objects) {
                if (!(obj instanceof OctreeObjectView)) continue;
                OctreeObjectView oov = (OctreeObjectView)obj;
                if (oov.set == null) continue;
                oov.set.numLabels = newNumLabels;
                oov.set.numBillboards = newNumBillboard;
            }
        }
    }

    private void setChildrenObserved(boolean observed) {
        for (int i = 0; i < 8; ++i) {
            OctreeNode child = this.children[i];
            if (child == null) continue;
            child.observed = observed;
        }
    }

    public boolean isObserved() {
        return this.observed && (this.parent == null || this.parent.isObserved());
    }

    private boolean computeObserved(ICamera cam) {
        return this.computeObservedFast(cam);
    }

    private boolean computeObservedFast(ICamera cam) {
        Vector3D camPosBox = auxD1.set(this.centre).sub(cam.getPos());
        Vector3D axis = auxD2.set(cam.getDirection()).crs(this.centre);
        Vector3D edge = auxD3.set(cam.getDirection()).rotate(axis, (double)cam.getCamera().fieldOfView / 2.0);
        double angle1 = FastMath.toDegrees((double)FastMath.atan((double)(this.radius / camPosBox.len())));
        double angle2 = edge.angle(camPosBox);
        return this.distToCamera <= this.radius || angle2 < angle1;
    }

    public LoadStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(LoadStatus status) {
        OctreeNode octreeNode = this;
        synchronized (octreeNode) {
            this.status = status;
        }
    }

    public void setStatus(LoadStatus status, int depth) {
        if (depth >= this.depth) {
            this.setStatus(status);
            for (int i = 0; i < 8; ++i) {
                OctreeNode child = this.children[i];
                if (child == null) continue;
                child.setStatus(status, depth);
            }
        }
    }

    public synchronized void updateCountsWithNumber(int n) {
        if (this.status == LoadStatus.NOT_LOADED) {
            this.numObjects = 0;
            this.numObjectsRec = 0;
            if (this.parent != null) {
                --this.parent.numChildren;
                this.parent.updateCountsWithNumberRecursive(-n);
            }
        } else if (this.status == LoadStatus.LOADED) {
            this.numObjects = n;
            this.numObjectsRec = n;
            if (this.parent != null) {
                ++this.parent.numChildren;
                this.parent.updateCountsWithNumberRecursive(n);
            }
        }
    }

    private synchronized void updateCountsWithNumberRecursive(int n) {
        this.numObjectsRec += n;
        if (this.parent != null) {
            this.parent.updateCountsWithNumberRecursive(n);
        }
    }

    public void updateCounts() {
        this.numObjects = 0;
        if (this.objects != null) {
            for (IOctreeObject ape : this.objects) {
                this.numObjects += ape.getStarCount();
            }
        }
        this.numObjectsRec = this.numObjects;
        this.numChildren = 0;
        this.numChildrenRec = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            ++this.numChildren;
            this.children[i].updateCounts();
            this.numObjectsRec += this.children[i].numObjectsRec;
            this.numChildrenRec += 1 + this.children[i].numChildrenRec;
        }
    }

    public int countObjects() {
        int n = 0;
        if (this.objects != null) {
            for (IOctreeObject obj : this.objects) {
                n += obj.getStarCount();
            }
        }
        if (this.children != null) {
            for (OctreeNode child : this.children) {
                if (child == null) continue;
                n += child.countObjects();
            }
        }
        return n;
    }

    public OctreeNode findOctant(long id) {
        if (this.pageId == id) {
            return this;
        }
        if (this.children != null) {
            OctreeNode target = null;
            for (OctreeNode child : this.children) {
                if (child == null || (target = child.findOctant(id)) == null) continue;
                return target;
            }
        }
        return null;
    }

    public OctreeNode getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public void render(LineRenderSystem sr, ICamera camera, float alpha) {
        if (this.observed) {
            this.col.set(ColorUtils.gGreenC);
        } else {
            this.col.set(ColorUtils.gYellowC);
        }
        this.col.a = alpha * this.opacity;
        if (this.col.a > 0.0f) {
            Vector3D loc = auxD4;
            loc.set(this.min).add(camera.getInversePos());
            this.line(sr, loc.x, loc.y, loc.z, loc.x + this.size.x, loc.y, loc.z, this.col);
            this.line(sr, loc.x, loc.y, loc.z, loc.x, loc.y + this.size.y, loc.z, this.col);
            this.line(sr, loc.x, loc.y, loc.z, loc.x, loc.y, loc.z + this.size.z, this.col);
            this.line(sr, loc.x + this.size.x, loc.y, loc.z, loc.x + this.size.x, loc.y + this.size.y, loc.z, this.col);
            this.line(sr, loc.x + this.size.x, loc.y, loc.z, loc.x + this.size.x, loc.y, loc.z + this.size.z, this.col);
            this.line(sr, loc.x + this.size.x, loc.y, loc.z + this.size.z, loc.x, loc.y, loc.z + this.size.z, this.col);
            this.line(sr, loc.x + this.size.x, loc.y, loc.z + this.size.z, loc.x + this.size.x, loc.y + this.size.y, loc.z + this.size.z, this.col);
            this.line(sr, loc.x, loc.y, loc.z + this.size.z, loc.x, loc.y + this.size.y, loc.z + this.size.z, this.col);
            this.line(sr, loc.x, loc.y + this.size.y, loc.z, loc.x + this.size.x, loc.y + this.size.y, loc.z, this.col);
            this.line(sr, loc.x, loc.y + this.size.y, loc.z, loc.x, loc.y + this.size.y, loc.z + this.size.z, this.col);
            this.line(sr, loc.x, loc.y + this.size.y, loc.z + this.size.z, loc.x + this.size.x, loc.y + this.size.y, loc.z + this.size.z, this.col);
            this.line(sr, loc.x + this.size.x, loc.y + this.size.y, loc.z, loc.x + this.size.x, loc.y + this.size.y, loc.z + this.size.z, this.col);
        }
    }

    private void line(LineRenderSystem sr, double x1, double y1, double z1, double x2, double y2, double z2, Color col) {
        sr.addLine(this, (float)x1, (float)y1, (float)z1, (float)x2, (float)y2, (float)z2, col);
    }

    public void dispose() {
        if (this.objects != null) {
            for (IOctreeObject object : this.objects) {
                if (object == null) continue;
                object.dispose();
            }
        }
        if (this.children != null) {
            for (OctreeNode child : this.children) {
                if (child == null) continue;
                child.dispose();
            }
        }
    }

    @Override
    public float getLineWidth() {
        return 1.0f;
    }

    @Override
    public int getGlPrimitive() {
        return 3;
    }

    public void setOctantLoader(IOctantLoader loader, boolean recursive) {
        this.loader = loader;
        if (recursive && this.children != null) {
            for (OctreeNode child : this.children) {
                if (child == null) continue;
                child.setOctantLoader(loader, true);
            }
        }
    }

    public void setOctantLoader(IOctantLoader loader) {
        this.setOctantLoader(loader, false);
    }
}

