/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.ucd;

import java.util.Locale;

public class UCD
implements Comparable<UCD> {
    public String originalUCD;
    public String converted;
    public String colName;
    public String unit;
    public String[][] UCD;
    public String[] UCDStrings;
    public UCDType type;
    public int index;

    public UCD(String originalUCD, String colName, String unit, int index) {
        this.index = index;
        this.colName = colName;
        this.unit = unit;
        if (originalUCD != null && !originalUCD.isEmpty()) {
            this.originalUCD = originalUCD;
            this.converted = originalUCD.toLowerCase(Locale.ROOT).replace("_", ".");
            this.UCDStrings = this.converted.split(";");
            this.UCD = new String[this.UCDStrings.length][];
            for (int i = 0; i < this.UCDStrings.length; ++i) {
                String singleUCD = this.UCDStrings[i];
                String[] sSplit = singleUCD.split("\\.");
                this.UCD[i] = sSplit;
            }
            String currType = this.UCD[0][0];
            try {
                this.type = UCDType.valueOf(currType.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.type = UCDType.UNKNOWN;
            }
        } else {
            this.type = UCDType.MISSING;
        }
    }

    public String toString() {
        return this.colName + (String)(this.originalUCD == null ? "" : " - " + this.originalUCD);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UCD ucd = (UCD)o;
        return this.index == ucd.index && this.originalUCD.equals(ucd.originalUCD) && this.colName.equals(ucd.colName) && this.unit.equals(ucd.unit);
    }

    @Override
    public int compareTo(UCD ucd) {
        return this.colName.compareTo(ucd.colName);
    }

    public static enum UCDType {
        POS,
        PHOT,
        STAT,
        PHYS,
        META,
        ARITH,
        EM,
        OBS,
        SPECT,
        SRC,
        TIME,
        INSTR,
        VARI,
        UNKNOWN,
        MISSING;

    }
}

