/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.ucd;

import com.badlogic.gdx.utils.Array;
import gaiasky.util.TextUtils;
import gaiasky.util.ucd.UCD;
import gaiasky.util.units.Position;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;

public class UCDParser {
    public static String[] idColNames = new String[]{"hip", "id", "source_id", "tycho2_id", "identifier"};
    public static String[] nameColNames = new String[]{"(name|NAME|refname|REFNAME)((_|-)[\\w\\d]+)?", "name", "names", "proper", "proper_name", "common_name", "designation"};
    public static String[] raColNames = new String[]{"ra", "right_ascension", "rightascension", "alpha", "raj2000"};
    public static String[] xColNames = new String[]{"x", "X"};
    public static String[] deColNames = new String[]{"dec", "de", "declination", "delta", "dej2000"};
    public static String[] yColNames = new String[]{"y", "Y"};
    public static String[] distColNames = new String[]{"dist", "distance"};
    public static String[] zColNames = new String[]{"z", "Z"};
    public static String[] parallaxColNames = new String[]{"plx", "parallax", "pllx", "par"};
    public static String[] magColNames = new String[]{"phot_g_mean_mag", "mag", "g_mag", "bmag", "gmag"};
    public static String[] colorColNames = new String[]{"b_v", "v_i", "bp_rp", "bp_g", "g_rp", "ci"};
    public static String[] tEffColNames = new String[]{"teff", "t_eff", "temperature", "effective_temperature"};
    public static String[] pmRaColNames = new String[]{"pmra", "pmalpha", "pm_ra", "mualpha"};
    public static String[] pmDecColNames = new String[]{"pmdec", "pmdelta", "pm_dec", "pm_de", "mudelta"};
    public static String[] radVelColNames = new String[]{"radial_velocity", "radvel", "rv", "dr2_radial_velocity"};
    public static String[] radiusColNames = new String[]{"radius", "rcluster", "radi", "core_radius", "tidal_radius", "total_radius"};
    public static String[] sizeColNames = new String[]{"diameter", "size", "linear_diameter"};
    public static String[] nStarsColNames = new String[]{"n", "nstars", "n_stars", "n_star"};
    public static String[] variMagsColNames = new String[]{"g_transit_mag", "g_mag_list", "g_mag_series"};
    public static String[] variTimesColNames = new String[]{"g_transit_time", "time_list", "time_series"};
    public static String[] periodColNames = new String[]{"pf", "period"};
    public Map<UCD.UCDType, Array<UCD>> ucdmap = new HashMap<UCD.UCDType, Array<UCD>>();
    public boolean hasId = false;
    public Array<UCD> ID = new Array();
    public boolean hasName = false;
    public Array<UCD> NAME = new Array();
    public boolean hasPos = false;
    public Array<UCD> POS1 = new Array();
    public Array<UCD> POS2 = new Array();
    public Array<UCD> POS3 = new Array();
    public boolean hasPm = false;
    public Array<UCD> PMRA;
    public Array<UCD> PMDEC;
    public Array<UCD> RADVEL;
    public boolean hasMag = false;
    public Array<UCD> MAG = new Array();
    public boolean hasColor = false;
    public Array<UCD> COL = new Array();
    public boolean hasSize = false;
    public Array<UCD> SIZE;
    public boolean hasTEff = false;
    public Array<UCD> TEFF;
    public boolean hasVariability = false;
    public boolean hasPeriod = false;
    public Array<UCD> VARI_TIMES;
    public Array<UCD> VARI_MAGS;
    public Array<UCD> VARI_PERIOD;
    public Array<UCD> extra;

    public UCDParser() {
        this.PMRA = new Array();
        this.PMDEC = new Array();
        this.RADVEL = new Array();
        this.SIZE = new Array();
        this.TEFF = new Array();
        this.VARI_TIMES = new Array();
        this.VARI_MAGS = new Array();
        this.VARI_PERIOD = new Array();
        this.extra = new Array();
    }

    public static boolean isName(String colName) {
        return TextUtils.contains(nameColNames, colName, true);
    }

    public static boolean isId(String colName) {
        return TextUtils.contains(idColNames, colName, true);
    }

    public static boolean isRa(String colName) {
        return TextUtils.contains(raColNames, colName, true);
    }

    public static boolean isX(String colName) {
        return TextUtils.contains(xColNames, colName, true);
    }

    public static boolean isDec(String colName) {
        return TextUtils.contains(deColNames, colName, true);
    }

    public static boolean isY(String colName) {
        return TextUtils.contains(yColNames, colName, true);
    }

    public static boolean isDist(String colName) {
        return TextUtils.contains(distColNames, colName, true);
    }

    public static boolean isZ(String colName) {
        return TextUtils.contains(zColNames, colName, true);
    }

    public static boolean isPllx(String colName) {
        return TextUtils.contains(parallaxColNames, colName, true);
    }

    public static boolean isMag(String colName) {
        return TextUtils.contains(magColNames, colName, true);
    }

    public static boolean isColor(String colName) {
        return TextUtils.contains(colorColNames, colName, true);
    }

    public static boolean isTeff(String colName) {
        return TextUtils.contains(tEffColNames, colName, true);
    }

    public static boolean isPmra(String colName) {
        return TextUtils.contains(pmRaColNames, colName, true);
    }

    public static boolean isPmde(String colName) {
        return TextUtils.contains(pmDecColNames, colName, true);
    }

    public static boolean isRadvel(String colName) {
        return TextUtils.contains(radVelColNames, colName, true);
    }

    public static boolean isSize(String colName) {
        return UCDParser.isRadius(colName);
    }

    public static boolean isRadius(String colName) {
        return TextUtils.contains(radiusColNames, colName, true);
    }

    public static boolean isNstars(String colName) {
        return TextUtils.contains(nStarsColNames, colName, true);
    }

    public static boolean isGVariMags(String colName) {
        return TextUtils.contains(variMagsColNames, colName, true);
    }

    public static boolean isGVariTimes(String colName) {
        return TextUtils.contains(variTimesColNames, colName, true);
    }

    public static boolean isPeriod(String colName) {
        return TextUtils.contains(periodColNames, colName, true);
    }

    public void parse(StarTable table) {
        Array<UCD> mag;
        this.ucdmap.clear();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            ColumnInfo col = table.getColumnInfo(i);
            UCD ucd = new UCD(col.getUCD(), col.getName(), col.getUnitString(), i);
            this.addToMap(ucd);
        }
        Array<UCD> meta = this.ucdmap.get((Object)UCD.UCDType.META);
        if (meta != null) {
            for (UCD candidate : meta) {
                if (!TextUtils.contains(candidate.UCDStrings, "meta.id") || candidate.UCDStrings.length <= 1 || !TextUtils.contains(candidate.UCDStrings, "meta.main")) continue;
                this.ID.add((Object)candidate);
            }
        }
        if (this.ID.isEmpty()) {
            this.ID.addAll(this.getByColNames((String[][])new String[][]{idColNames}));
        }
        boolean bl = this.hasId = !this.ID.isEmpty();
        if (this.NAME.isEmpty()) {
            this.NAME.addAll(this.getByColNames(new UCD.UCDType[]{UCD.UCDType.META, UCD.UCDType.UNKNOWN, UCD.UCDType.MISSING}, nameColNames, null));
        }
        this.hasName = !this.NAME.isEmpty();
        Array<UCD> pos = this.ucdmap.get((Object)UCD.UCDType.POS);
        if (pos != null) {
            String posRefSys = this.getBestRefSys(pos);
            for (UCD candidate : pos) {
                String coord;
                String meaning = candidate.UCD[0][1];
                String string = coord = candidate.UCD[0].length > 2 ? candidate.UCD[0][2] : null;
                int derived = this.checkDerivedQuantity(candidate.UCD);
                if (derived != 0 || !meaning.equals(posRefSys) && !meaning.equals("parallax") && !meaning.equals("distance")) continue;
                block9 : switch (meaning) {
                    case "eq": {
                        switch (Objects.requireNonNull(coord)) {
                            case "ra": {
                                this.setDefaultUnit(candidate, "deg");
                                this.add(candidate, raColNames, this.POS1);
                                break block9;
                            }
                            case "dec": {
                                this.setDefaultUnit(candidate, "deg");
                                this.add(candidate, deColNames, this.POS2);
                            }
                        }
                        break;
                    }
                    case "ecliptic": 
                    case "galactic": {
                        switch (Objects.requireNonNull(coord)) {
                            case "lon": {
                                this.setDefaultUnit(candidate, "deg");
                                this.POS1.add((Object)candidate);
                                break block9;
                            }
                            case "lat": {
                                this.setDefaultUnit(candidate, "deg");
                                this.POS2.add((Object)candidate);
                            }
                        }
                        break;
                    }
                    case "cartesian": {
                        this.setDefaultUnit(candidate, "pc");
                        switch (Objects.requireNonNull(coord)) {
                            case "x": {
                                this.POS1.add((Object)candidate);
                                break block9;
                            }
                            case "y": {
                                this.POS2.add((Object)candidate);
                                break block9;
                            }
                            case "z": {
                                this.POS3.add((Object)candidate);
                            }
                        }
                        break;
                    }
                    case "parallax": {
                        this.setDefaultUnit(candidate, "mas");
                        this.add(candidate, parallaxColNames, this.POS3);
                        break;
                    }
                    case "distance": {
                        this.setDefaultUnit(candidate, "pc");
                        this.add(candidate, distColNames, this.POS3);
                    }
                }
            }
        }
        if (this.POS1.isEmpty() || this.POS2.isEmpty()) {
            this.POS1 = this.getByColNames(raColNames, "deg");
            if (!this.POS1.isEmpty()) {
                this.POS2 = this.getByColNames(deColNames, "deg");
                this.POS3 = this.getByColNames(distColNames, "pc");
                if (this.POS3.isEmpty()) {
                    this.POS3 = this.getByColNames(parallaxColNames, "mas");
                }
            }
            if (this.POS1.isEmpty() || this.POS2.isEmpty()) {
                this.POS1 = this.getByColNames(xColNames, "pc");
                this.POS2 = this.getByColNames(yColNames, "pc");
                this.POS3 = this.getByColNames(zColNames, "pc");
            }
        }
        boolean bl2 = this.hasPos = !this.POS1.isEmpty() && !this.POS2.isEmpty();
        if (pos != null) {
            for (UCD candidate : pos) {
                if (!candidate.UCD[0][1].equals("pm")) continue;
                try {
                    String refsys = candidate.UCD[1][1];
                    String coord = candidate.UCD[1][2];
                    if (!refsys.equals("eq")) continue;
                    switch (coord) {
                        case "ra": {
                            this.PMRA.add((Object)candidate);
                            break;
                        }
                        case "dec": {
                            this.PMDEC.add((Object)candidate);
                        }
                    }
                }
                catch (Exception refsys) {}
            }
        }
        if (this.PMRA.isEmpty() || this.PMDEC.isEmpty()) {
            this.PMRA = this.getByColNames(pmRaColNames, "mas/yr");
            if (!this.PMRA.isEmpty()) {
                this.PMDEC = this.getByColNames(pmDecColNames, "mas/yr");
                this.RADVEL = this.getByColNames(radVelColNames, "km/s");
            }
        }
        this.hasPm = !this.PMRA.isEmpty() && !this.PMDEC.isEmpty();
        Array<UCD> spect = this.ucdmap.get((Object)UCD.UCDType.SPECT);
        if (spect != null) {
            for (UCD candidate : spect) {
                if (!candidate.UCD[0][1].equalsIgnoreCase("dopplerVeloc")) continue;
                this.RADVEL.add((Object)candidate);
            }
        }
        if ((mag = this.ucdmap.get((Object)UCD.UCDType.PHOT)) != null) {
            for (UCD candidate : mag) {
                if (!TextUtils.contains(candidate.UCDStrings, "phot.mag") || candidate.UCDStrings.length != 1 && !TextUtils.contains(candidate.UCDStrings, "stat.mean") && !TextUtils.startsWith(candidate.UCDStrings, "em.opt")) continue;
                this.MAG.add((Object)candidate);
            }
        }
        if (this.MAG == null || this.MAG.isEmpty()) {
            this.MAG = this.getByColNames(magColNames, "mag");
        }
        this.hasMag = !this.MAG.isEmpty();
        Array<UCD> col = this.ucdmap.get((Object)UCD.UCDType.PHOT);
        if (col != null) {
            for (UCD candidate : col) {
                if (!candidate.UCD[0][1].equals("color")) continue;
                this.COL.add((Object)candidate);
                break;
            }
        }
        if (this.COL == null || this.COL.isEmpty()) {
            this.COL = this.getByColNames((String[][])new String[][]{colorColNames});
        }
        this.hasColor = !this.COL.isEmpty();
        Array<UCD> phys = this.ucdmap.get((Object)UCD.UCDType.PHYS);
        if (phys != null) {
            for (UCD candidate : phys) {
                if (candidate.UCD[0].length < 2 || !candidate.UCD[0][1].equals("size")) continue;
                this.SIZE.add((Object)candidate);
                break;
            }
        }
        if (this.SIZE == null || this.SIZE.isEmpty()) {
            this.SIZE = this.getByColNames((String[][])new String[][]{radiusColNames, sizeColNames});
        }
        boolean bl3 = this.hasSize = !this.SIZE.isEmpty();
        if (phys != null) {
            for (UCD candidate : phys) {
                if (candidate.UCD[0].length < 3 || !candidate.UCD[0][1].equals("temperature") || !candidate.UCD[0][2].equals("effective")) continue;
                this.TEFF.add((Object)candidate);
                break;
            }
        }
        if (this.TEFF == null || this.TEFF.isEmpty()) {
            this.TEFF = this.getByColNames((String[][])new String[][]{tEffColNames});
        }
        this.hasTEff = !this.TEFF.isEmpty();
        Array<UCD> vari = this.ucdmap.get((Object)UCD.UCDType.VARI);
        if (vari != null) {
            for (UCD candidate : vari) {
                if (candidate.UCD[0].length >= 3 && candidate.UCD[0][1].equals("time")) {
                    this.VARI_TIMES.add((Object)candidate);
                    break;
                }
                if (candidate.UCD[0].length < 3 || !candidate.UCD[0][1].equals("magnitude")) continue;
                this.VARI_MAGS.add((Object)candidate);
                break;
            }
        }
        if (this.VARI_TIMES == null || this.VARI_TIMES.isEmpty()) {
            this.VARI_TIMES = this.getByColNames(variTimesColNames, "d");
        }
        if (this.VARI_MAGS == null || this.VARI_MAGS.isEmpty()) {
            this.VARI_MAGS = this.getByColNames(variMagsColNames, "mag");
        }
        boolean bl4 = this.hasVariability = !this.VARI_MAGS.isEmpty();
        if (this.VARI_PERIOD == null || this.VARI_PERIOD.isEmpty()) {
            this.VARI_PERIOD = this.getByColNames(periodColNames, "d");
        }
        this.hasPeriod = !this.VARI_PERIOD.isEmpty();
        Set<UCD.UCDType> keys = this.ucdmap.keySet();
        for (UCD.UCDType ucdType : keys) {
            Array<UCD> ucds = this.ucdmap.get((Object)ucdType);
            for (UCD ucd : ucds) {
                if (this.has(ucd)) continue;
                this.extra.add((Object)ucd);
            }
        }
    }

    public boolean has(UCD ucd) {
        return this.has(ucd, this.POS1) || this.has(ucd, this.POS2) || this.has(ucd, this.POS3) || this.has(ucd, this.PMRA) || this.has(ucd, this.PMDEC) || this.has(ucd, this.RADVEL) || this.has(ucd, this.ID) || this.has(ucd, this.COL) || this.has(ucd, this.TEFF) || this.has(ucd, this.NAME) || this.has(ucd, this.MAG);
    }

    public boolean has(UCD ucd, Array<UCD> a) {
        return a.contains((Object)ucd, true);
    }

    public Position.PositionType getPositionType(UCD pos1, UCD pos2, UCD pos3) {
        if (pos1.UCD == null || pos2.UCD == null) {
            return Position.PositionType.valueOf("EQ_SPH_" + (pos3 == null ? "PLX" : (UCDParser.isDist(pos3.colName) ? "DIST" : "PLX")));
        }
        String meaning = pos1.UCD[0][1];
        String posTypeStr = null;
        String distType = null;
        Position.PositionType postype = null;
        switch (meaning) {
            case "eq": {
                posTypeStr = "EQ_SPH_";
                break;
            }
            case "ecliptic": {
                posTypeStr = "ECL_SPH_";
                break;
            }
            case "galactic": {
                posTypeStr = "GAL_SPH_";
                break;
            }
            case "cartesian": {
                postype = Position.PositionType.EQ_XYZ;
            }
        }
        if (pos3 != null) {
            switch (meaning = pos3.UCD[0][1]) {
                case "parallax": {
                    distType = "PLX";
                    break;
                }
                case "distance": {
                    distType = "DIST";
                }
            }
        } else {
            distType = "PLX";
        }
        if (postype == null && posTypeStr != null && distType != null) {
            postype = Position.PositionType.valueOf(posTypeStr + distType);
        }
        return postype;
    }

    public UCD getByColumName(String columName) {
        return (UCD)this.getByColNames((String[][])new String[][]{{columName}}).first();
    }

    private Array<UCD> getByColNames(String[] ... ColNames) {
        return this.getByColNames(ColNames, (String)null);
    }

    private Array<UCD> getByColNames(String[] ColNames, String defaultUnit) {
        return this.getByColNames(new UCD.UCDType[]{UCD.UCDType.UNKNOWN, UCD.UCDType.MISSING}, ColNames, defaultUnit);
    }

    private Array<UCD> getByColNames(String[][] ColNames, String defaultUnit) {
        return this.getByColNames(new UCD.UCDType[]{UCD.UCDType.UNKNOWN, UCD.UCDType.MISSING}, ColNames, defaultUnit);
    }

    private Array<UCD> getByColNames(UCD.UCDType[] types, String[] ColNames, String defaultUnit) {
        Array candidates = new Array();
        for (UCD.UCDType type : types) {
            if (!this.ucdmap.containsKey((Object)type)) continue;
            Array<UCD> set = this.ucdmap.get((Object)type);
            for (UCD candidate : set) {
                if (!TextUtils.containsOrMatches(ColNames, candidate.colName, true)) continue;
                if (defaultUnit != null && (candidate.unit == null || candidate.unit.isEmpty())) {
                    candidate.unit = defaultUnit;
                }
                candidates.add((Object)candidate);
            }
        }
        return candidates;
    }

    private Array<UCD> getByColNames(UCD.UCDType[] types, String[][] ColNames, String defaultUnit) {
        Array candidates = new Array();
        for (UCD.UCDType type : types) {
            if (!this.ucdmap.containsKey((Object)type)) continue;
            Array<UCD> set = this.ucdmap.get((Object)type);
            for (UCD candidate : set) {
                if (!TextUtils.containsOrMatches(ColNames, candidate.colName, true)) continue;
                if (defaultUnit != null && (candidate.unit == null || candidate.unit.isEmpty())) {
                    candidate.unit = defaultUnit;
                }
                candidates.add((Object)candidate);
            }
        }
        return candidates;
    }

    private void add(UCD candidate, String[] ColNames, Array<UCD> list) {
        if (candidate.colName != null && TextUtils.contains(ColNames, candidate.colName)) {
            list.insert(0, (Object)candidate);
        } else {
            list.add((Object)candidate);
        }
    }

    private String getBestRefSys(Array<UCD> ucds) {
        boolean eq = false;
        boolean ecl = false;
        boolean gal = false;
        boolean cart = false;
        for (UCD candidate : ucds) {
            eq = eq || candidate.UCD[0][1].equals("eq");
            ecl = ecl || candidate.UCD[0][1].equals("ecliptic");
            gal = gal || candidate.UCD[0][1].equals("galactic");
            cart = cart || candidate.UCD[0][1].equals("cartesian");
        }
        if (eq) {
            return "eq";
        }
        if (gal) {
            return "galactic";
        }
        if (ecl) {
            return "ecliptic";
        }
        if (cart) {
            return "cartesian";
        }
        return "";
    }

    private void setDefaultUnit(UCD candidate, String unit) {
        if (candidate.unit == null) {
            candidate.unit = unit;
        }
    }

    private boolean checkDerivedQuantity(String[][] ucd) {
        for (String[] strings : ucd) {
            if (strings == null || strings.length <= 0) continue;
            if (strings[0].equals("arith") && strings.length > 1 && (strings[1].equals("ratio") || strings[1].equals("factor"))) {
                return true;
            }
            if (!strings[0].equals("stat")) continue;
            return true;
        }
        return false;
    }

    private void addToMap(UCD ucd) {
        if (!this.ucdmap.containsKey((Object)ucd.type)) {
            Array set = new Array(2);
            set.add((Object)ucd);
            this.ucdmap.put(ucd.type, (Array<UCD>)set);
        } else {
            this.ucdmap.get((Object)ucd.type).add((Object)ucd);
        }
    }
}

