/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.units;

import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Vector3D;
import gaiasky.util.units.Quantity;

public class Position {
    public final Vector3D realPosition;

    public Position(double a, String unitA, double b, String unitB, double c, String unitC, PositionType type) throws RuntimeException {
        if (Double.isNaN(c)) {
            c = 0.04;
            unitC = "mas";
        }
        this.realPosition = new Vector3D();
        switch (type.ordinal()) {
            case 0: {
                Quantity.Angle lon = new Quantity.Angle(a, unitA);
                Quantity.Angle lat = new Quantity.Angle(b, unitB);
                Quantity.Length dist = new Quantity.Length(c, unitC);
                if (dist.value_m <= 0.0) {
                    throw new RuntimeException("Negative distance found: " + dist.value_m + " m");
                }
                Coordinates.sphericalToCartesian(lon.get(Quantity.Angle.AngleUnit.RAD), lat.get(Quantity.Angle.AngleUnit.RAD), dist.get(Quantity.Length.LengthUnit.PC), this.realPosition);
                break;
            }
            case 1: {
                Quantity.Angle lon = new Quantity.Angle(a, unitA);
                Quantity.Angle lat = new Quantity.Angle(b, unitB);
                Quantity.Length dist = new Quantity.Angle(c, unitC).getParallaxDistance();
                if (dist.value_m <= 0.0) {
                    throw new RuntimeException("Negative parallax found: " + dist.value_m + " m");
                }
                Coordinates.sphericalToCartesian(lon.get(Quantity.Angle.AngleUnit.RAD), lat.get(Quantity.Angle.AngleUnit.RAD), dist.get(Quantity.Length.LengthUnit.PC), this.realPosition);
                break;
            }
            case 4: {
                Quantity.Angle lon = new Quantity.Angle(a, unitA);
                Quantity.Angle lat = new Quantity.Angle(b, unitB);
                Quantity.Length dist = new Quantity.Length(c, unitC);
                if (dist.value_m <= 0.0) {
                    throw new RuntimeException("Negative distance found: " + dist.value_m + " m");
                }
                Coordinates.sphericalToCartesian(lon.get(Quantity.Angle.AngleUnit.RAD), lat.get(Quantity.Angle.AngleUnit.RAD), dist.get(Quantity.Length.LengthUnit.PC), this.realPosition);
                this.realPosition.mul(Coordinates.galToEq());
                break;
            }
            case 5: {
                Quantity.Angle lon = new Quantity.Angle(a, unitA);
                Quantity.Angle lat = new Quantity.Angle(b, unitB);
                Quantity.Length dist = new Quantity.Angle(c, unitC).getParallaxDistance();
                if (dist.value_m <= 0.0) {
                    throw new RuntimeException("Negative parallax found: " + dist.value_m + " m");
                }
                Coordinates.sphericalToCartesian(lon.get(Quantity.Angle.AngleUnit.RAD), lat.get(Quantity.Angle.AngleUnit.RAD), dist.get(Quantity.Length.LengthUnit.PC), this.realPosition);
                this.realPosition.mul(Coordinates.galToEq());
                break;
            }
            case 2: {
                Quantity.Angle lon = new Quantity.Angle(a, unitA);
                Quantity.Angle lat = new Quantity.Angle(b, unitB);
                Quantity.Length dist = new Quantity.Length(c, unitC);
                if (dist.value_m <= 0.0) {
                    throw new RuntimeException("Negative distance found: " + dist.value_m + " m");
                }
                Coordinates.sphericalToCartesian(lon.get(Quantity.Angle.AngleUnit.RAD), lat.get(Quantity.Angle.AngleUnit.RAD), dist.get(Quantity.Length.LengthUnit.PC), this.realPosition);
                this.realPosition.mul(Coordinates.eclToEq());
                break;
            }
            case 3: {
                Quantity.Angle lon = new Quantity.Angle(a, unitA);
                Quantity.Angle lat = new Quantity.Angle(b, unitB);
                Quantity.Length dist = new Quantity.Angle(c, unitC).getParallaxDistance();
                if (dist.value_m <= 0.0) {
                    throw new RuntimeException("Negative parallax found: " + dist.value_m + " m");
                }
                Coordinates.sphericalToCartesian(lon.get(Quantity.Angle.AngleUnit.RAD), lat.get(Quantity.Angle.AngleUnit.RAD), dist.get(Quantity.Length.LengthUnit.PC), this.realPosition);
                this.realPosition.mul(Coordinates.eclToEq());
                break;
            }
            case 6: {
                Quantity.Length x = new Quantity.Length(a, unitA);
                Quantity.Length y = new Quantity.Length(b, unitB);
                Quantity.Length z = new Quantity.Length(c, unitC);
                this.realPosition.set(x.get(Quantity.Length.LengthUnit.PC), y.get(Quantity.Length.LengthUnit.PC), z.get(Quantity.Length.LengthUnit.PC));
                break;
            }
            case 8: {
                Quantity.Length x = new Quantity.Length(a, unitA);
                Quantity.Length y = new Quantity.Length(b, unitB);
                Quantity.Length z = new Quantity.Length(c, unitC);
                this.realPosition.set(x.get(Quantity.Length.LengthUnit.PC), y.get(Quantity.Length.LengthUnit.PC), z.get(Quantity.Length.LengthUnit.PC));
                this.realPosition.mul(Coordinates.galToEq());
                break;
            }
            case 7: {
                Quantity.Length x = new Quantity.Length(a, unitA);
                Quantity.Length y = new Quantity.Length(b, unitB);
                Quantity.Length z = new Quantity.Length(c, unitC);
                this.realPosition.set(x.get(Quantity.Length.LengthUnit.PC), y.get(Quantity.Length.LengthUnit.PC), z.get(Quantity.Length.LengthUnit.PC));
                this.realPosition.mul(Coordinates.eclToEq());
                break;
            }
        }
    }

    public static enum PositionType {
        EQ_SPH_DIST,
        EQ_SPH_PLX,
        ECL_SPH_DIST,
        ECL_SPH_PLX,
        GAL_SPH_DIST,
        GAL_SPH_PLX,
        EQ_XYZ,
        ECL_XYZ,
        GAL_XYZ;


        public boolean isParallax() {
            return this.equals((Object)EQ_SPH_PLX) || this.equals((Object)ECL_SPH_PLX) || this.equals((Object)GAL_SPH_PLX);
        }
    }
}

